/*
 * Decompiled with CFR 0.152.
 */
package com.sec.xincipher.simkey.kms.asn1;

import java.util.Enumeration;
import java.util.Locale;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import tech.simkey.dove.util.HexStringConvert;
import tech.simkey.dove.util.ParamsEmptyChecker;

public class SymmetricCiphertext
implements ASN1Encodable {
    private int version;
    private int sgdId;
    private boolean padding;
    private byte[] ciphertext;
    private byte[] iv;
    private String keyId;
    private String keyVersion;
    private String protectionLevel;
    private String encryptCardIndex;
    private byte[] userEncKeyCiphertext;
    private byte[] userHmacKeyCiphertext;
    private static final boolean EXPLICIT = true;

    /*
     * WARNING - void declaration
     */
    private SymmetricCiphertext(Builder builder) {
        void var1_1;
        this.version = builder.version;
        this.sgdId = builder.sgdId;
        this.padding = builder.padding;
        this.ciphertext = builder.ciphertext;
        this.iv = builder.iv;
        this.keyId = builder.keyId;
        this.keyVersion = builder.keyVersion;
        this.protectionLevel = builder.protectionLevel;
        this.encryptCardIndex = builder.encryptCardIndex;
        this.userEncKeyCiphertext = builder.userEncKeyCiphertext;
        this.userHmacKeyCiphertext = ((Builder)var1_1).userHmacKeyCiphertext;
    }

    public static SymmetricCiphertext getInstance(Object obj) {
        if (obj instanceof SymmetricCiphertext) {
            return (SymmetricCiphertext)obj;
        }
        if (obj != null) {
            Object object;
            return new SymmetricCiphertext(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public SymmetricCiphertext(int version, int sgdId, boolean padding, byte[] ciphertext, byte[] iv, String keyId, String keyVersion, String protectionLevel, String encryptCardIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.version = var1_1;
        this.sgdId = var2_2;
        this.padding = var3_3;
        this.ciphertext = ciphertext;
        this.iv = iv;
        this.keyId = keyId;
        this.keyVersion = keyVersion;
        this.protectionLevel = protectionLevel;
        this.encryptCardIndex = encryptCardIndex;
    }

    private SymmetricCiphertext(ASN1Sequence seq) {
        Enumeration enumeration;
        if (seq.size() < 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        enumeration = ((ASN1Sequence)((Object)enumeration)).getObjects();
        this.version = ASN1Integer.getInstance(enumeration.nextElement()).getValue().intValue();
        this.sgdId = ASN1Integer.getInstance(enumeration.nextElement()).getValue().intValue();
        this.padding = ASN1Boolean.getInstance(enumeration.nextElement()).isTrue();
        this.ciphertext = DEROctetString.getInstance(enumeration.nextElement()).getOctets();
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            this.dealTaggedObject(aSN1TaggedObject);
        }
    }

    private void dealTaggedObject(ASN1TaggedObject tagged) {
        int n2 = tagged.getTagNo();
        switch (n2) {
            case 0: {
                this.iv = DEROctetString.getInstance(tagged, true).getOctets();
                return;
            }
            case 1: {
                byte[] byArray;
                if (this.version == 1) {
                    this.keyId = DERUTF8String.getInstance(tagged, true).getString();
                    return;
                }
                if ((this.version & 2) == 2) {
                    byArray = DEROctetString.getInstance(tagged, true).getOctets();
                    this.keyId = HexStringConvert.parseByte2HexStr(byArray).toLowerCase(Locale.CHINA);
                    return;
                }
                this.keyId = DERUTF8String.getInstance((ASN1TaggedObject)byArray, true).getString();
                return;
            }
            case 2: {
                byte[] byArray;
                this.keyVersion = DERUTF8String.getInstance((ASN1TaggedObject)byArray, true).getString();
                return;
            }
            case 3: {
                byte[] byArray;
                this.protectionLevel = DERUTF8String.getInstance((ASN1TaggedObject)byArray, true).getString();
                return;
            }
            case 4: {
                byte[] byArray;
                this.encryptCardIndex = DERUTF8String.getInstance((ASN1TaggedObject)byArray, true).getString();
                return;
            }
            case 5: {
                byte[] byArray;
                this.userEncKeyCiphertext = DEROctetString.getInstance((ASN1TaggedObject)byArray, true).getOctets();
                return;
            }
            case 6: {
                byte[] byArray;
                this.userHmacKeyCiphertext = DEROctetString.getInstance((ASN1TaggedObject)byArray, true).getOctets();
            }
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.version));
        aSN1EncodableVector.add(new ASN1Integer(this.sgdId));
        if (this.padding) {
            aSN1EncodableVector.add(ASN1Boolean.TRUE);
        } else {
            aSN1EncodableVector.add(ASN1Boolean.FALSE);
        }
        aSN1EncodableVector.add(new DEROctetString(this.ciphertext));
        if (!ParamsEmptyChecker.isEmpty(this.iv)) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, (ASN1Encodable)new DEROctetString(this.iv)));
        }
        if (!ParamsEmptyChecker.isEmpty(this.keyId)) {
            if (this.version == 2) {
                aSN1EncodableVector.add(new DERTaggedObject(true, 1, (ASN1Encodable)new DEROctetString(HexStringConvert.parseHexStr2Byte(this.keyId))));
            } else {
                aSN1EncodableVector.add(new DERTaggedObject(true, 1, (ASN1Encodable)new DERUTF8String(this.keyId)));
            }
        }
        if (!ParamsEmptyChecker.isEmpty(this.keyVersion)) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 2, (ASN1Encodable)new DERUTF8String(this.keyVersion)));
        }
        if (!ParamsEmptyChecker.isEmpty(this.protectionLevel)) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 3, (ASN1Encodable)new DERUTF8String(this.protectionLevel)));
        }
        if (!ParamsEmptyChecker.isEmpty(this.encryptCardIndex)) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 4, (ASN1Encodable)new DERUTF8String(this.encryptCardIndex)));
        }
        if (!ParamsEmptyChecker.isEmpty(this.userEncKeyCiphertext)) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 5, (ASN1Encodable)new DEROctetString(this.userEncKeyCiphertext)));
        }
        if (!ParamsEmptyChecker.isEmpty(this.userHmacKeyCiphertext)) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 6, (ASN1Encodable)new DEROctetString(this.userHmacKeyCiphertext)));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public int getVersion() {
        return this.version;
    }

    public int getSgdId() {
        return this.sgdId;
    }

    public byte[] getCiphertext() {
        return this.ciphertext;
    }

    public byte[] getIv() {
        if (ParamsEmptyChecker.isEmpty(this.iv)) {
            return new byte[0];
        }
        return this.iv;
    }

    public boolean isPadding() {
        return this.padding;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getKeyVersion() {
        return this.keyVersion;
    }

    public String getProtectionLevel() {
        return this.protectionLevel;
    }

    public String getEncryptCardIndex() {
        return this.encryptCardIndex;
    }

    /*
     * WARNING - void declaration
     */
    public void setUserEncKeyCiphertext(byte[] userEncKeyCiphertext) {
        void var1_1;
        this.userEncKeyCiphertext = var1_1;
    }

    public byte[] getUserEncKeyCiphertext() {
        return this.userEncKeyCiphertext;
    }

    public byte[] getUserHmacKeyCiphertext() {
        return this.userHmacKeyCiphertext;
    }

    /*
     * WARNING - void declaration
     */
    public void setUserHmacKeyCiphertext(byte[] userHmacKeyCiphertext) {
        void var1_1;
        this.userHmacKeyCiphertext = var1_1;
    }

    public void setOutputShort() {
        this.keyVersion = null;
        this.protectionLevel = null;
        this.encryptCardIndex = null;
        this.userEncKeyCiphertext = null;
        this.userHmacKeyCiphertext = null;
    }

    public static final class Builder {
        private int version;
        private int sgdId;
        private boolean padding;
        private byte[] ciphertext;
        private byte[] iv;
        private String keyId;
        private String keyVersion;
        private String protectionLevel;
        private String encryptCardIndex;
        private byte[] userEncKeyCiphertext;
        private byte[] userHmacKeyCiphertext;

        /*
         * WARNING - void declaration
         */
        public final Builder version(int val) {
            void var1_1;
            this.version = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder sgdId(int val) {
            void var1_1;
            this.sgdId = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder padding(boolean val) {
            void var1_1;
            this.padding = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder ciphertext(byte[] val) {
            void var1_1;
            this.ciphertext = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder iv(byte[] val) {
            void var1_1;
            this.iv = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder keyId(String val) {
            void var1_1;
            this.keyId = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder keyVersion(String val) {
            void var1_1;
            this.keyVersion = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder protectionLevel(String val) {
            void var1_1;
            this.protectionLevel = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder encryptCardIndex(String val) {
            void var1_1;
            this.encryptCardIndex = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder userEncKeyCiphertext(byte[] val) {
            void var1_1;
            this.userEncKeyCiphertext = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder userHmacKeyCiphertext(byte[] val) {
            void var1_1;
            this.userHmacKeyCiphertext = var1_1;
            return this;
        }

        public final SymmetricCiphertext build() {
            return new SymmetricCiphertext(this);
        }
    }
}

