/*
 * Decompiled with CFR 0.152.
 */
package com.sec.xincipher.simkey.kms.asn1;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import tech.simkey.dove.util.ParamsEmptyChecker;

public class SymmetricCiphertextBak
implements ASN1Encodable {
    private int version;
    private int sgdId;
    private boolean padding;
    private byte[] ciphertext;
    private byte[] iv;

    public static SymmetricCiphertextBak getInstance(Object obj) {
        if (obj instanceof SymmetricCiphertextBak) {
            return (SymmetricCiphertextBak)obj;
        }
        if (obj != null) {
            Object object;
            return new SymmetricCiphertextBak(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public SymmetricCiphertextBak(int version, int sgdId, boolean padding, byte[] ciphertext, byte[] iv) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.version = var1_1;
        this.sgdId = var2_2;
        this.padding = var3_3;
        this.ciphertext = ciphertext;
        this.iv = iv;
    }

    private SymmetricCiphertextBak(ASN1Sequence seq) {
        Enumeration enumeration;
        if (seq.size() < 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        enumeration = ((ASN1Sequence)((Object)enumeration)).getObjects();
        this.version = ASN1Integer.getInstance(enumeration.nextElement()).getValue().intValue();
        this.sgdId = ASN1Integer.getInstance(enumeration.nextElement()).getValue().intValue();
        this.padding = ASN1Boolean.getInstance(enumeration.nextElement()).isTrue();
        this.ciphertext = DEROctetString.getInstance(enumeration.nextElement()).getOctets();
        if (enumeration.hasMoreElements()) {
            this.iv = DEROctetString.getInstance(enumeration.nextElement()).getOctets();
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.version));
        aSN1EncodableVector.add(new ASN1Integer(this.sgdId));
        if (this.padding) {
            aSN1EncodableVector.add(ASN1Boolean.TRUE);
        } else {
            aSN1EncodableVector.add(ASN1Boolean.FALSE);
        }
        aSN1EncodableVector.add(new DEROctetString(this.ciphertext));
        if (this.iv != null) {
            aSN1EncodableVector.add(new DEROctetString(this.iv));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public int getVersion() {
        return this.version;
    }

    public int getSgdId() {
        return this.sgdId;
    }

    public byte[] getCiphertext() {
        return this.ciphertext;
    }

    public byte[] getIv() {
        if (ParamsEmptyChecker.isEmpty(this.iv)) {
            return new byte[0];
        }
        return this.iv;
    }

    public boolean isPadding() {
        return this.padding;
    }
}

