/*
 * Decompiled with CFR 0.152.
 */
package com.sec.xincipher.simkey.kms.kmssdk.constant;

import com.sec.xincipher.simkey.kms.kmssdk.constant.KeyType;
import com.sec.xincipher.simkey.kms.kmssdk.constant.LegacyAlgorithm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum LegacyKeytype implements KeyType
{
    SM4("SGD_SM4", 128, "SM4", true, true, LegacyAlgorithm.SM4_ECB_NOPADDING, LegacyAlgorithm.SM4_ECB_PKCS5PADDING, LegacyAlgorithm.SM4_CBC_NOPADDING, LegacyAlgorithm.SM4_CBC_PKCS5PADDING),
    AES_128("AES_128", 128, "AES", true, false, LegacyAlgorithm.AES_ECB_NOPADDING, LegacyAlgorithm.AES_ECB_PKCS5PADDING, LegacyAlgorithm.AES_CBC_NOPADDING, LegacyAlgorithm.AES_CBC_PKCS5PADDING),
    AES_192("AES_192", 192, "AES", true, false, LegacyAlgorithm.AES_ECB_NOPADDING, LegacyAlgorithm.AES_ECB_PKCS5PADDING, LegacyAlgorithm.AES_CBC_NOPADDING, LegacyAlgorithm.AES_CBC_PKCS5PADDING),
    AES_256("AES_256", 256, "AES", true, false, LegacyAlgorithm.AES_ECB_NOPADDING, LegacyAlgorithm.AES_ECB_PKCS5PADDING, LegacyAlgorithm.AES_CBC_NOPADDING, LegacyAlgorithm.AES_CBC_PKCS5PADDING),
    DESEDE_112("DESEDE_112", 112, "DESede", true, false, LegacyAlgorithm.DESEDE_ECB_NOPADDING, LegacyAlgorithm.DESEDE_ECB_PKCS5PADDING, LegacyAlgorithm.DESEDE_CBC_NOPADDING, LegacyAlgorithm.DESEDE_CBC_PKCS5PADDING),
    DESEDE_168("DESEDE_168", 168, "DESede", true, false, LegacyAlgorithm.DESEDE_ECB_NOPADDING, LegacyAlgorithm.DESEDE_ECB_PKCS5PADDING, LegacyAlgorithm.DESEDE_CBC_NOPADDING, LegacyAlgorithm.DESEDE_CBC_PKCS5PADDING);

    private final String keytype;
    private final List<LegacyAlgorithm> supportedAlgorithms = new ArrayList<LegacyAlgorithm>();
    private boolean softwareEnable;
    private boolean hardwareEnable;
    private int keyBitSize;
    private String algorithm;

    /*
     * WARNING - void declaration
     */
    private LegacyKeytype(String keytype, int keyBitSize, String algorithm, boolean softwareEnable, boolean hardwareEnable, LegacyAlgorithm ... supportAlgs) {
        void var3_3;
        this.keytype = var3_3;
        if (supportAlgs != null) {
            this.supportedAlgorithms.addAll(Arrays.asList(supportAlgs));
        }
        this.keyBitSize = keyBitSize;
        this.algorithm = algorithm;
        this.softwareEnable = softwareEnable;
        this.hardwareEnable = hardwareEnable;
    }

    @Override
    public final String getKeytype() {
        return this.keytype;
    }

    public final List<LegacyAlgorithm> getSupportedAlgorithms() {
        return this.supportedAlgorithms;
    }

    @Override
    public final boolean isSoftwareEnable() {
        return this.softwareEnable;
    }

    @Override
    public final boolean isHardwareEnable() {
        return this.hardwareEnable;
    }

    public final int getKeyBitSize() {
        return this.keyBitSize;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }
}

