/*
 * Decompiled with CFR 0.152.
 */
package com.sec.xincipher.simkey.kms.kmssdk.impl;

import com.sec.xincipher.simkey.kms.exception.ErrorCodes;
import com.sec.xincipher.simkey.kms.exception.KMSException;
import com.sec.xincipher.simkey.kms.kmssdk.ClientAsymmetricEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientLocalEasyDecryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientLocalEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientLocalEncryptionCloseable;
import com.sec.xincipher.simkey.kms.kmssdk.ClientLocalKDFEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientRemoteEasyDecryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientRemoteEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.ClientSameCiphertextEncryption;
import com.sec.xincipher.simkey.kms.kmssdk.KMSClient;
import com.sec.xincipher.simkey.kms.kmssdk.KMSConfig;
import com.sec.xincipher.simkey.kms.kmssdk.constant.LegacyKeytype;
import com.sec.xincipher.simkey.kms.kmssdk.entity.KMSAsymBizKey;
import com.sec.xincipher.simkey.kms.kmssdk.entity.KMSBizKey;
import com.sec.xincipher.simkey.sdf.MyLong;
import com.sec.xincipher.simkey.sdf.SDF;
import simkey.kms.O;
import simkey.kms.U;
import simkey.kms.V;
import simkey.kms.Y;
import simkey.kms.ac;
import simkey.kms.ad;
import simkey.kms.ae;
import simkey.kms.af;
import simkey.kms.ag;
import simkey.kms.ah;
import simkey.kms.aj;
import tech.simkey.dove.encoding.Base64NoCR;
import tech.simkey.dove.encoding.HexStringConvert;

public final class KMSClientImpl
implements KMSClient {
    private final aj repo;
    private final KMSConfig kmsConfig;

    /*
     * WARNING - void declaration
     */
    public KMSClientImpl(String kmsBaseUrl, String appId, String appSecretEnc) throws KMSException {
        this(KMSConfig.newBuilder().build(), (String)var1_1, (String)var2_2, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public KMSClientImpl(KMSConfig kmsConfig, String kmsBaseUrl, String appId, String appSecretEnc) throws KMSException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.kmsConfig = kmsConfig;
        this.repo = new aj((KMSConfig)var1_1, (String)var2_2, (String)var3_3, this.decryptAppSecretEnc(appSecretEnc));
    }

    /*
     * WARNING - void declaration
     */
    public KMSClientImpl(KMSConfig kmsConfig, String kmsBaseUrl, String appId, String appSecretEnc, boolean decrypt) throws KMSException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.kmsConfig = kmsConfig;
        if (decrypt) {
            this.repo = new aj(kmsConfig, kmsBaseUrl, appId, this.decryptAppSecretEnc(appSecretEnc));
            return;
        }
        this.repo = new aj((KMSConfig)var1_1, (String)var2_2, (String)var3_3, appSecretEnc);
    }

    private String decryptAppSecretEnc(String appSecretEnc) throws KMSException {
        MyLong myLong;
        byte[] byArray;
        byte[] byArray2;
        SDF sDF = O.getSdf();
        int n2 = sDF.AISEC_Simple_Decrypt(byArray2 = Base64NoCR.decode((String)byArray2), byArray2.length, byArray = new byte[16], myLong = new MyLong(16L));
        if (n2 != 0) {
            throw new KMSException(ErrorCodes.APP_KEY_DECRYPT_ERROR);
        }
        return HexStringConvert.parseByte2HexStr(byArray);
    }

    @Override
    public final KMSBizKey genBizKey() throws KMSException {
        KMSBizKey kMSBizKey = new KMSBizKey();
        aj aj2 = this.repo;
        kMSBizKey.setEncKeyId(aj2.a((LegacyKeytype)LegacyKeytype.SM4).keyId);
        aj2 = this.repo;
        kMSBizKey.setHmacKeyId(aj2.b((LegacyKeytype)LegacyKeytype.SM4).keyId);
        return kMSBizKey;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ClientRemoteEncryption useBizkeyRemoteEncryption(String bizEncKeyId, String bizHmacKeyId) {
        void var2_2;
        void var1_1;
        return new Y(this.repo, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ClientLocalEncryption useUserkeyLocalSoftEncryption(String userEncKeyId, String userEncKey, String userHmacKeyId, String userHmacKey) throws KMSException {
        void var3_3;
        void var2_2;
        void var1_1;
        return new ag(this.repo, (String)var1_1, (String)var2_2, (String)var3_3, userHmacKey);
    }

    /*
     * WARNING - void declaration
     */
    public final ClientLocalKDFEncryption UserkeyLocalSoftKDFFileEncryptionEncryption(String userEncKey, String userHmacKey, String kdfEncKey, String kdfHmacKey) throws KMSException {
        void var3_3;
        void var2_2;
        void var1_1;
        return new ah(this.repo, (String)var1_1, (String)var2_2, (String)var3_3, kdfHmacKey);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ClientLocalEncryptionCloseable useUserkeyLocalSDFEncryption(String userEncKeyId, String userEncKey, String userHmacKeyId, String userHmacKey) throws KMSException {
        void var3_3;
        void var2_2;
        void var1_1;
        return new af(this.repo, (String)var1_1, (String)var2_2, (String)var3_3, userHmacKey);
    }

    @Override
    public final KMSAsymBizKey genSM2BizKey() throws KMSException {
        KMSAsymBizKey kMSAsymBizKey = new KMSAsymBizKey();
        kMSAsymBizKey.setEncKeyId(this.repo.t().keyId);
        kMSAsymBizKey.setSignKeyId(this.repo.u().keyId);
        return kMSAsymBizKey;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ClientAsymmetricEncryption useSM2BizkeyRemoteEncryption(String sm2BizEncKeyId, String sm2BizSignKeyId) {
        void var2_2;
        void var1_1;
        return new V(this.repo, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte[] genRandom(int randomBytesLen) throws KMSException {
        void var1_1;
        return this.repo.a((int)var1_1);
    }

    @Override
    public final ClientLocalEasyDecryption useClientLocalEasyDecryptionSoft() {
        return new ad(this);
    }

    @Override
    public final ClientLocalEasyDecryption useClientLocalEasyDecryptionSDF() {
        return new ac(this);
    }

    @Override
    public final ClientRemoteEasyDecryption useClientRemoteEasyDecryption() {
        return new ae(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ClientSameCiphertextEncryption useUserkeySamecipherSoftEncryption(String userEncKeyId, String userEncKey, String userHmacKeyId, String userHmacKey) throws KMSException {
        void var3_3;
        void var2_2;
        void var1_1;
        return new U(this.repo, (String)var1_1, (String)var2_2, (String)var3_3, userHmacKey);
    }
}

