/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.win;

import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;

class WinWindow
extends Window {
    public static final int RESIZE_DISABLE = 0;
    public static final int RESIZE_AROUND_ANCHOR = 1;
    public static final int RESIZE_TO_FX_ORIGIN = 2;
    public static final long ANCHOR_NO_CAPTURE = Long.MIN_VALUE;
    float fxReqWidth;
    float fxReqHeight;
    int pfReqWidth;
    int pfReqHeight;
    private boolean deferredClosing = false;
    private boolean closingRequested = false;

    private static native void _initIDs();

    protected WinWindow(Window window, Screen screen, int n2) {
        super(window, screen, n2);
    }

    protected WinWindow(long l2) {
        super(l2);
    }

    @Override
    public void setBounds(float f2, float f3, boolean bl2, boolean bl3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (bl2 || bl3 || f4 > 0.0f || f5 > 0.0f || f6 > 0.0f || f7 > 0.0f) {
            int n2;
            float f10;
            int n3;
            float f11;
            int n4;
            int n5;
            long l2 = this._getInsets(this.getRawHandle());
            int n6 = (int)(l2 >> 48) & 0xFFFF;
            int n7 = (int)(l2 >> 32) & 0xFFFF;
            int n8 = (int)(l2 >> 16) & 0xFFFF;
            int n9 = (int)l2 & 0xFFFF;
            if (bl2 || bl3) {
                if (bl2) {
                    n5 = this.screen.toPlatformX(f2);
                } else {
                    n5 = this.x;
                    f2 = this.screen.fromPlatformX(n5);
                }
                if (bl3) {
                    n4 = this.screen.toPlatformY(f3);
                } else {
                    n4 = this.y;
                    f3 = this.screen.fromPlatformY(n4);
                }
            } else {
                n5 = this.x;
                n4 = this.y;
            }
            if (f4 > 0.0f) {
                f11 = f4 - (float)(n6 + n8) / this.platformScaleX;
                n3 = (int)Math.ceil(f4 * this.platformScaleX);
            } else {
                f11 = f6 > 0.0f ? f6 : this.fxReqWidth;
                n3 = n6 + n8 + (int)Math.ceil(f11 * this.platformScaleX);
            }
            this.fxReqWidth = f11;
            if (f5 > 0.0f) {
                f10 = f5 - (float)(n7 + n9) / this.platformScaleY;
                n2 = (int)Math.ceil(f5 * this.platformScaleY);
            } else {
                f10 = f7 > 0.0f ? f7 : this.fxReqHeight;
                n2 = n7 + n9 + (int)Math.ceil(f10 * this.platformScaleY);
            }
            this.fxReqHeight = f10;
            long l3 = this._getAnchor(this.getRawHandle());
            int n10 = l3 == Long.MIN_VALUE ? 2 : 1;
            int n11 = (int)(l3 >> 32);
            int n12 = (int)l3;
            int[] nArray = this.notifyMoving(n5, n4, n3, n2, f2, f3, n11, n12, n10, n6, n7, n8, n9);
            if (nArray != null) {
                n5 = nArray[0];
                n4 = nArray[1];
                n3 = nArray[2];
                n2 = nArray[3];
            }
            if (!bl2) {
                boolean bl4 = bl2 = n5 != this.x;
            }
            if (!bl3) {
                bl3 = n4 != this.y;
            }
            this.pfReqWidth = (int)Math.ceil(this.fxReqWidth * this.platformScaleX);
            this.pfReqHeight = (int)Math.ceil(this.fxReqHeight * this.platformScaleY);
            this._setBounds(this.getRawHandle(), n5, n4, bl2, bl3, n3, n2, 0, 0, f8, f9);
        }
    }

    protected int[] notifyMoving(int n2, int n3, int n4, int n5, float f2, float f3, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        if (this.screen == null || !this.screen.containsPlatformRect(n2, n3, n4, n5)) {
            float f4;
            float f5 = f4 = this.screen == null ? 0.0f : this.screen.portionIntersectsPlatformRect(n2, n3, n4, n5);
            if (f4 < 0.5f) {
                float f6 = (float)n6 / this.platformScaleX;
                float f7 = (float)n7 / this.platformScaleY;
                Screen screen = this.screen;
                int n13 = n2;
                int n14 = n3;
                int n15 = n4;
                int n16 = n5;
                for (Screen screen2 : Screen.getScreens()) {
                    int n17;
                    int n18;
                    int n19;
                    int n20;
                    if (screen2 == this.screen) continue;
                    if (n8 == 0) {
                        n20 = n2;
                        n19 = n3;
                        n18 = n4;
                        n17 = n5;
                    } else {
                        int n21 = (int)Math.ceil(this.fxReqWidth * screen2.getPlatformScaleX());
                        int n22 = (int)Math.ceil(this.fxReqHeight * screen2.getPlatformScaleY());
                        n18 = n21 + n9 + n11;
                        n17 = n22 + n10 + n12;
                        if (n8 == 1) {
                            n20 = n2 + n6 - Math.round(f6 * screen2.getPlatformScaleX());
                            n19 = n3 + n7 - Math.round(f7 * screen2.getPlatformScaleY());
                        } else {
                            n20 = screen2.toPlatformX(f2);
                            n19 = screen2.toPlatformY(f3);
                        }
                    }
                    float f8 = screen2.portionIntersectsPlatformRect(n20, n19, n18, n17);
                    if (this.screen != null && (!(f8 > 0.6f) || !(f8 > f4))) continue;
                    f4 = f8;
                    screen = screen2;
                    n13 = n20;
                    n14 = n19;
                    n15 = n18;
                    n16 = n17;
                }
                if (screen != this.screen) {
                    this.notifyMoveToAnotherScreen(screen);
                    this.notifyScaleChanged(screen.getPlatformScaleX(), screen.getPlatformScaleY(), screen.getRecommendedOutputScaleX(), screen.getRecommendedOutputScaleY());
                    this.view.updateLocation();
                    if (n8 == 0) {
                        return null;
                    }
                    return new int[]{n13, n14, n15, n16};
                }
            }
        }
        return null;
    }

    @Override
    protected void notifyResize(int n2, int n3, int n4) {
        float f2 = this.platformScaleX;
        float f3 = this.platformScaleY;
        long l2 = this._getInsets(this.getRawHandle());
        int n5 = (int)(l2 >> 48) & 0xFFFF;
        int n6 = (int)(l2 >> 32) & 0xFFFF;
        int n7 = (int)(l2 >> 16) & 0xFFFF;
        int n8 = (int)l2 & 0xFFFF;
        int n9 = n3 - n5 - n7;
        int n10 = n4 - n6 - n8;
        if (n9 != this.pfReqWidth || f2 != this.platformScaleX) {
            this.fxReqWidth = (float)n9 / this.platformScaleX;
            this.pfReqWidth = n9;
        }
        if (n10 != this.pfReqHeight || f3 != this.platformScaleY) {
            this.fxReqHeight = (float)n10 / this.platformScaleY;
            this.pfReqHeight = n10;
        }
        super.notifyResize(n2, n3, n4);
    }

    protected native boolean _setBackground2(long var1, float var3, float var4, float var5);

    @Override
    protected boolean _setBackground(long l2, float f2, float f3, float f4) {
        if (this.getAppletMode()) {
            return this._setBackground2(l2, f2, f3, f4);
        }
        return true;
    }

    private native long _getInsets(long var1);

    private native long _getAnchor(long var1);

    @Override
    protected native long _createWindow(long var1, long var3, int var5);

    @Override
    protected native long _createChildWindow(long var1);

    @Override
    protected native boolean _close(long var1);

    @Override
    protected native boolean _setView(long var1, View var3);

    @Override
    protected native boolean _setMenubar(long var1, long var3);

    @Override
    protected native boolean _minimize(long var1, boolean var3);

    @Override
    protected native boolean _maximize(long var1, boolean var3, boolean var4);

    @Override
    protected native void _setBounds(long var1, int var3, int var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, float var11, float var12);

    @Override
    protected native boolean _setVisible(long var1, boolean var3);

    @Override
    protected native boolean _setResizable(long var1, boolean var3);

    @Override
    protected native boolean _requestFocus(long var1, int var3);

    @Override
    protected native void _setFocusable(long var1, boolean var3);

    @Override
    protected native boolean _setTitle(long var1, String var3);

    @Override
    protected native void _setLevel(long var1, int var3);

    @Override
    protected native void _setAlpha(long var1, float var3);

    @Override
    protected native void _setEnabled(long var1, boolean var3);

    @Override
    protected native boolean _setMinimumSize(long var1, int var3, int var4);

    @Override
    protected native boolean _setMaximumSize(long var1, int var3, int var4);

    @Override
    protected native void _setIcon(long var1, Pixels var3);

    @Override
    protected native void _toFront(long var1);

    @Override
    protected native void _toBack(long var1);

    @Override
    protected native void _enterModal(long var1);

    @Override
    protected native void _enterModalWithWindow(long var1, long var3);

    @Override
    protected native void _exitModal(long var1);

    @Override
    protected native boolean _grabFocus(long var1);

    @Override
    protected native void _ungrabFocus(long var1);

    @Override
    protected native int _getEmbeddedX(long var1);

    @Override
    protected native int _getEmbeddedY(long var1);

    @Override
    protected native void _setCursor(long var1, Cursor var3);

    @Override
    protected void _requestInput(long l2, String string, int n2, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void _releaseInput(long l2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void setDeferredClosing(boolean bl2) {
        this.deferredClosing = bl2;
        if (!this.deferredClosing && this.closingRequested) {
            this.close();
        }
    }

    @Override
    public void close() {
        if (!this.deferredClosing) {
            super.close();
        } else {
            this.closingRequested = true;
            this.setVisible(false);
        }
    }

    static {
        WinWindow._initIDs();
    }
}

