/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.Helpers;

final class Curve {
    float ax;
    float ay;
    float bx;
    float by;
    float cx;
    float cy;
    float dx;
    float dy;
    float dax;
    float day;
    float dbx;
    float dby;

    Curve() {
    }

    void set(float[] fArray, int n2) {
        if (n2 == 8) {
            this.set(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
        } else if (n2 == 4) {
            this.set(fArray[0], fArray[1], fArray[2], fArray[3]);
        } else {
            this.set(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
        }
    }

    void set(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = 3.0f * (f6 - f4);
        float f11 = 3.0f * (f7 - f5);
        float f12 = 3.0f * (f4 - f2);
        float f13 = 3.0f * (f5 - f3);
        this.ax = f8 - f2 - f10;
        this.ay = f9 - f3 - f11;
        this.bx = f10 - f12;
        this.by = f11 - f13;
        this.cx = f12;
        this.cy = f13;
        this.dx = f2;
        this.dy = f3;
        this.dax = 3.0f * this.ax;
        this.day = 3.0f * this.ay;
        this.dbx = 2.0f * this.bx;
        this.dby = 2.0f * this.by;
    }

    void set(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f4 - f2;
        float f9 = f5 - f3;
        this.ax = 0.0f;
        this.ay = 0.0f;
        this.bx = f6 - f4 - f8;
        this.by = f7 - f5 - f9;
        this.cx = 2.0f * f8;
        this.cy = 2.0f * f9;
        this.dx = f2;
        this.dy = f3;
        this.dax = 0.0f;
        this.day = 0.0f;
        this.dbx = 2.0f * this.bx;
        this.dby = 2.0f * this.by;
    }

    void set(float f2, float f3, float f4, float f5) {
        float f6 = f4 - f2;
        float f7 = f5 - f3;
        this.ax = 0.0f;
        this.ay = 0.0f;
        this.bx = 0.0f;
        this.by = 0.0f;
        this.cx = f6;
        this.cy = f7;
        this.dx = f2;
        this.dy = f3;
        this.dax = 0.0f;
        this.day = 0.0f;
        this.dbx = 0.0f;
        this.dby = 0.0f;
    }

    int dxRoots(float[] fArray, int n2) {
        return Helpers.quadraticRoots(this.dax, this.dbx, this.cx, fArray, n2);
    }

    int dyRoots(float[] fArray, int n2) {
        return Helpers.quadraticRoots(this.day, this.dby, this.cy, fArray, n2);
    }

    int infPoints(float[] fArray, int n2) {
        float f2 = this.dax * this.dby - this.dbx * this.day;
        float f3 = 2.0f * (this.cy * this.dax - this.day * this.cx);
        float f4 = this.cy * this.dbx - this.cx * this.dby;
        return Helpers.quadraticRoots(f2, f3, f4, fArray, n2);
    }

    int xPoints(float[] fArray, int n2, float f2) {
        return Helpers.cubicRootsInAB(this.ax, this.bx, this.cx, this.dx - f2, fArray, n2, 0.0f, 1.0f);
    }

    int yPoints(float[] fArray, int n2, float f2) {
        return Helpers.cubicRootsInAB(this.ay, this.by, this.cy, this.dy - f2, fArray, n2, 0.0f, 1.0f);
    }

    private int perpendiculardfddf(float[] fArray, int n2) {
        assert (fArray.length >= n2 + 4);
        float f2 = 2.0f * (this.dax * this.dax + this.day * this.day);
        float f3 = 3.0f * (this.dax * this.dbx + this.day * this.dby);
        float f4 = 2.0f * (this.dax * this.cx + this.day * this.cy) + this.dbx * this.dbx + this.dby * this.dby;
        float f5 = this.dbx * this.cx + this.dby * this.cy;
        return Helpers.cubicRootsInAB(f2, f3, f4, f5, fArray, n2, 0.0f, 1.0f);
    }

    int rootsOfROCMinusW(float[] fArray, int n2, float f2, float f3) {
        assert (n2 <= 6 && fArray.length >= 10);
        int n3 = n2;
        int n4 = n2 + this.perpendiculardfddf(fArray, n2);
        fArray[n4] = 1.0f;
        float f4 = 0.0f;
        float f5 = this.ROCsq(f4) - f2;
        for (int i2 = n2; i2 <= n4; ++i2) {
            float f6 = fArray[i2];
            float f7 = this.ROCsq(f6) - f2;
            if (f5 == 0.0f) {
                fArray[n3++] = f4;
            } else if (f7 * f5 < 0.0f) {
                fArray[n3++] = this.falsePositionROCsqMinusX(f4, f6, f2, f3);
            }
            f4 = f6;
            f5 = f7;
        }
        return n3 - n2;
    }

    private static float eliminateInf(float f2) {
        return f2 == Float.POSITIVE_INFINITY ? Float.MAX_VALUE : (f2 == Float.NEGATIVE_INFINITY ? Float.MIN_VALUE : f2);
    }

    private float falsePositionROCsqMinusX(float f2, float f3, float f4, float f5) {
        int n2 = 0;
        float f6 = f3;
        float f7 = Curve.eliminateInf(this.ROCsq(f6) - f4);
        float f8 = f2;
        float f9 = Curve.eliminateInf(this.ROCsq(f8) - f4);
        float f10 = f8;
        for (int i2 = 0; i2 < 100 && Math.abs(f6 - f8) > f5 * Math.abs(f6 + f8); ++i2) {
            f10 = (f9 * f6 - f7 * f8) / (f9 - f7);
            float f11 = this.ROCsq(f10) - f4;
            if (Curve.sameSign(f11, f7)) {
                f7 = f11;
                f6 = f10;
                if (n2 < 0) {
                    f9 /= (float)(1 << -n2);
                    --n2;
                    continue;
                }
                n2 = -1;
                continue;
            }
            if (!(f11 * f9 > 0.0f)) break;
            f9 = f11;
            f8 = f10;
            if (n2 > 0) {
                f7 /= (float)(1 << n2);
                ++n2;
                continue;
            }
            n2 = 1;
        }
        return f10;
    }

    private static boolean sameSign(float f2, float f3) {
        return f2 < 0.0f && f3 < 0.0f || f2 > 0.0f && f3 > 0.0f;
    }

    private float ROCsq(float f2) {
        float f3 = f2 * (f2 * this.dax + this.dbx) + this.cx;
        float f4 = f2 * (f2 * this.day + this.dby) + this.cy;
        float f5 = 2.0f * this.dax * f2 + this.dbx;
        float f6 = 2.0f * this.day * f2 + this.dby;
        float f7 = f3 * f3 + f4 * f4;
        float f8 = f5 * f5 + f6 * f6;
        float f9 = f5 * f3 + f6 * f4;
        return f7 * (f7 * f7 / (f7 * f8 - f9 * f9));
    }
}

