/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.DPathConsumer2D;

public final class DCollinearSimplifier
implements DPathConsumer2D {
    static final double EPS = 1.0E-4;
    DPathConsumer2D delegate;
    SimplifierState state;
    double px1;
    double py1;
    double px2;
    double py2;
    double pslope;

    DCollinearSimplifier() {
    }

    public DCollinearSimplifier init(DPathConsumer2D dPathConsumer2D) {
        this.delegate = dPathConsumer2D;
        this.state = SimplifierState.Empty;
        return this;
    }

    @Override
    public void pathDone() {
        this.emitStashedLine();
        this.state = SimplifierState.Empty;
        this.delegate.pathDone();
    }

    @Override
    public void closePath() {
        this.emitStashedLine();
        this.state = SimplifierState.Empty;
        this.delegate.closePath();
    }

    @Override
    public void quadTo(double d2, double d3, double d4, double d5) {
        this.emitStashedLine();
        this.delegate.quadTo(d2, d3, d4, d5);
        this.state = SimplifierState.PreviousPoint;
        this.px1 = d4;
        this.py1 = d5;
    }

    @Override
    public void curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.emitStashedLine();
        this.delegate.curveTo(d2, d3, d4, d5, d6, d7);
        this.state = SimplifierState.PreviousPoint;
        this.px1 = d6;
        this.py1 = d7;
    }

    @Override
    public void moveTo(double d2, double d3) {
        this.emitStashedLine();
        this.delegate.moveTo(d2, d3);
        this.state = SimplifierState.PreviousPoint;
        this.px1 = d2;
        this.py1 = d3;
    }

    @Override
    public void lineTo(double d2, double d3) {
        switch (this.state) {
            case Empty: {
                this.delegate.lineTo(d2, d3);
                this.state = SimplifierState.PreviousPoint;
                this.px1 = d2;
                this.py1 = d3;
                return;
            }
            case PreviousPoint: {
                this.state = SimplifierState.PreviousLine;
                this.px2 = d2;
                this.py2 = d3;
                this.pslope = DCollinearSimplifier.getSlope(this.px1, this.py1, d2, d3);
                return;
            }
            case PreviousLine: {
                double d4 = DCollinearSimplifier.getSlope(this.px2, this.py2, d2, d3);
                if (d4 == this.pslope || Math.abs(this.pslope - d4) < 1.0E-4) {
                    this.px2 = d2;
                    this.py2 = d3;
                    return;
                }
                this.delegate.lineTo(this.px2, this.py2);
                this.px1 = this.px2;
                this.py1 = this.py2;
                this.px2 = d2;
                this.py2 = d3;
                this.pslope = d4;
                return;
            }
        }
    }

    private void emitStashedLine() {
        if (this.state == SimplifierState.PreviousLine) {
            this.delegate.lineTo(this.px2, this.py2);
        }
    }

    private static double getSlope(double d2, double d3, double d4, double d5) {
        double d6 = d5 - d3;
        if (d6 == 0.0) {
            return d4 > d2 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        return (d4 - d2) / d6;
    }

    static enum SimplifierState {
        Empty,
        PreviousPoint,
        PreviousLine;

    }
}

