/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.ByteArrayCache;
import com.sun.marlin.DCollinearSimplifier;
import com.sun.marlin.DCurve;
import com.sun.marlin.DDasher;
import com.sun.marlin.DPathSimplifier;
import com.sun.marlin.DRenderer;
import com.sun.marlin.DRendererNoAA;
import com.sun.marlin.DStroker;
import com.sun.marlin.DTransformingPathConsumer2D;
import com.sun.marlin.DoubleArrayCache;
import com.sun.marlin.IntArrayCache;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import com.sun.marlin.MaskMarlinAlphaConsumer;
import com.sun.marlin.OffHeapArray;
import com.sun.marlin.RendererStats;
import com.sun.util.reentrant.ReentrantContext;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;

public final class DRendererContext
extends ReentrantContext
implements MarlinConst {
    private static final AtomicInteger CTX_COUNT = new AtomicInteger(1);
    private final Object cleanerObj;
    public boolean dirty = false;
    public final float[] float6 = new float[6];
    final DCurve curve = new DCurve();
    public final DTransformingPathConsumer2D transformerPC2D;
    private WeakReference<Path2D> refPath2D = null;
    public final DRenderer renderer;
    public final DStroker stroker;
    public final DCollinearSimplifier simplifier = new DCollinearSimplifier();
    public final DPathSimplifier pathSimplifier = new DPathSimplifier();
    public final DDasher dasher;
    int stroking = 0;
    public boolean doClip = false;
    boolean closedPath = false;
    public final double[] clipRect = new double[4];
    public double clipInvScale = 0.0;
    public final DTransformingPathConsumer2D.CurveBasicMonotonizer monotonizer;
    final DTransformingPathConsumer2D.CurveClipSplitter curveClipSplitter;
    final DRendererSharedMemory rdrMem;
    private DRendererNoAA rendererNoAA = null;
    public final Rectangle clip = new Rectangle();
    public MaskMarlinAlphaConsumer consumer = null;
    private final IntArrayCache cleanIntCache = new IntArrayCache(true, 5);
    private final IntArrayCache dirtyIntCache = new IntArrayCache(false, 5);
    private final DoubleArrayCache dirtyDoubleCache = new DoubleArrayCache(false, 4);
    private final ByteArrayCache dirtyByteCache = new ByteArrayCache(false, 2);
    final RendererStats stats;

    public static DRendererContext createContext() {
        return new DRendererContext("ctx" + Integer.toString(CTX_COUNT.getAndIncrement()));
    }

    DRendererContext(String string) {
        if (LOG_CREATE_CONTEXT) {
            MarlinUtils.logInfo("new RendererContext = " + string);
        }
        this.cleanerObj = new Object();
        if (DO_STATS) {
            this.stats = RendererStats.createInstance(this.cleanerObj, string);
            this.stats.cacheStats = new ArrayCacheConst.CacheStats[]{this.cleanIntCache.stats, this.dirtyIntCache.stats, this.dirtyDoubleCache.stats, this.dirtyByteCache.stats};
        } else {
            this.stats = null;
        }
        this.monotonizer = new DTransformingPathConsumer2D.CurveBasicMonotonizer(this);
        this.curveClipSplitter = new DTransformingPathConsumer2D.CurveClipSplitter(this);
        this.transformerPC2D = new DTransformingPathConsumer2D(this);
        this.rdrMem = new DRendererSharedMemory(this);
        this.renderer = new DRenderer(this);
        this.stroker = new DStroker(this);
        this.dasher = new DDasher(this);
    }

    public void dispose() {
        if (DO_STATS) {
            if (this.stats.totalOffHeap > this.stats.totalOffHeapMax) {
                this.stats.totalOffHeapMax = this.stats.totalOffHeap;
            }
            this.stats.totalOffHeap = 0L;
        }
        this.stroking = 0;
        this.doClip = false;
        this.closedPath = false;
        this.clipInvScale = 0.0;
        if (this.dirty) {
            this.dasher.dispose();
            this.stroker.dispose();
            this.dirty = false;
        }
    }

    public Path2D getPath2D() {
        Path2D path2D;
        Path2D path2D2 = path2D = this.refPath2D != null ? (Path2D)this.refPath2D.get() : null;
        if (path2D == null) {
            path2D = new Path2D(1, INITIAL_EDGES_COUNT);
            this.refPath2D = new WeakReference<Path2D>(path2D);
        }
        path2D.reset();
        return path2D;
    }

    public DRendererNoAA getRendererNoAA() {
        if (this.rendererNoAA == null) {
            this.rendererNoAA = new DRendererNoAA(this);
        }
        return this.rendererNoAA;
    }

    OffHeapArray newOffHeapArray(long l2) {
        if (DO_STATS) {
            this.stats.totalOffHeapInitial += l2;
        }
        return new OffHeapArray(this.cleanerObj, l2);
    }

    IntArrayCache.Reference newCleanIntArrayRef(int n2) {
        return this.cleanIntCache.createRef(n2);
    }

    IntArrayCache.Reference newDirtyIntArrayRef(int n2) {
        return this.dirtyIntCache.createRef(n2);
    }

    DoubleArrayCache.Reference newDirtyDoubleArrayRef(int n2) {
        return this.dirtyDoubleCache.createRef(n2);
    }

    ByteArrayCache.Reference newDirtyByteArrayRef(int n2) {
        return this.dirtyByteCache.createRef(n2);
    }

    static final class DRendererSharedMemory {
        final OffHeapArray edges;
        final IntArrayCache.Reference edgeBuckets_ref;
        final IntArrayCache.Reference edgeBucketCounts_ref;
        final IntArrayCache.Reference alphaLine_ref;
        final IntArrayCache.Reference crossings_ref;
        final IntArrayCache.Reference edgePtrs_ref;
        final IntArrayCache.Reference aux_crossings_ref;
        final IntArrayCache.Reference aux_edgePtrs_ref;
        final IntArrayCache.Reference blkFlags_ref;

        DRendererSharedMemory(DRendererContext dRendererContext) {
            this.edges = dRendererContext.newOffHeapArray(MarlinConst.INITIAL_EDGES_CAPACITY);
            this.edgeBuckets_ref = dRendererContext.newCleanIntArrayRef(MarlinConst.INITIAL_BUCKET_ARRAY);
            this.edgeBucketCounts_ref = dRendererContext.newCleanIntArrayRef(MarlinConst.INITIAL_BUCKET_ARRAY);
            this.alphaLine_ref = dRendererContext.newCleanIntArrayRef(MarlinConst.INITIAL_AA_ARRAY);
            this.crossings_ref = dRendererContext.newDirtyIntArrayRef(MarlinConst.INITIAL_CROSSING_COUNT);
            this.aux_crossings_ref = dRendererContext.newDirtyIntArrayRef(MarlinConst.INITIAL_CROSSING_COUNT);
            this.edgePtrs_ref = dRendererContext.newDirtyIntArrayRef(MarlinConst.INITIAL_CROSSING_COUNT);
            this.aux_edgePtrs_ref = dRendererContext.newDirtyIntArrayRef(MarlinConst.INITIAL_CROSSING_COUNT);
            this.blkFlags_ref = dRendererContext.newCleanIntArrayRef(256);
        }
    }
}

