/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.javafx.geom.PathConsumer2D;
import com.sun.marlin.FloatArrayCache;
import com.sun.marlin.FloatMath;
import com.sun.marlin.Helpers;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinProperties;
import com.sun.marlin.RendererContext;
import com.sun.marlin.TransformingPathConsumer2D;

public final class Dasher
implements PathConsumer2D,
MarlinConst {
    static final int REC_LIMIT = 16;
    static final float CURVE_LEN_ERR = MarlinProperties.getCurveLengthError();
    static final float MIN_T_INC = 1.5258789E-5f;
    static final float MAX_CYCLES = 1.6E7f;
    private PathConsumer2D out;
    private float[] dash;
    private int dashLen;
    private float startPhase;
    private boolean startDashOn;
    private int startIdx;
    private boolean starting;
    private boolean needsMoveTo;
    private int idx;
    private boolean dashOn;
    private float phase;
    private float sx0;
    private float sy0;
    private float cx0;
    private float cy0;
    private final float[] curCurvepts;
    final RendererContext rdrCtx;
    boolean recycleDashes;
    private float[] firstSegmentsBuffer;
    private int firstSegidx;
    final FloatArrayCache.Reference dashes_ref;
    final FloatArrayCache.Reference firstSegmentsBuffer_ref;
    private float[] clipRect;
    private int cOutCode = 0;
    private boolean subdivide = DO_CLIP_SUBDIVIDER;
    private final LengthIterator li = new LengthIterator();
    private final TransformingPathConsumer2D.CurveClipSplitter curveSplitter;
    private float cycleLen;
    private boolean outside;
    private float totalSkipLen;

    Dasher(RendererContext rendererContext) {
        this.rdrCtx = rendererContext;
        this.dashes_ref = rendererContext.newDirtyFloatArrayRef(256);
        this.firstSegmentsBuffer_ref = rendererContext.newDirtyFloatArrayRef(256);
        this.firstSegmentsBuffer = this.firstSegmentsBuffer_ref.initial;
        this.curCurvepts = new float[16];
        this.curveSplitter = rendererContext.curveClipSplitter;
    }

    public Dasher init(PathConsumer2D pathConsumer2D, float[] fArray, int n2, float f2, boolean bl2) {
        this.out = pathConsumer2D;
        int n3 = 0;
        this.dashOn = true;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            f3 += fArray[i2];
        }
        this.cycleLen = f3;
        float f4 = f2 / f3;
        if (f2 < 0.0f) {
            if (-f4 >= 1.6E7f) {
                f2 = 0.0f;
            } else {
                int n4 = FloatMath.floor_int(-f4);
                if ((n4 & n2 & 1) != 0) {
                    this.dashOn = !this.dashOn;
                }
                f2 += (float)n4 * f3;
                while (f2 < 0.0f) {
                    if (--n3 < 0) {
                        n3 = n2 - 1;
                    }
                    f2 += fArray[n3];
                    this.dashOn = !this.dashOn;
                }
            }
        } else if (f2 > 0.0f) {
            if (f4 >= 1.6E7f) {
                f2 = 0.0f;
            } else {
                int n5 = FloatMath.floor_int(f4);
                if ((n5 & n2 & 1) != 0) {
                    this.dashOn = !this.dashOn;
                }
                f2 -= (float)n5 * f3;
                while (true) {
                    float f5;
                    float f6 = fArray[n3];
                    if (!(f2 >= f5)) break;
                    f2 -= f6;
                    n3 = (n3 + 1) % n2;
                    this.dashOn = !this.dashOn;
                }
            }
        }
        this.dash = fArray;
        this.dashLen = n2;
        this.phase = f2;
        this.startPhase = f2;
        this.startDashOn = this.dashOn;
        this.startIdx = n3;
        this.starting = true;
        this.needsMoveTo = false;
        this.firstSegidx = 0;
        this.recycleDashes = bl2;
        if (this.rdrCtx.doClip) {
            this.clipRect = this.rdrCtx.clipRect;
        } else {
            this.clipRect = null;
            this.cOutCode = 0;
        }
        return this;
    }

    void dispose() {
        if (this.recycleDashes) {
            this.dash = this.dashes_ref.putArray(this.dash);
        }
        this.firstSegmentsBuffer = this.firstSegmentsBuffer_ref.putArray(this.firstSegmentsBuffer);
    }

    public float[] copyDashArray(float[] fArray) {
        float[] fArray2;
        int n2 = fArray.length;
        if (n2 <= 256) {
            fArray2 = this.dashes_ref.initial;
        } else {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_array_dasher_dasher.add(n2);
            }
            fArray2 = this.dashes_ref.getArray(n2);
        }
        System.arraycopy(fArray, 0, fArray2, 0, n2);
        return fArray2;
    }

    @Override
    public void moveTo(float f2, float f3) {
        if (this.firstSegidx != 0) {
            this.out.moveTo(this.sx0, this.sy0);
            this.emitFirstSegments();
        }
        this.needsMoveTo = true;
        this.idx = this.startIdx;
        this.dashOn = this.startDashOn;
        this.phase = this.startPhase;
        this.cx0 = f2;
        this.cy0 = f3;
        this.sx0 = f2;
        this.sy0 = f3;
        this.starting = true;
        if (this.clipRect != null) {
            int n2;
            this.cOutCode = n2 = Helpers.outcode(f2, f3, this.clipRect);
            this.outside = false;
            this.totalSkipLen = 0.0f;
        }
    }

    private void emitSeg(float[] fArray, int n2, int n3) {
        switch (n3) {
            case 4: {
                this.out.lineTo(fArray[n2], fArray[n2 + 1]);
                return;
            }
            case 8: {
                this.out.curveTo(fArray[n2], fArray[n2 + 1], fArray[n2 + 2], fArray[n2 + 3], fArray[n2 + 4], fArray[n2 + 5]);
                return;
            }
            case 6: {
                this.out.quadTo(fArray[n2], fArray[n2 + 1], fArray[n2 + 2], fArray[n2 + 3]);
                return;
            }
        }
    }

    private void emitFirstSegments() {
        int n2;
        float[] fArray = this.firstSegmentsBuffer;
        int n3 = this.firstSegidx;
        for (int i2 = 0; i2 < n3; i2 += n2 - 1) {
            n2 = (int)fArray[i2];
            this.emitSeg(fArray, i2 + 1, n2);
        }
        this.firstSegidx = 0;
    }

    private void goTo(float[] fArray, int n2, int n3, boolean bl2) {
        int n4 = n2 + n3;
        float f2 = fArray[n4 - 4];
        float f3 = fArray[n4 - 3];
        if (bl2) {
            if (this.starting) {
                this.goTo_starting(fArray, n2, n3);
            } else {
                if (this.needsMoveTo) {
                    this.needsMoveTo = false;
                    this.out.moveTo(this.cx0, this.cy0);
                }
                this.emitSeg(fArray, n2, n3);
            }
        } else {
            if (this.starting) {
                this.starting = false;
            }
            this.needsMoveTo = true;
        }
        this.cx0 = f2;
        this.cy0 = f3;
    }

    private void goTo_starting(float[] fArray, int n2, int n3) {
        int n4 = this.firstSegidx;
        int n5 = n3 - 1;
        float[] fArray2 = this.firstSegmentsBuffer;
        if (n4 + n5 > fArray2.length) {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_array_dasher_firstSegmentsBuffer.add(n4 + n5);
            }
            this.firstSegmentsBuffer = fArray2 = this.firstSegmentsBuffer_ref.widenArray(fArray2, n4, n4 + n5);
        }
        fArray2[n4++] = n3;
        System.arraycopy(fArray, n2, fArray2, n4, --n5);
        this.firstSegidx = n4 + n5;
    }

    @Override
    public void lineTo(float f2, float f3) {
        int n2 = this.cOutCode;
        if (this.clipRect != null) {
            int n3 = Helpers.outcode(f2, f3, this.clipRect);
            int n4 = n2 | n3;
            if (n4 != 0) {
                int n5 = n2 & n3;
                if (n5 == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean bl2 = this.curveSplitter.splitLine(this.cx0, this.cy0, f2, f3, n4, this);
                        this.subdivide = true;
                        if (bl2) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n3;
                    this.skipLineTo(f2, f3);
                    return;
                }
            }
            this.cOutCode = n3;
            if (this.outside) {
                this.outside = false;
                this.skipLen();
            }
        }
        this._lineTo(f2, f3);
    }

    private void _lineTo(float f2, float f3) {
        float f4 = f2 - this.cx0;
        float f5 = f3 - this.cy0;
        float f6 = f4 * f4 + f5 * f5;
        if (f6 == 0.0f) {
            return;
        }
        f6 = (float)Math.sqrt(f6);
        float f7 = f4 / f6;
        float f8 = f5 / f6;
        float[] fArray = this.curCurvepts;
        float[] fArray2 = this.dash;
        int n2 = this.dashLen;
        int n3 = this.idx;
        boolean bl2 = this.dashOn;
        float f9 = this.phase;
        while (true) {
            float f10;
            float f11;
            if (f6 <= (f11 = (f10 = fArray2[n3]) - f9)) {
                fArray[0] = f2;
                fArray[1] = f3;
                this.goTo(fArray, 0, 4, bl2);
                f9 += f6;
                if (f6 != f11) break;
                f9 = 0.0f;
                n3 = (n3 + 1) % n2;
                bl2 = !bl2;
                break;
            }
            if (f9 == 0.0f) {
                fArray[0] = this.cx0 + f10 * f7;
                fArray[1] = this.cy0 + f10 * f8;
            } else {
                fArray[0] = this.cx0 + f11 * f7;
                fArray[1] = this.cy0 + f11 * f8;
            }
            this.goTo(fArray, 0, 4, bl2);
            f6 -= f11;
            n3 = (n3 + 1) % n2;
            bl2 = !bl2;
            f9 = 0.0f;
        }
        this.idx = n3;
        this.dashOn = bl2;
        this.phase = f9;
    }

    private void skipLineTo(float f2, float f3) {
        float f4 = f2 - this.cx0;
        float f5 = f3 - this.cy0;
        float f6 = f4 * f4 + f5 * f5;
        if (f6 != 0.0f) {
            f6 = (float)Math.sqrt(f6);
        }
        this.outside = true;
        this.totalSkipLen += f6;
        this.needsMoveTo = true;
        this.starting = false;
        this.cx0 = f2;
        this.cy0 = f3;
    }

    public void skipLen() {
        float f2 = this.totalSkipLen;
        this.totalSkipLen = 0.0f;
        float[] fArray = this.dash;
        int n2 = this.dashLen;
        int n3 = this.idx;
        boolean bl2 = this.dashOn;
        float f3 = this.phase;
        long l2 = (long)Math.floor(f2 / this.cycleLen) - 2L;
        if (l2 > 0L) {
            f2 -= this.cycleLen * (float)l2;
            long l3 = l2 * (long)n2;
            n3 = (int)(l3 + (long)n3) % n2;
            boolean bl3 = bl2 = (l3 + (bl2 ? 1L : 0L) & 1L) == 1L;
        }
        while (true) {
            float f4;
            float f5;
            if (f2 <= (f5 = (f4 = fArray[n3]) - f3)) {
                f3 += f2;
                if (f2 != f5) break;
                f3 = 0.0f;
                n3 = (n3 + 1) % n2;
                bl2 = !bl2;
                break;
            }
            f2 -= f5;
            n3 = (n3 + 1) % n2;
            bl2 = !bl2;
            f3 = 0.0f;
        }
        this.idx = n3;
        this.dashOn = bl2;
        this.phase = f3;
    }

    private void somethingTo(int n2) {
        float[] fArray = this.curCurvepts;
        if (Dasher.pointCurve(fArray, n2)) {
            return;
        }
        LengthIterator lengthIterator = this.li;
        float[] fArray2 = this.dash;
        int n3 = this.dashLen;
        lengthIterator.initializeIterationOnCurve(fArray, n2);
        int n4 = this.idx;
        boolean bl2 = this.dashOn;
        float f2 = this.phase;
        int n5 = 0;
        float f3 = 0.0f;
        float f4 = fArray2[n4] - f2;
        while (true) {
            float f5;
            float f6 = lengthIterator.next(f4);
            if (!(f5 < 1.0f)) break;
            if (f6 != 0.0f) {
                Helpers.subdivideAt((f6 - f3) / (1.0f - f3), fArray, n5, fArray, 0, n2);
                f3 = f6;
                this.goTo(fArray, 2, n2, bl2);
                n5 = n2;
            }
            n4 = (n4 + 1) % n3;
            bl2 = !bl2;
            f2 = 0.0f;
            f4 = fArray2[n4];
        }
        this.goTo(fArray, n5 + 2, n2, bl2);
        f2 += lengthIterator.lastSegLen();
        if (f2 >= fArray2[n4]) {
            f2 = 0.0f;
            n4 = (n4 + 1) % n3;
            bl2 = !bl2;
        }
        this.idx = n4;
        this.dashOn = bl2;
        this.phase = f2;
        lengthIterator.reset();
    }

    private void skipSomethingTo(int n2) {
        float[] fArray = this.curCurvepts;
        if (Dasher.pointCurve(fArray, n2)) {
            return;
        }
        LengthIterator lengthIterator = this.li;
        lengthIterator.initializeIterationOnCurve(fArray, n2);
        float f2 = lengthIterator.totalLength();
        this.outside = true;
        this.totalSkipLen += f2;
        this.needsMoveTo = true;
        this.starting = false;
    }

    private static boolean pointCurve(float[] fArray, int n2) {
        for (int i2 = 2; i2 < n2; ++i2) {
            if (fArray[i2] == fArray[i2 - 2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void curveTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        int n2 = this.cOutCode;
        if (this.clipRect != null) {
            int n3;
            int n4;
            int n5 = Helpers.outcode(f2, f3, this.clipRect);
            int n6 = n2 | n5 | (n4 = Helpers.outcode(f4, f5, this.clipRect)) | (n3 = Helpers.outcode(f6, f7, this.clipRect));
            if (n6 != 0) {
                int n7 = n2 & n5 & n4 & n3;
                if (n7 == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean bl2 = this.curveSplitter.splitCurve(this.cx0, this.cy0, f2, f3, f4, f5, f6, f7, n6, this);
                        this.subdivide = true;
                        if (bl2) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n3;
                    this.skipCurveTo(f2, f3, f4, f5, f6, f7);
                    return;
                }
            }
            this.cOutCode = n3;
            if (this.outside) {
                this.outside = false;
                this.skipLen();
            }
        }
        this._curveTo(f2, f3, f4, f5, f6, f7);
    }

    private void _curveTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        float[] fArray = this.curCurvepts;
        TransformingPathConsumer2D.CurveBasicMonotonizer curveBasicMonotonizer = this.rdrCtx.monotonizer.curve(this.cx0, this.cy0, f2, f3, f4, f5, f6, f7);
        int n2 = curveBasicMonotonizer.nbSplits;
        float[] fArray2 = curveBasicMonotonizer.middle;
        int n3 = 0;
        int n4 = 0;
        while (n3 <= n2) {
            System.arraycopy(fArray2, n4, fArray, 0, 8);
            this.somethingTo(8);
            ++n3;
            n4 += 6;
        }
    }

    private void skipCurveTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        float[] fArray = this.curCurvepts;
        fArray[0] = this.cx0;
        fArray[1] = this.cy0;
        fArray[2] = f2;
        fArray[3] = f3;
        fArray[4] = f4;
        fArray[5] = f5;
        fArray[6] = f6;
        fArray[7] = f7;
        this.skipSomethingTo(8);
        this.cx0 = f6;
        this.cy0 = f7;
    }

    @Override
    public void quadTo(float f2, float f3, float f4, float f5) {
        int n2 = this.cOutCode;
        if (this.clipRect != null) {
            int n3;
            int n4 = Helpers.outcode(f2, f3, this.clipRect);
            int n5 = n2 | n4 | (n3 = Helpers.outcode(f4, f5, this.clipRect));
            if (n5 != 0) {
                int n6 = n2 & n4 & n3;
                if (n6 == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean bl2 = this.curveSplitter.splitQuad(this.cx0, this.cy0, f2, f3, f4, f5, n5, this);
                        this.subdivide = true;
                        if (bl2) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n3;
                    this.skipQuadTo(f2, f3, f4, f5);
                    return;
                }
            }
            this.cOutCode = n3;
            if (this.outside) {
                this.outside = false;
                this.skipLen();
            }
        }
        this._quadTo(f2, f3, f4, f5);
    }

    private void _quadTo(float f2, float f3, float f4, float f5) {
        float[] fArray = this.curCurvepts;
        TransformingPathConsumer2D.CurveBasicMonotonizer curveBasicMonotonizer = this.rdrCtx.monotonizer.quad(this.cx0, this.cy0, f2, f3, f4, f5);
        int n2 = curveBasicMonotonizer.nbSplits;
        float[] fArray2 = curveBasicMonotonizer.middle;
        int n3 = 0;
        int n4 = 0;
        while (n3 <= n2) {
            System.arraycopy(fArray2, n4, fArray, 0, 8);
            this.somethingTo(6);
            ++n3;
            n4 += 4;
        }
    }

    private void skipQuadTo(float f2, float f3, float f4, float f5) {
        float[] fArray = this.curCurvepts;
        fArray[0] = this.cx0;
        fArray[1] = this.cy0;
        fArray[2] = f2;
        fArray[3] = f3;
        fArray[4] = f4;
        fArray[5] = f5;
        this.skipSomethingTo(6);
        this.cx0 = f4;
        this.cy0 = f5;
    }

    @Override
    public void closePath() {
        if (this.cx0 != this.sx0 || this.cy0 != this.sy0) {
            this.lineTo(this.sx0, this.sy0);
        }
        if (this.firstSegidx != 0) {
            if (!this.dashOn || this.needsMoveTo) {
                this.out.moveTo(this.sx0, this.sy0);
            }
            this.emitFirstSegments();
        }
        this.moveTo(this.sx0, this.sy0);
    }

    @Override
    public void pathDone() {
        if (this.firstSegidx != 0) {
            this.out.moveTo(this.sx0, this.sy0);
            this.emitFirstSegments();
        }
        this.out.pathDone();
        this.dispose();
    }

    static final class LengthIterator {
        private final float[][] recCurveStack;
        private final boolean[] sidesRight;
        private int curveType;
        private float nextT;
        private float lenAtNextT;
        private float lastT;
        private float lenAtLastT;
        private float lenAtLastSplit;
        private float lastSegLen;
        private int recLevel;
        private boolean done = true;
        private final float[] curLeafCtrlPolyLengths = new float[3];
        private int cachedHaveLowAcceleration = -1;
        private final float[] nextRoots = new float[4];
        private final float[] flatLeafCoefCache = new float[]{0.0f, 0.0f, -1.0f, 0.0f};

        LengthIterator() {
            this.recCurveStack = new float[17][8];
            this.sidesRight = new boolean[16];
            this.nextT = Float.MAX_VALUE;
            this.lenAtNextT = Float.MAX_VALUE;
            this.lenAtLastSplit = Float.MIN_VALUE;
            this.recLevel = Integer.MIN_VALUE;
            this.lastSegLen = Float.MAX_VALUE;
        }

        void reset() {
        }

        void initializeIterationOnCurve(float[] fArray, int n2) {
            System.arraycopy(fArray, 0, this.recCurveStack[0], 0, 8);
            this.curveType = n2;
            this.recLevel = 0;
            this.lastT = 0.0f;
            this.lenAtLastT = 0.0f;
            this.nextT = 0.0f;
            this.lenAtNextT = 0.0f;
            this.goLeft();
            this.lenAtLastSplit = 0.0f;
            if (this.recLevel > 0) {
                this.sidesRight[0] = false;
                this.done = false;
            } else {
                this.sidesRight[0] = true;
                this.done = true;
            }
            this.lastSegLen = 0.0f;
        }

        private boolean haveLowAcceleration(float f2) {
            if (this.cachedHaveLowAcceleration == -1) {
                float f3;
                float f4;
                float f5 = this.curLeafCtrlPolyLengths[0];
                float f6 = this.curLeafCtrlPolyLengths[1];
                if (!Helpers.within(f5, f6, f2 * f6)) {
                    this.cachedHaveLowAcceleration = 0;
                    return false;
                }
                if (!(this.curveType != 8 || Helpers.within(f6, f4 = this.curLeafCtrlPolyLengths[2], f3 = f2 * f4) && Helpers.within(f5, f4, f3))) {
                    this.cachedHaveLowAcceleration = 0;
                    return false;
                }
                this.cachedHaveLowAcceleration = 1;
                return true;
            }
            return this.cachedHaveLowAcceleration == 1;
        }

        float next(float f2) {
            float f3 = this.lenAtLastSplit + f2;
            while (this.lenAtNextT < f3) {
                if (this.done) {
                    this.lastSegLen = this.lenAtNextT - this.lenAtLastSplit;
                    return 1.0f;
                }
                this.goToNextLeaf();
            }
            this.lenAtLastSplit = f3;
            float f4 = this.lenAtNextT - this.lenAtLastT;
            float f5 = (f3 - this.lenAtLastT) / f4;
            if (!this.haveLowAcceleration(0.05f)) {
                float f6;
                int n2;
                float f7;
                float f8;
                float f9;
                float[] fArray = this.flatLeafCoefCache;
                if (fArray[2] < 0.0f) {
                    f9 = this.curLeafCtrlPolyLengths[0];
                    f8 = f9 + this.curLeafCtrlPolyLengths[1];
                    if (this.curveType == 8) {
                        f7 = f8 + this.curLeafCtrlPolyLengths[2];
                        fArray[0] = 3.0f * (f9 - f8) + f7;
                        fArray[1] = 3.0f * (f8 - 2.0f * f9);
                        fArray[2] = 3.0f * f9;
                        fArray[3] = -f7;
                    } else if (this.curveType == 6) {
                        fArray[0] = 0.0f;
                        fArray[1] = f8 - 2.0f * f9;
                        fArray[2] = 2.0f * f9;
                        fArray[3] = -f8;
                    }
                }
                if ((n2 = Helpers.cubicRootsInAB(f9 = fArray[0], f8 = fArray[1], f7 = fArray[2], f6 = f5 * fArray[3], this.nextRoots, 0, 0.0f, 1.0f)) == 1 && !Float.isNaN(this.nextRoots[0])) {
                    f5 = this.nextRoots[0];
                }
            }
            if ((f5 = f5 * (this.nextT - this.lastT) + this.lastT) >= 1.0f) {
                f5 = 1.0f;
                this.done = true;
            }
            this.lastSegLen = f2;
            return f5;
        }

        float totalLength() {
            while (!this.done) {
                this.goToNextLeaf();
            }
            this.reset();
            return this.lenAtNextT;
        }

        float lastSegLen() {
            return this.lastSegLen;
        }

        private void goToNextLeaf() {
            boolean[] blArray = this.sidesRight;
            int n2 = this.recLevel;
            --n2;
            while (blArray[n2]) {
                if (n2 == 0) {
                    this.recLevel = 0;
                    this.done = true;
                    return;
                }
                --n2;
            }
            blArray[n2] = true;
            System.arraycopy(this.recCurveStack[n2++], 0, this.recCurveStack[n2], 0, 8);
            this.recLevel = n2;
            this.goLeft();
        }

        private void goLeft() {
            float f2 = this.onLeaf();
            if (f2 >= 0.0f) {
                this.lastT = this.nextT;
                this.lenAtLastT = this.lenAtNextT;
                this.nextT += (float)(1 << 16 - this.recLevel) * 1.5258789E-5f;
                this.lenAtNextT += f2;
                this.flatLeafCoefCache[2] = -1.0f;
                this.cachedHaveLowAcceleration = -1;
            } else {
                Helpers.subdivide(this.recCurveStack[this.recLevel], this.recCurveStack[this.recLevel + 1], this.recCurveStack[this.recLevel], this.curveType);
                this.sidesRight[this.recLevel] = false;
                ++this.recLevel;
                this.goLeft();
            }
        }

        private float onLeaf() {
            float[] fArray = this.recCurveStack[this.recLevel];
            int n2 = this.curveType;
            float f2 = 0.0f;
            float f3 = fArray[0];
            float f4 = fArray[1];
            for (int i2 = 2; i2 < n2; i2 += 2) {
                float f5 = fArray[i2];
                float f6 = fArray[i2 + 1];
                float f7 = Helpers.linelen(f3, f4, f5, f6);
                f2 += f7;
                this.curLeafCtrlPolyLengths[(i2 >> 1) - 1] = f7;
                f3 = f5;
                f4 = f6;
            }
            float f8 = Helpers.linelen(fArray[0], fArray[1], f3, f4);
            if (f2 - f8 < CURVE_LEN_ERR || this.recLevel == 16) {
                return (f2 + f8) / 2.0f;
            }
            return -1.0f;
        }
    }
}

