/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;

public final class DoubleArrayCache
implements MarlinConst {
    final boolean clean;
    private final int bucketCapacity;
    private WeakReference<Bucket[]> refBuckets = null;
    final ArrayCacheConst.CacheStats stats;

    DoubleArrayCache(boolean bl2, int n2) {
        this.clean = bl2;
        this.bucketCapacity = n2;
        this.stats = DO_STATS ? new ArrayCacheConst.CacheStats(DoubleArrayCache.getLogPrefix(bl2) + "DoubleArrayCache") : null;
    }

    Bucket getCacheBucket(int n2) {
        int n3 = ArrayCacheConst.getBucket(n2);
        return this.getBuckets()[n3];
    }

    private Bucket[] getBuckets() {
        Bucket[] bucketArray;
        Bucket[] bucketArray2 = bucketArray = this.refBuckets != null ? (Bucket[])this.refBuckets.get() : null;
        if (bucketArray == null) {
            bucketArray = new Bucket[8];
            for (int i2 = 0; i2 < 8; ++i2) {
                bucketArray[i2] = new Bucket(this.clean, ArrayCacheConst.ARRAY_SIZES[i2], this.bucketCapacity, DO_STATS ? this.stats.bucketStats[i2] : null);
            }
            this.refBuckets = new WeakReference<Bucket[]>(bucketArray);
        }
        return bucketArray;
    }

    Reference createRef(int n2) {
        return new Reference(this, n2);
    }

    static double[] createArray(int n2) {
        return new double[n2];
    }

    static void fill(double[] dArray, int n2, int n3, double d2) {
        Arrays.fill(dArray, n2, n3, d2);
        if (DO_CHECKS) {
            DoubleArrayCache.check(dArray, n2, n3, d2);
        }
    }

    public static void check(double[] dArray, int n2, int n3, double d2) {
        if (DO_CHECKS) {
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                if (dArray[i2] == d2) continue;
                MarlinUtils.logException("Invalid value at: " + i2 + " = " + dArray[i2] + " from: " + n2 + " to: " + n3 + "\n" + Arrays.toString(dArray), new Throwable());
                Arrays.fill(dArray, d2);
                return;
            }
        }
    }

    static String getLogPrefix(boolean bl2) {
        return bl2 ? "Clean" : "Dirty";
    }

    static final class Bucket {
        private int tail = 0;
        private final int arraySize;
        private final boolean clean;
        private final double[][] arrays;
        private final ArrayCacheConst.BucketStats stats;

        Bucket(boolean bl2, int n2, int n3, ArrayCacheConst.BucketStats bucketStats) {
            this.arraySize = n2;
            this.clean = bl2;
            this.stats = bucketStats;
            this.arrays = new double[n3][];
        }

        double[] getArray() {
            if (MarlinConst.DO_STATS) {
                ++this.stats.getOp;
            }
            if (this.tail != 0) {
                double[] dArray = this.arrays[--this.tail];
                this.arrays[this.tail] = null;
                return dArray;
            }
            if (MarlinConst.DO_STATS) {
                ++this.stats.createOp;
            }
            return DoubleArrayCache.createArray(this.arraySize);
        }

        void putArray(double[] dArray) {
            if (MarlinConst.DO_CHECKS && dArray.length != this.arraySize) {
                MarlinUtils.logInfo(DoubleArrayCache.getLogPrefix(this.clean) + "DoubleArrayCache: bad length = " + dArray.length);
                return;
            }
            if (MarlinConst.DO_STATS) {
                ++this.stats.returnOp;
            }
            if (this.arrays.length > this.tail) {
                this.arrays[this.tail++] = dArray;
                if (MarlinConst.DO_STATS) {
                    this.stats.updateMaxSize(this.tail);
                }
            } else if (MarlinConst.DO_CHECKS) {
                MarlinUtils.logInfo(DoubleArrayCache.getLogPrefix(this.clean) + "DoubleArrayCache: array capacity exceeded !");
            }
        }
    }

    static final class Reference {
        final double[] initial;
        private final boolean clean;
        private final DoubleArrayCache cache;

        Reference(DoubleArrayCache doubleArrayCache, int n2) {
            this.cache = doubleArrayCache;
            this.clean = doubleArrayCache.clean;
            this.initial = DoubleArrayCache.createArray(n2);
            if (MarlinConst.DO_STATS) {
                doubleArrayCache.stats.totalInitial += (long)n2;
            }
        }

        double[] getArray(int n2) {
            if (n2 <= ArrayCacheConst.MAX_ARRAY_SIZE) {
                return this.cache.getCacheBucket(n2).getArray();
            }
            if (MarlinConst.DO_STATS) {
                ++this.cache.stats.oversize;
            }
            if (MarlinConst.DO_LOG_OVERSIZE) {
                MarlinUtils.logInfo(DoubleArrayCache.getLogPrefix(this.clean) + "DoubleArrayCache: getArray[oversize]: length=\t" + n2);
            }
            return DoubleArrayCache.createArray(n2);
        }

        double[] widenArray(double[] dArray, int n2, int n3) {
            int n4 = dArray.length;
            if (MarlinConst.DO_CHECKS && n4 >= n3) {
                return dArray;
            }
            if (MarlinConst.DO_STATS) {
                ++this.cache.stats.resize;
            }
            double[] dArray2 = this.getArray(ArrayCacheConst.getNewSize(n2, n3));
            System.arraycopy(dArray, 0, dArray2, 0, n2);
            this.putArray(dArray, 0, n2);
            if (MarlinConst.DO_LOG_WIDEN_ARRAY) {
                MarlinUtils.logInfo(DoubleArrayCache.getLogPrefix(this.clean) + "DoubleArrayCache: widenArray[" + dArray2.length + "]: usedSize=\t" + n2 + "\tlength=\t" + n4 + "\tneeded length=\t" + n3);
            }
            return dArray2;
        }

        double[] putArray(double[] dArray) {
            return this.putArray(dArray, 0, dArray.length);
        }

        double[] putArray(double[] dArray, int n2, int n3) {
            if (dArray.length <= ArrayCacheConst.MAX_ARRAY_SIZE) {
                if (this.clean && n3 != 0) {
                    DoubleArrayCache.fill(dArray, n2, n3, 0.0);
                }
                if (dArray != this.initial) {
                    this.cache.getCacheBucket(dArray.length).putArray(dArray);
                }
            }
            return this.initial;
        }
    }
}

