/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.Curve;
import com.sun.marlin.FloatMath;
import com.sun.marlin.IntArrayCache;
import com.sun.marlin.MarlinAlphaConsumer;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinProperties;
import com.sun.marlin.MarlinRenderer;
import com.sun.marlin.MarlinUtils;
import com.sun.marlin.MergeSort;
import com.sun.marlin.OffHeapArray;
import com.sun.marlin.RendererContext;
import sun.misc.Unsafe;

public final class RendererNoAA
implements MarlinConst,
MarlinRenderer {
    static final boolean DISABLE_RENDER = false;
    private static final int ALL_BUT_LSB = -2;
    private static final int ERR_STEP_MAX = Integer.MAX_VALUE;
    private static final double POWER_2_TO_32 = 4.294967296E9;
    private static final float RDR_OFFSET_X = 0.5f;
    private static final float RDR_OFFSET_Y = 0.5f;
    public static final long OFF_CURX_OR = 0L;
    public static final long OFF_ERROR = 0L + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_BUMP_X = OFF_ERROR + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_BUMP_ERR = OFF_BUMP_X + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_NEXT = OFF_BUMP_ERR + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_YMAX = OFF_NEXT + (long)OffHeapArray.SIZE_INT;
    public static final int SIZEOF_EDGE_BYTES = (int)(OFF_YMAX + (long)OffHeapArray.SIZE_INT);
    private static final float CUB_DEC_ERR_SUBPIX = MarlinProperties.getCubicDecD2() * 0.125f;
    private static final float CUB_INC_ERR_SUBPIX = MarlinProperties.getCubicIncD1() * 0.125f;
    public static final float CUB_DEC_BND = 8.0f * CUB_DEC_ERR_SUBPIX;
    public static final float CUB_INC_BND = 8.0f * CUB_INC_ERR_SUBPIX;
    public static final int CUB_COUNT_LG = 2;
    private static final int CUB_COUNT = 4;
    private static final int CUB_COUNT_2 = 16;
    private static final int CUB_COUNT_3 = 64;
    private static final float CUB_INV_COUNT = 0.25f;
    private static final float CUB_INV_COUNT_2 = 0.0625f;
    private static final float CUB_INV_COUNT_3 = 0.015625f;
    private static final float QUAD_DEC_ERR_SUBPIX = MarlinProperties.getQuadDecD2() * 0.125f;
    public static final float QUAD_DEC_BND = 8.0f * QUAD_DEC_ERR_SUBPIX;
    private int[] crossings;
    private int[] aux_crossings;
    private int edgeCount;
    private int[] edgePtrs;
    private int[] aux_edgePtrs;
    private int activeEdgeMaxUsed;
    private final IntArrayCache.Reference crossings_ref;
    private final IntArrayCache.Reference edgePtrs_ref;
    private final IntArrayCache.Reference aux_crossings_ref;
    private final IntArrayCache.Reference aux_edgePtrs_ref;
    private int edgeMinY = Integer.MAX_VALUE;
    private int edgeMaxY = Integer.MIN_VALUE;
    private float edgeMinX = Float.POSITIVE_INFINITY;
    private float edgeMaxX = Float.NEGATIVE_INFINITY;
    private final OffHeapArray edges;
    private int[] edgeBuckets;
    private int[] edgeBucketCounts;
    private int buckets_minY;
    private int buckets_maxY;
    private final IntArrayCache.Reference edgeBuckets_ref;
    private final IntArrayCache.Reference edgeBucketCounts_ref;
    boolean useRLE = false;
    private int boundsMinX;
    private int boundsMinY;
    private int boundsMaxX;
    private int boundsMaxY;
    private int windingRule;
    private float x0;
    private float y0;
    private float sx0;
    private float sy0;
    final RendererContext rdrCtx;
    private final Curve curve;
    private int[] alphaLine;
    private final IntArrayCache.Reference alphaLine_ref;
    private boolean enableBlkFlags = false;
    private boolean prevUseBlkFlags = false;
    private int[] blkFlags;
    private final IntArrayCache.Reference blkFlags_ref;
    private int bbox_spminX;
    private int bbox_spmaxX;
    private int bbox_spminY;
    private int bbox_spmaxY;
    int bboxX0;
    int bboxX1;
    int bboxY0;
    int bboxY1;

    private void quadBreakIntoLinesAndAdd(float f2, float f3, Curve curve, float f4, float f5) {
        int n2 = 1;
        float f6 = Math.abs(curve.dbx) + Math.abs(curve.dby);
        float f7 = QUAD_DEC_BND;
        while (f6 >= f7) {
            f6 /= 4.0f;
            n2 <<= 1;
            if (!DO_STATS) continue;
            this.rdrCtx.stats.stat_rdr_quadBreak_dec.add(n2);
        }
        int n3 = n2;
        if (n2 > 1) {
            float f8 = 1.0f / (float)n2;
            float f9 = f8 * f8;
            float f10 = curve.dbx * f9;
            float f11 = curve.dby * f9;
            float f12 = curve.bx * f9 + curve.cx * f8;
            float f13 = curve.by * f9 + curve.cy * f8;
            float f14 = f2;
            float f15 = f3;
            while (--n2 > 0) {
                this.addLine(f2, f3, f14 += f12, f15 += f13);
                f2 = f14;
                f3 = f15;
                f12 += f10;
                f13 += f11;
            }
        }
        this.addLine(f2, f3, f4, f5);
        if (DO_STATS) {
            this.rdrCtx.stats.stat_rdr_quadBreak.add(n3);
        }
    }

    private void curveBreakIntoLinesAndAdd(float f2, float f3, Curve curve, float f4, float f5) {
        int n2 = 4;
        float f6 = 2.0f * curve.dax * 0.015625f;
        float f7 = 2.0f * curve.day * 0.015625f;
        float f8 = f6 + curve.dbx * 0.0625f;
        float f9 = f7 + curve.dby * 0.0625f;
        float f10 = curve.ax * 0.015625f + curve.bx * 0.0625f + curve.cx * 0.25f;
        float f11 = curve.ay * 0.015625f + curve.by * 0.0625f + curve.cy * 0.25f;
        int n3 = 0;
        float f12 = CUB_DEC_BND;
        float f13 = CUB_INC_BND;
        float f14 = f2;
        float f15 = f3;
        while (n2 > 0) {
            while (n2 % 2 == 0 && Math.abs(f8) + Math.abs(f9) <= f13) {
                f10 = 2.0f * f10 + f8;
                f11 = 2.0f * f11 + f9;
                f8 = 4.0f * (f8 + f6);
                f9 = 4.0f * (f9 + f7);
                f6 *= 8.0f;
                f7 *= 8.0f;
                n2 >>= 1;
                if (!DO_STATS) continue;
                this.rdrCtx.stats.stat_rdr_curveBreak_inc.add(n2);
            }
            while (Math.abs(f8) + Math.abs(f9) >= f12) {
                f8 = f8 / 4.0f - (f6 /= 8.0f);
                f9 = f9 / 4.0f - (f7 /= 8.0f);
                f10 = (f10 - f8) / 2.0f;
                f11 = (f11 - f9) / 2.0f;
                n2 <<= 1;
                if (!DO_STATS) continue;
                this.rdrCtx.stats.stat_rdr_curveBreak_dec.add(n2);
            }
            if (--n2 == 0) break;
            f8 += f6;
            this.addLine(f2, f3, f14 += (f10 += f8), f15 += (f11 += (f9 += f7)));
            f2 = f14;
            f3 = f15;
        }
        this.addLine(f2, f3, f4, f5);
        if (DO_STATS) {
            this.rdrCtx.stats.stat_rdr_curveBreak.add(n3 + 1);
        }
    }

    private void addLine(float f2, float f3, float f4, float f5) {
        double d2;
        double d3;
        double d4;
        int n2;
        int n3;
        if (DO_STATS) {
            this.rdrCtx.stats.stat_rdr_addLine.add(1);
        }
        int n4 = 1;
        if (f5 < f3) {
            n4 = 0;
            float f6 = f5;
            f5 = f3;
            f3 = f6;
            f6 = f4;
            f4 = f2;
            f2 = f6;
        }
        if ((n3 = FloatMath.max(FloatMath.ceil_int(f3), this.boundsMinY)) >= (n2 = FloatMath.min(FloatMath.ceil_int(f5), this.boundsMaxY))) {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_rdr_addLine_skip.add(1);
            }
            return;
        }
        if (n3 < this.edgeMinY) {
            this.edgeMinY = n3;
        }
        if (n2 > this.edgeMaxY) {
            this.edgeMaxY = n2;
        }
        if ((d4 = ((d3 = (double)f2) - (double)f4) / ((d2 = (double)f3) - (double)f5)) >= 0.0) {
            if (f2 < this.edgeMinX) {
                this.edgeMinX = f2;
            }
            if (f4 > this.edgeMaxX) {
                this.edgeMaxX = f4;
            }
        } else {
            if (f4 < this.edgeMinX) {
                this.edgeMinX = f4;
            }
            if (f2 > this.edgeMaxX) {
                this.edgeMaxX = f2;
            }
        }
        int n5 = SIZEOF_EDGE_BYTES;
        OffHeapArray offHeapArray = this.edges;
        int n6 = offHeapArray.used;
        if (offHeapArray.length - (long)n6 < (long)n5) {
            long l2 = ArrayCacheConst.getNewLargeSize(offHeapArray.length, n6 + n5);
            if (DO_STATS) {
                this.rdrCtx.stats.stat_rdr_edges_resizes.add(l2);
            }
            offHeapArray.resize(l2);
        }
        Unsafe unsafe = OffHeapArray.UNSAFE;
        long l3 = offHeapArray.address + (long)n6;
        double d5 = d3 + ((double)n3 - d2) * d4;
        long l4 = (long)(4.294967296E9 * d5) + Integer.MAX_VALUE;
        unsafe.putInt(l3, (int)(l4 >> 31) & 0xFFFFFFFE | n4);
        unsafe.putInt(l3 += 4L, (int)l4 >>> 1);
        long l5 = (long)(4.294967296E9 * d4);
        unsafe.putInt(l3 += 4L, (int)(l5 >> 31) & 0xFFFFFFFE);
        unsafe.putInt(l3 += 4L, (int)l5 >>> 1);
        int[] nArray = this.edgeBuckets;
        int[] nArray2 = this.edgeBucketCounts;
        int n7 = this.boundsMinY;
        int n8 = n3 - n7;
        unsafe.putInt(l3 += 4L, nArray[n8]);
        unsafe.putInt(l3 += 4L, n2);
        nArray[n8] = n6;
        int n9 = n8;
        nArray2[n9] = nArray2[n9] + 2;
        int n10 = n2 - n7;
        nArray2[n10] = nArray2[n10] | 1;
        offHeapArray.used += n5;
    }

    RendererNoAA(RendererContext rendererContext) {
        this.rdrCtx = rendererContext;
        this.curve = rendererContext.curve;
        this.edges = rendererContext.rdrMem.edges;
        this.edgeBuckets_ref = rendererContext.rdrMem.edgeBuckets_ref;
        this.edgeBucketCounts_ref = rendererContext.rdrMem.edgeBucketCounts_ref;
        this.edgeBuckets = this.edgeBuckets_ref.initial;
        this.edgeBucketCounts = this.edgeBucketCounts_ref.initial;
        this.alphaLine_ref = rendererContext.rdrMem.alphaLine_ref;
        this.alphaLine = this.alphaLine_ref.initial;
        this.crossings_ref = rendererContext.rdrMem.crossings_ref;
        this.aux_crossings_ref = rendererContext.rdrMem.aux_crossings_ref;
        this.edgePtrs_ref = rendererContext.rdrMem.edgePtrs_ref;
        this.aux_edgePtrs_ref = rendererContext.rdrMem.aux_edgePtrs_ref;
        this.crossings = this.crossings_ref.initial;
        this.aux_crossings = this.aux_crossings_ref.initial;
        this.edgePtrs = this.edgePtrs_ref.initial;
        this.aux_edgePtrs = this.aux_edgePtrs_ref.initial;
        this.blkFlags_ref = rendererContext.rdrMem.blkFlags_ref;
        this.blkFlags = this.blkFlags_ref.initial;
    }

    @Override
    public RendererNoAA init(int n2, int n3, int n4, int n5, int n6) {
        int n7;
        this.windingRule = n6;
        this.boundsMinX = n2;
        this.boundsMaxX = n2 + n4;
        this.boundsMinY = n3;
        this.boundsMaxY = n3 + n5;
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("boundsXY = [" + this.boundsMinX + " ... " + this.boundsMaxX + "[ [" + this.boundsMinY + " ... " + this.boundsMaxY + "[");
        }
        if ((n7 = this.boundsMaxY - this.boundsMinY + 1) > INITIAL_BUCKET_ARRAY) {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_array_renderer_edgeBuckets.add(n7);
                this.rdrCtx.stats.stat_array_renderer_edgeBucketCounts.add(n7);
            }
            this.edgeBuckets = this.edgeBuckets_ref.getArray(n7);
            this.edgeBucketCounts = this.edgeBucketCounts_ref.getArray(n7);
        }
        this.edgeMinY = Integer.MAX_VALUE;
        this.edgeMaxY = Integer.MIN_VALUE;
        this.edgeMinX = Float.POSITIVE_INFINITY;
        this.edgeMaxX = Float.NEGATIVE_INFINITY;
        this.edgeCount = 0;
        this.activeEdgeMaxUsed = 0;
        this.edges.used = 0;
        this.bboxX0 = 0;
        this.bboxX1 = 0;
        return this;
    }

    @Override
    public void dispose() {
        if (DO_STATS) {
            this.rdrCtx.stats.stat_rdr_activeEdges.add(this.activeEdgeMaxUsed);
            this.rdrCtx.stats.stat_rdr_edges.add(this.edges.used);
            this.rdrCtx.stats.stat_rdr_edges_count.add(this.edges.used / SIZEOF_EDGE_BYTES);
            this.rdrCtx.stats.hist_rdr_edges_count.add(this.edges.used / SIZEOF_EDGE_BYTES);
            this.rdrCtx.stats.totalOffHeap += this.edges.length;
        }
        this.crossings = this.crossings_ref.putArray(this.crossings);
        this.aux_crossings = this.aux_crossings_ref.putArray(this.aux_crossings);
        this.edgePtrs = this.edgePtrs_ref.putArray(this.edgePtrs);
        this.aux_edgePtrs = this.aux_edgePtrs_ref.putArray(this.aux_edgePtrs);
        this.alphaLine = this.alphaLine_ref.putArray(this.alphaLine, 0, 0);
        this.blkFlags = this.blkFlags_ref.putArray(this.blkFlags, 0, 0);
        if (this.edgeMinY != Integer.MAX_VALUE) {
            if (this.rdrCtx.dirty) {
                this.buckets_minY = 0;
                this.buckets_maxY = this.boundsMaxY - this.boundsMinY;
            }
            this.edgeBuckets = this.edgeBuckets_ref.putArray(this.edgeBuckets, this.buckets_minY, this.buckets_maxY);
            this.edgeBucketCounts = this.edgeBucketCounts_ref.putArray(this.edgeBucketCounts, this.buckets_minY, this.buckets_maxY + 1);
        } else {
            this.edgeBuckets = this.edgeBuckets_ref.putArray(this.edgeBuckets, 0, 0);
            this.edgeBucketCounts = this.edgeBucketCounts_ref.putArray(this.edgeBucketCounts, 0, 0);
        }
        if (this.edges.length != (long)INITIAL_EDGES_CAPACITY) {
            this.edges.resize(INITIAL_EDGES_CAPACITY);
        }
    }

    private static float tosubpixx(float f2) {
        return f2;
    }

    private static float tosubpixy(float f2) {
        return f2 - 0.5f;
    }

    @Override
    public void moveTo(float f2, float f3) {
        this.closePath();
        float f4 = RendererNoAA.tosubpixx(f2);
        float f5 = RendererNoAA.tosubpixy(f3);
        this.sx0 = f4;
        this.sy0 = f5;
        this.x0 = f4;
        this.y0 = f5;
    }

    @Override
    public void lineTo(float f2, float f3) {
        float f4 = RendererNoAA.tosubpixx(f2);
        float f5 = RendererNoAA.tosubpixy(f3);
        this.addLine(this.x0, this.y0, f4, f5);
        this.x0 = f4;
        this.y0 = f5;
    }

    @Override
    public void curveTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = RendererNoAA.tosubpixx(f6);
        float f9 = RendererNoAA.tosubpixy(f7);
        this.curve.set(this.x0, this.y0, RendererNoAA.tosubpixx(f2), RendererNoAA.tosubpixy(f3), RendererNoAA.tosubpixx(f4), RendererNoAA.tosubpixy(f5), f8, f9);
        this.curveBreakIntoLinesAndAdd(this.x0, this.y0, this.curve, f8, f9);
        this.x0 = f8;
        this.y0 = f9;
    }

    @Override
    public void quadTo(float f2, float f3, float f4, float f5) {
        float f6 = RendererNoAA.tosubpixx(f4);
        float f7 = RendererNoAA.tosubpixy(f5);
        this.curve.set(this.x0, this.y0, RendererNoAA.tosubpixx(f2), RendererNoAA.tosubpixy(f3), f6, f7);
        this.quadBreakIntoLinesAndAdd(this.x0, this.y0, this.curve, f6, f7);
        this.x0 = f6;
        this.y0 = f7;
    }

    @Override
    public void closePath() {
        if (this.x0 != this.sx0 || this.y0 != this.sy0) {
            this.addLine(this.x0, this.y0, this.sx0, this.sy0);
            this.x0 = this.sx0;
            this.y0 = this.sy0;
        }
    }

    @Override
    public void pathDone() {
        this.closePath();
        this.endRendering();
    }

    private void _endRendering(int n2, int n3, MarlinAlphaConsumer marlinAlphaConsumer) {
        int n4 = this.bbox_spminX;
        int n5 = this.bbox_spmaxX;
        boolean bl2 = this.windingRule == 0;
        int[] nArray = this.alphaLine;
        OffHeapArray offHeapArray = this.edges;
        int[] nArray2 = this.edgeBuckets;
        int[] nArray3 = this.edgeBucketCounts;
        int[] nArray4 = this.crossings;
        int[] nArray5 = this.edgePtrs;
        int[] nArray6 = this.aux_crossings;
        int[] nArray7 = this.aux_edgePtrs;
        long l2 = OFF_ERROR;
        long l3 = OFF_BUMP_X;
        long l4 = OFF_BUMP_ERR;
        long l5 = OFF_NEXT;
        long l6 = OFF_YMAX;
        Unsafe unsafe = OffHeapArray.UNSAFE;
        long l7 = offHeapArray.address;
        int n6 = Integer.MAX_VALUE;
        int n7 = Integer.MIN_VALUE;
        int n8 = n2;
        int n9 = n8 - this.boundsMinY;
        int n10 = this.edgeCount;
        int n11 = nArray5.length;
        int n12 = nArray4.length;
        int n13 = this.activeEdgeMaxUsed;
        int n14 = 0;
        int[] nArray8 = this.blkFlags;
        int n15 = BLOCK_SIZE_LG;
        int n16 = BLOCK_SIZE;
        boolean bl3 = ENABLE_BLOCK_FLAGS_HEURISTICS && this.enableBlkFlags;
        boolean bl4 = this.prevUseBlkFlags;
        int n17 = this.rdrCtx.stroking;
        int n18 = -1;
        while (n8 < n3) {
            int n19;
            int n20;
            long l8;
            int n21 = nArray3[n9];
            int n22 = n10;
            if (n21 != 0) {
                if (DO_STATS) {
                    this.rdrCtx.stats.stat_rdr_activeEdges_updates.add(n10);
                }
                if ((n21 & 1) != 0) {
                    l8 = l7 + l6;
                    int n23 = 0;
                    for (n20 = 0; n20 < n10; ++n20) {
                        n19 = nArray5[n20];
                        if (unsafe.getInt(l8 + (long)n19) <= n8) continue;
                        nArray5[n23++] = n19;
                    }
                    n22 = n10 = n23;
                }
                if ((n14 = n21 >> 1) != 0) {
                    int n24;
                    if (DO_STATS) {
                        this.rdrCtx.stats.stat_rdr_activeEdges_adds.add(n14);
                        if (n14 > 10) {
                            this.rdrCtx.stats.stat_rdr_activeEdges_adds_high.add(n14);
                        }
                    }
                    if (n11 < (n24 = n10 + n14)) {
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_array_renderer_edgePtrs.add(n24);
                        }
                        this.edgePtrs = nArray5 = this.edgePtrs_ref.widenArray(nArray5, n10, n24);
                        n11 = nArray5.length;
                        this.aux_edgePtrs_ref.putArray(nArray7);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_array_renderer_aux_edgePtrs.add(n24);
                        }
                        this.aux_edgePtrs = nArray7 = this.aux_edgePtrs_ref.getArray(ArrayCacheConst.getNewSize(n10, n24));
                    }
                    l8 = l7 + l5;
                    n19 = nArray2[n9];
                    while (n10 < n24) {
                        nArray5[n10] = n19;
                        n19 = unsafe.getInt(l8 + (long)n19);
                        ++n10;
                    }
                    if (n12 < n10) {
                        this.crossings_ref.putArray(nArray4);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_array_renderer_crossings.add(n10);
                        }
                        this.crossings = nArray4 = this.crossings_ref.getArray(n10);
                        this.aux_crossings_ref.putArray(nArray6);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_array_renderer_aux_crossings.add(n10);
                        }
                        this.aux_crossings = nArray6 = this.aux_crossings_ref.getArray(n10);
                        n12 = nArray4.length;
                    }
                    if (DO_STATS && n10 > n13) {
                        n13 = n10;
                    }
                }
            }
            if (n10 != 0) {
                int n25;
                int n26;
                int n27;
                int n28;
                int n29;
                int n30;
                int n31;
                if (n14 < 10 || n10 < 40) {
                    if (DO_STATS) {
                        this.rdrCtx.stats.hist_rdr_crossings.add(n10);
                        this.rdrCtx.stats.hist_rdr_crossings_adds.add(n14);
                    }
                    boolean bl5 = n10 >= 20;
                    n31 = Integer.MIN_VALUE;
                    for (n20 = 0; n20 < n10; ++n20) {
                        n19 = nArray5[n20];
                        l8 = l7 + (long)n19;
                        n29 = n30 = unsafe.getInt(l8);
                        n28 = unsafe.getInt(l8 + l2) + unsafe.getInt(l8 + l4);
                        unsafe.putInt(l8, (n30 += unsafe.getInt(l8 + l3)) - (n28 >> 30 & 0xFFFFFFFE));
                        unsafe.putInt(l8 + l2, n28 & Integer.MAX_VALUE);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_rdr_crossings_updates.add(n10);
                        }
                        if (n29 < n31) {
                            if (DO_STATS) {
                                this.rdrCtx.stats.stat_rdr_crossings_sorts.add(n20);
                            }
                            if (bl5 && n20 >= n22) {
                                if (DO_STATS) {
                                    this.rdrCtx.stats.stat_rdr_crossings_bsearch.add(n20);
                                }
                                int n32 = 0;
                                int n33 = n20 - 1;
                                do {
                                    int n34;
                                    if (nArray4[n34 = n32 + n33 >> 1] < n29) {
                                        n32 = n34 + 1;
                                        continue;
                                    }
                                    n33 = n34 - 1;
                                } while (n32 <= n33);
                                for (n27 = n20 - 1; n27 >= n32; --n27) {
                                    nArray4[n27 + 1] = nArray4[n27];
                                    nArray5[n27 + 1] = nArray5[n27];
                                }
                                nArray4[n32] = n29;
                                nArray5[n32] = n19;
                                continue;
                            }
                            n27 = n20 - 1;
                            nArray4[n20] = nArray4[n27];
                            nArray5[n20] = nArray5[n27];
                            while (--n27 >= 0 && nArray4[n27] > n29) {
                                nArray4[n27 + 1] = nArray4[n27];
                                nArray5[n27 + 1] = nArray5[n27];
                            }
                            nArray4[n27 + 1] = n29;
                            nArray5[n27 + 1] = n19;
                            continue;
                        }
                        nArray4[n20] = n31 = n29;
                    }
                } else {
                    if (DO_STATS) {
                        this.rdrCtx.stats.stat_rdr_crossings_msorts.add(n10);
                        this.rdrCtx.stats.hist_rdr_crossings_ratio.add(1000 * n14 / n10);
                        this.rdrCtx.stats.hist_rdr_crossings_msorts.add(n10);
                        this.rdrCtx.stats.hist_rdr_crossings_msorts_adds.add(n14);
                    }
                    n31 = Integer.MIN_VALUE;
                    for (n20 = 0; n20 < n10; ++n20) {
                        n19 = nArray5[n20];
                        l8 = l7 + (long)n19;
                        n29 = n30 = unsafe.getInt(l8);
                        n28 = unsafe.getInt(l8 + l2) + unsafe.getInt(l8 + l4);
                        unsafe.putInt(l8, (n30 += unsafe.getInt(l8 + l3)) - (n28 >> 30 & 0xFFFFFFFE));
                        unsafe.putInt(l8 + l2, n28 & Integer.MAX_VALUE);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_rdr_crossings_updates.add(n10);
                        }
                        if (n20 >= n22) {
                            nArray4[n20] = n29;
                            continue;
                        }
                        if (n29 < n31) {
                            if (DO_STATS) {
                                this.rdrCtx.stats.stat_rdr_crossings_sorts.add(n20);
                            }
                            n27 = n20 - 1;
                            nArray6[n20] = nArray6[n27];
                            nArray7[n20] = nArray7[n27];
                            while (--n27 >= 0 && nArray6[n27] > n29) {
                                nArray6[n27 + 1] = nArray6[n27];
                                nArray7[n27 + 1] = nArray7[n27];
                            }
                            nArray6[n27 + 1] = n29;
                            nArray7[n27 + 1] = n19;
                            continue;
                        }
                        nArray6[n20] = n31 = n29;
                        nArray7[n20] = n19;
                    }
                    MergeSort.mergeSortNoCopy(nArray4, nArray5, nArray6, nArray7, n10, n22);
                }
                n14 = 0;
                int n35 = nArray4[0];
                int n36 = n35 >> 1;
                if (n36 < n6) {
                    n6 = n36;
                }
                if ((n26 = nArray4[n10 - 1] >> 1) > n7) {
                    n7 = n26;
                }
                int n37 = n30 = n36;
                int n38 = ((n35 & 1) << 1) - 1;
                if (bl2) {
                    n25 = n38;
                    for (n20 = 1; n20 < n10; ++n20) {
                        n35 = nArray4[n20];
                        n30 = n35 >> 1;
                        n38 = ((n35 & 1) << 1) - 1;
                        if ((n25 & 1) != 0) {
                            int n39 = n36 = n37 > n4 ? n37 : n4;
                            if (n30 < n5) {
                                n26 = n30;
                            } else {
                                n26 = n5;
                                n20 = n10;
                            }
                            if (n36 < n26) {
                                int n40 = n36 -= n4;
                                nArray[n40] = nArray[n40] + 1;
                                int n41 = n26 -= n4;
                                nArray[n41] = nArray[n41] - 1;
                                if (bl4) {
                                    nArray8[n36 >> n15] = 1;
                                    nArray8[n26 >> n15] = 1;
                                }
                            }
                        }
                        n25 += n38;
                        n37 = n30;
                    }
                } else {
                    n20 = 1;
                    n25 = 0;
                    while (true) {
                        if ((n25 += n38) != 0) {
                            if (n37 > n30) {
                                n37 = n30;
                            }
                        } else {
                            int n42 = n36 = n37 > n4 ? n37 : n4;
                            if (n30 < n5) {
                                n26 = n30;
                            } else {
                                n26 = n5;
                                n20 = n10;
                            }
                            if (n36 < n26) {
                                int n43 = n36 -= n4;
                                nArray[n43] = nArray[n43] + 1;
                                int n44 = n26 -= n4;
                                nArray[n44] = nArray[n44] - 1;
                                if (bl4) {
                                    nArray8[n36 >> n15] = 1;
                                    nArray8[n26 >> n15] = 1;
                                }
                            }
                            n37 = Integer.MAX_VALUE;
                        }
                        if (n20 == n10) break;
                        n35 = nArray4[n20];
                        n30 = n35 >> 1;
                        n38 = ((n35 & 1) << 1) - 1;
                        ++n20;
                    }
                }
            }
            n18 = n8;
            n6 = FloatMath.max(n6, n4);
            if ((n7 = FloatMath.min(n7, n5)) >= n6) {
                this.copyAARow(nArray, n18, n6, n7 + 1, bl4, marlinAlphaConsumer);
                if (bl3) {
                    boolean bl6 = bl4 = (n7 -= n6) > n16 && n7 > (n10 >> n17) - 1 << n15;
                    if (DO_STATS) {
                        int n45 = FloatMath.max(1, (n10 >> n17) - 1);
                        this.rdrCtx.stats.hist_tile_generator_encoding_dist.add(n7 / n45);
                    }
                }
            } else {
                marlinAlphaConsumer.clearAlphas(n18);
            }
            n6 = Integer.MAX_VALUE;
            n7 = Integer.MIN_VALUE;
            ++n8;
            ++n9;
        }
        --n8;
        n6 = FloatMath.max(n6, n4);
        if ((n7 = FloatMath.min(n7, n5)) >= n6) {
            this.copyAARow(nArray, n8, n6, n7 + 1, bl4, marlinAlphaConsumer);
        } else if (n8 != n18) {
            marlinAlphaConsumer.clearAlphas(n8);
        }
        this.edgeCount = n10;
        this.prevUseBlkFlags = bl4;
        if (DO_STATS) {
            this.activeEdgeMaxUsed = n13;
        }
    }

    void endRendering() {
        int n2;
        if (this.edgeMinY == Integer.MAX_VALUE) {
            return;
        }
        int n3 = FloatMath.max(FloatMath.ceil_int(this.edgeMinX - 0.5f), this.boundsMinX);
        int n4 = FloatMath.min(FloatMath.ceil_int(this.edgeMaxX - 0.5f), this.boundsMaxX);
        int n5 = this.edgeMinY;
        int n6 = this.edgeMaxY;
        this.buckets_minY = n5 - this.boundsMinY;
        this.buckets_maxY = n6 - this.boundsMinY;
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("edgesXY = [" + this.edgeMinX + " ... " + this.edgeMaxX + "[ [" + this.edgeMinY + " ... " + this.edgeMaxY + "[");
            MarlinUtils.logInfo("spXY    = [" + n3 + " ... " + n4 + "[ [" + n5 + " ... " + n6 + "[");
        }
        if (n3 >= n4 || n5 >= n6) {
            return;
        }
        int n7 = n3;
        int n8 = n4;
        int n9 = n5;
        int n10 = n6;
        this.initConsumer(n7, n9, n8, n10);
        if (ENABLE_BLOCK_FLAGS) {
            this.enableBlkFlags = this.useRLE;
            boolean bl2 = this.prevUseBlkFlags = this.enableBlkFlags && !ENABLE_BLOCK_FLAGS_HEURISTICS;
            if (this.enableBlkFlags && (n2 = (n8 - n7 >> BLOCK_SIZE_LG) + 2) > 256) {
                this.blkFlags = this.blkFlags_ref.getArray(n2);
            }
        }
        this.bbox_spminX = n7;
        this.bbox_spmaxX = n8;
        this.bbox_spminY = n5;
        this.bbox_spmaxY = n6;
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("pXY       = [" + n7 + " ... " + n8 + "[ [" + n9 + " ... " + n10 + "[");
            MarlinUtils.logInfo("bbox_spXY = [" + this.bbox_spminX + " ... " + this.bbox_spmaxX + "[ [" + this.bbox_spminY + " ... " + this.bbox_spmaxY + "[");
        }
        if ((n2 = n8 - n7 + 2) > INITIAL_AA_ARRAY) {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_array_renderer_alphaline.add(n2);
            }
            this.alphaLine = this.alphaLine_ref.getArray(n2);
        }
    }

    void initConsumer(int n2, int n3, int n4, int n5) {
        this.bboxX0 = n2;
        this.bboxX1 = n4;
        this.bboxY0 = n3;
        this.bboxY1 = n5;
        int n6 = n4 - n2;
        this.useRLE = FORCE_NO_RLE ? false : (FORCE_RLE ? true : n6 > RLE_MIN_WIDTH);
    }

    @Override
    public void produceAlphas(MarlinAlphaConsumer marlinAlphaConsumer) {
        marlinAlphaConsumer.setMaxAlpha(1);
        if (this.enableBlkFlags && !marlinAlphaConsumer.supportBlockFlags()) {
            this.enableBlkFlags = false;
            this.prevUseBlkFlags = false;
        }
        this._endRendering(this.bbox_spminY, this.bbox_spmaxY, marlinAlphaConsumer);
    }

    void copyAARow(int[] nArray, int n2, int n3, int n4, boolean bl2, MarlinAlphaConsumer marlinAlphaConsumer) {
        if (DO_STATS) {
            this.rdrCtx.stats.stat_cache_rowAA.add(n4 - n3);
        }
        if (bl2) {
            if (DO_STATS) {
                this.rdrCtx.stats.hist_tile_generator_encoding.add(1);
            }
            marlinAlphaConsumer.setAndClearRelativeAlphas(this.blkFlags, nArray, n2, n3, n4);
        } else {
            if (DO_STATS) {
                this.rdrCtx.stats.hist_tile_generator_encoding.add(0);
            }
            marlinAlphaConsumer.setAndClearRelativeAlphas(nArray, n2, n3, n4);
        }
    }

    @Override
    public int getOutpixMinX() {
        return this.bboxX0;
    }

    @Override
    public int getOutpixMaxX() {
        return this.bboxX1;
    }

    @Override
    public int getOutpixMinY() {
        return this.bboxY0;
    }

    @Override
    public int getOutpixMaxY() {
        return this.bboxY1;
    }

    @Override
    public float getOffsetX() {
        return 0.5f;
    }

    @Override
    public float getOffsetY() {
        return 0.5f;
    }
}

