/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.prism.Graphics;
import com.sun.prism.Material;
import com.sun.prism.d3d.D3DContext;
import com.sun.prism.d3d.D3DMesh;
import com.sun.prism.d3d.D3DPhongMaterial;
import com.sun.prism.impl.BaseMeshView;
import com.sun.prism.impl.Disposer;

class D3DMeshView
extends BaseMeshView {
    static int count = 0;
    private final D3DContext context;
    private final long nativeHandle;
    private final D3DMesh mesh;
    private D3DPhongMaterial material;

    private D3DMeshView(D3DContext d3DContext, long l2, D3DMesh d3DMesh, Disposer.Record record) {
        super(record);
        this.context = d3DContext;
        this.mesh = d3DMesh;
        this.nativeHandle = l2;
        ++count;
    }

    static D3DMeshView create(D3DContext d3DContext, D3DMesh d3DMesh) {
        long l2 = d3DContext.createD3DMeshView(d3DMesh.getNativeHandle());
        return new D3DMeshView(d3DContext, l2, d3DMesh, new D3DMeshViewDisposerRecord(d3DContext, l2));
    }

    @Override
    public void setCullingMode(int n2) {
        this.context.setCullingMode(this.nativeHandle, n2);
    }

    @Override
    public void setMaterial(Material material) {
        this.context.setMaterial(this.nativeHandle, ((D3DPhongMaterial)material).getNativeHandle());
        this.material = (D3DPhongMaterial)material;
    }

    @Override
    public void setWireframe(boolean bl2) {
        this.context.setWireframe(this.nativeHandle, bl2);
    }

    @Override
    public void setAmbientLight(float f2, float f3, float f4) {
        this.context.setAmbientLight(this.nativeHandle, f2, f3, f4);
    }

    @Override
    public void setPointLight(int n2, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (n2 >= 0 && n2 <= 2) {
            this.context.setPointLight(this.nativeHandle, n2, f2, f3, f4, f5, f6, f7, f8);
        }
    }

    @Override
    public void render(Graphics graphics) {
        this.material.lockTextureMaps();
        this.context.renderMeshView(this.nativeHandle, graphics);
        this.material.unlockTextureMaps();
    }

    @Override
    public void dispose() {
        this.material = null;
        this.disposerRecord.dispose();
        --count;
    }

    public int getCount() {
        return count;
    }

    static class D3DMeshViewDisposerRecord
    implements Disposer.Record {
        private final D3DContext context;
        private long nativeHandle;

        D3DMeshViewDisposerRecord(D3DContext d3DContext, long l2) {
            this.context = d3DContext;
            this.nativeHandle = l2;
        }

        void traceDispose() {
        }

        @Override
        public void dispose() {
            if (this.nativeHandle != 0L) {
                this.traceDispose();
                this.context.releaseD3DMeshView(this.nativeHandle);
                this.nativeHandle = 0L;
            }
        }
    }
}

