/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.shape;

import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.marlin.DMarlinRenderer;
import com.sun.marlin.DMarlinRenderingEngine;
import com.sun.marlin.DRendererContext;
import com.sun.marlin.MaskMarlinAlphaConsumer;
import com.sun.prism.BasicStroke;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.shape.DMarlinPrismUtils;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.impl.shape.ShapeRasterizer;

public final class DMarlinRasterizer
implements ShapeRasterizer {
    private static final MaskData EMPTY_MASK = MaskData.create(new byte[1], 0, 0, 1, 1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MaskData getMaskData(Shape shape, BasicStroke basicStroke, RectBounds rectBounds, BaseTransform baseTransform, boolean bl2, boolean bl3) {
        if (basicStroke != null && basicStroke.getType() != 0) {
            shape = basicStroke.createStrokedShape(shape);
            basicStroke = null;
        }
        if (rectBounds == null) {
            if (basicStroke != null) {
                shape = basicStroke.createStrokedShape(shape);
                basicStroke = null;
            }
            rectBounds = new RectBounds();
            rectBounds = (RectBounds)baseTransform.transform(shape.getBounds(), rectBounds);
        }
        if (rectBounds.isEmpty()) {
            return EMPTY_MASK;
        }
        DRendererContext dRendererContext = DMarlinRenderingEngine.getRendererContext();
        DMarlinRenderer dMarlinRenderer = null;
        try {
            Rectangle rectangle = dRendererContext.clip;
            rectangle.setBounds(rectBounds);
            dMarlinRenderer = DMarlinPrismUtils.setupRenderer(dRendererContext, shape, basicStroke, baseTransform, rectangle, bl3);
            int n2 = dMarlinRenderer.getOutpixMinX();
            int n3 = dMarlinRenderer.getOutpixMaxX();
            int n4 = dMarlinRenderer.getOutpixMinY();
            int n5 = dMarlinRenderer.getOutpixMaxY();
            int n6 = n3 - n2;
            int n7 = n5 - n4;
            if (n6 <= 0 || n7 <= 0) {
                MaskData maskData = EMPTY_MASK;
                return maskData;
            }
            MaskMarlinAlphaConsumer maskMarlinAlphaConsumer = dRendererContext.consumer;
            if (maskMarlinAlphaConsumer == null || n6 * n7 > maskMarlinAlphaConsumer.getAlphaLength()) {
                int n8 = n6 * n7 + 4095 & 0xFFFFF000;
                dRendererContext.consumer = maskMarlinAlphaConsumer = new MaskMarlinAlphaConsumer(n8);
                if (PrismSettings.verbose) {
                    System.out.println("new alphas with length = " + n8);
                }
            }
            maskMarlinAlphaConsumer.setBoundsNoClone(n2, n4, n6, n7);
            dMarlinRenderer.produceAlphas(maskMarlinAlphaConsumer);
            MaskData maskData = maskMarlinAlphaConsumer.getMaskData();
            return maskData;
        }
        finally {
            if (dMarlinRenderer != null) {
                dMarlinRenderer.dispose();
            }
            DMarlinRenderingEngine.returnRendererContext(dRendererContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Shape createCenteredStrokedShape(Shape shape, BasicStroke basicStroke) {
        float f2 = basicStroke.getType() == 0 ? basicStroke.getLineWidth() : basicStroke.getLineWidth() * 2.0f;
        DRendererContext dRendererContext = DMarlinRenderingEngine.getRendererContext();
        try {
            Path2D path2D = dRendererContext.getPath2D();
            DMarlinPrismUtils.strokeTo(dRendererContext, shape, basicStroke, f2, dRendererContext.transformerPC2D.wrapPath2D(path2D));
            Path2D path2D2 = new Path2D(path2D);
            return path2D2;
        }
        finally {
            DMarlinRenderingEngine.returnRendererContext(dRendererContext);
        }
    }
}

