/*
 * Decompiled with CFR 0.152.
 */
package com.sun.util.reentrant;

import com.sun.util.reentrant.ReentrantContext;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public abstract class ReentrantContextProvider<K extends ReentrantContext> {
    static final byte USAGE_TL_INACTIVE = 0;
    static final byte USAGE_TL_IN_USE = 1;
    static final byte USAGE_CLQ = 2;
    public static final int REF_HARD = 0;
    public static final int REF_SOFT = 1;
    public static final int REF_WEAK = 2;
    private final int refType;

    protected ReentrantContextProvider(int n2) {
        this.refType = n2;
    }

    protected abstract K newContext();

    public abstract K acquire();

    public abstract void release(K var1);

    protected final Reference<K> getOrCreateReference(K k2) {
        if (((ReentrantContext)k2).reference == null) {
            switch (this.refType) {
                case 0: {
                    ((ReentrantContext)k2).reference = new HardReference<K>(k2);
                    break;
                }
                case 1: {
                    ((ReentrantContext)k2).reference = new SoftReference<K>(k2);
                    break;
                }
                default: {
                    ((ReentrantContext)k2).reference = new WeakReference<K>(k2);
                }
            }
        }
        return ((ReentrantContext)k2).reference;
    }

    static final class HardReference<V>
    extends WeakReference<V> {
        private final V strongRef;

        HardReference(V v2) {
            super(null);
            this.strongRef = v2;
        }

        @Override
        public V get() {
            return this.strongRef;
        }
    }
}

