/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.exceptions;

import io.reactivex.rxjava3.annotations.e;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;

public final class CompositeException
extends RuntimeException {
    private static final long serialVersionUID = 3026362227162912146L;
    private final List<Throwable> exceptions;
    private final String message;
    private Throwable cause;

    public CompositeException(Throwable ... exceptions) {
        this(exceptions == null ? Collections.singletonList(new NullPointerException("exceptions was null")) : Arrays.asList(exceptions));
    }

    public CompositeException(@e Iterable<? extends Throwable> errors) {
        LinkedHashSet<Throwable> deDupedExceptions = new LinkedHashSet<Throwable>();
        if (errors != null) {
            for (Throwable throwable : errors) {
                if (throwable instanceof CompositeException) {
                    deDupedExceptions.addAll(((CompositeException)throwable).getExceptions());
                    continue;
                }
                if (throwable != null) {
                    deDupedExceptions.add(throwable);
                    continue;
                }
                deDupedExceptions.add(new NullPointerException("Throwable was null!"));
            }
        } else {
            deDupedExceptions.add(new NullPointerException("errors was null"));
        }
        if (deDupedExceptions.isEmpty()) {
            throw new IllegalArgumentException("errors is empty");
        }
        ArrayList localExceptions = new ArrayList(deDupedExceptions);
        this.exceptions = Collections.unmodifiableList(localExceptions);
        this.message = this.exceptions.size() + " exceptions occurred. ";
    }

    @e
    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    @e
    public String getMessage() {
        return this.message;
    }

    @Override
    @e
    public synchronized Throwable getCause() {
        if (this.cause == null) {
            String separator = System.getProperty("line.separator");
            if (this.exceptions.size() > 1) {
                IdentityHashMap<Throwable, Boolean> seenCauses = new IdentityHashMap<Throwable, Boolean>();
                StringBuilder aggregateMessage = new StringBuilder();
                aggregateMessage.append("Multiple exceptions (").append(this.exceptions.size()).append(")").append(separator);
                block0: for (Throwable inner : this.exceptions) {
                    int depth = 0;
                    while (inner != null) {
                        for (int i2 = 0; i2 < depth; ++i2) {
                            aggregateMessage.append("  ");
                        }
                        aggregateMessage.append("|-- ");
                        aggregateMessage.append(inner.getClass().getCanonicalName()).append(": ");
                        String innerMessage = inner.getMessage();
                        if (innerMessage != null && innerMessage.contains(separator)) {
                            aggregateMessage.append(separator);
                            for (String line : innerMessage.split(separator)) {
                                for (int i3 = 0; i3 < depth + 2; ++i3) {
                                    aggregateMessage.append("  ");
                                }
                                aggregateMessage.append(line).append(separator);
                            }
                        } else {
                            aggregateMessage.append(innerMessage);
                            aggregateMessage.append(separator);
                        }
                        for (int i4 = 0; i4 < depth + 2; ++i4) {
                            aggregateMessage.append("  ");
                        }
                        StackTraceElement[] st = inner.getStackTrace();
                        if (st.length > 0) {
                            aggregateMessage.append("at ").append(st[0]).append(separator);
                        }
                        if (!seenCauses.containsKey(inner)) {
                            seenCauses.put(inner, true);
                            inner = inner.getCause();
                            ++depth;
                            continue;
                        }
                        if ((inner = inner.getCause()) == null) continue block0;
                        for (int i5 = 0; i5 < depth + 2; ++i5) {
                            aggregateMessage.append("  ");
                        }
                        aggregateMessage.append("|-- ");
                        aggregateMessage.append("(cause not expanded again) ");
                        aggregateMessage.append(inner.getClass().getCanonicalName()).append(": ");
                        aggregateMessage.append(inner.getMessage());
                        aggregateMessage.append(separator);
                        continue block0;
                    }
                }
                this.cause = new ExceptionOverview(aggregateMessage.toString().trim());
            } else {
                this.cause = this.exceptions.get(0);
            }
        }
        return this.cause;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream s2) {
        this.a(new b(s2));
    }

    @Override
    public void printStackTrace(PrintWriter s2) {
        this.a(new c(s2));
    }

    private void a(a output) {
        output.aQ(this).aQ("\n");
        for (StackTraceElement myStackElement : this.getStackTrace()) {
            output.aQ("\tat ").aQ(myStackElement).aQ("\n");
        }
        int i2 = 1;
        for (Throwable ex : this.exceptions) {
            output.aQ("  ComposedException ").aQ(i2).aQ(" :\n");
            this.a(output, ex, "\t");
            ++i2;
        }
        output.aQ("\n");
    }

    private void a(a output, Throwable ex, String prefix) {
        output.aQ(prefix).aQ(ex).aQ(Character.valueOf('\n'));
        for (StackTraceElement stackElement : ex.getStackTrace()) {
            output.aQ("\t\tat ").aQ(stackElement).aQ(Character.valueOf('\n'));
        }
        if (ex.getCause() != null) {
            output.aQ("\tCaused by: ");
            this.a(output, ex.getCause(), "");
        }
    }

    public int size() {
        return this.exceptions.size();
    }

    static final class ExceptionOverview
    extends RuntimeException {
        private static final long serialVersionUID = 3875212506787802066L;

        ExceptionOverview(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class c
    extends a {
        private final PrintWriter KH;

        c(PrintWriter printWriter) {
            this.KH = printWriter;
        }

        c aS(Object o2) {
            this.KH.print(o2);
            return this;
        }

        @Override
        /* synthetic */ a aQ(Object object) {
            return this.aS(object);
        }
    }

    static final class b
    extends a {
        private final PrintStream KG;

        b(PrintStream printStream) {
            this.KG = printStream;
        }

        b aR(Object o2) {
            this.KG.print(o2);
            return this;
        }

        @Override
        /* synthetic */ a aQ(Object object) {
            return this.aR(object);
        }
    }

    static abstract class a {
        a() {
        }

        abstract a aQ(Object var1);
    }
}

