/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.disposables;

import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.ProtocolViolationException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public enum DisposableHelper implements b
{
    DISPOSED;


    public static boolean isDisposed(b d2) {
        return d2 == DISPOSED;
    }

    public static boolean set(AtomicReference<b> field, b d2) {
        b current;
        do {
            if ((current = field.get()) != DISPOSED) continue;
            if (d2 != null) {
                d2.dispose();
            }
            return false;
        } while (!field.compareAndSet(current, d2));
        if (current != null) {
            current.dispose();
        }
        return true;
    }

    public static boolean setOnce(AtomicReference<b> field, b d2) {
        Objects.requireNonNull(d2, "d is null");
        if (!field.compareAndSet(null, d2)) {
            d2.dispose();
            if (field.get() != DISPOSED) {
                DisposableHelper.reportDisposableSet();
            }
            return false;
        }
        return true;
    }

    public static boolean replace(AtomicReference<b> field, b d2) {
        b current;
        do {
            if ((current = field.get()) != DISPOSED) continue;
            if (d2 != null) {
                d2.dispose();
            }
            return false;
        } while (!field.compareAndSet(current, d2));
        return true;
    }

    public static boolean dispose(AtomicReference<b> field) {
        DisposableHelper d2;
        b current = field.get();
        if (current != (d2 = DISPOSED) && (current = field.getAndSet(d2)) != d2) {
            if (current != null) {
                current.dispose();
            }
            return true;
        }
        return false;
    }

    public static boolean validate(b current, b next) {
        if (next == null) {
            a.onError(new NullPointerException("next is null"));
            return false;
        }
        if (current != null) {
            next.dispose();
            DisposableHelper.reportDisposableSet();
            return false;
        }
        return true;
    }

    public static void reportDisposableSet() {
        a.onError(new ProtocolViolationException("Disposable already set!"));
    }

    public static boolean trySet(AtomicReference<b> field, b d2) {
        if (!field.compareAndSet(null, d2)) {
            if (field.get() == DISPOSED) {
                d2.dispose();
            }
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isDisposed() {
        return true;
    }
}

