/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;
import org.a.d;
import org.a.e;

public final class FlowableCollectWithCollector<T, A, R>
extends j<R> {
    final j<T> LN;
    final Collector<? super T, A, R> LO;

    public FlowableCollectWithCollector(j<T> source, Collector<? super T, A, R> collector) {
        this.LN = source;
        this.LO = collector;
    }

    @Override
    protected void d(@io.reactivex.rxjava3.annotations.e d<? super R> s2) {
        Function<A, R> finisher;
        BiConsumer<A, ? super T> accumulator;
        A container;
        try {
            container = this.LO.supplier().get();
            accumulator = this.LO.accumulator();
            finisher = this.LO.finisher();
        }
        catch (Throwable ex) {
            io.reactivex.rxjava3.exceptions.a.k(ex);
            EmptySubscription.error(ex, s2);
            return;
        }
        this.LN.a(new CollectorSubscriber<T, A, R>(s2, container, accumulator, finisher));
    }

    static final class CollectorSubscriber<T, A, R>
    extends DeferredScalarSubscription<R>
    implements o<T> {
        private static final long serialVersionUID = -229544830565448758L;
        final BiConsumer<A, T> accumulator;
        final Function<A, R> finisher;
        e upstream;
        boolean done;
        A container;

        CollectorSubscriber(d<? super R> downstream, A container, BiConsumer<A, T> accumulator, Function<A, R> finisher) {
            super(downstream);
            this.container = container;
            this.accumulator = accumulator;
            this.finisher = finisher;
        }

        @Override
        public void onSubscribe(@io.reactivex.rxjava3.annotations.e e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            try {
                this.accumulator.accept(this.container, t2);
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.cancel();
                this.onError(ex);
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                a.onError(t2);
            } else {
                this.done = true;
                this.upstream = SubscriptionHelper.CANCELLED;
                this.container = null;
                this.downstream.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            R result;
            if (this.done) {
                return;
            }
            this.done = true;
            this.upstream = SubscriptionHelper.CANCELLED;
            A container = this.container;
            this.container = null;
            try {
                result = Objects.requireNonNull(this.finisher.apply(container), "The finisher returned a null value");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.downstream.onError(ex);
                return;
            }
            this.complete(result);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
        }
    }
}

