/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.jdk8.FlowableFromStream;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.g;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.a.d;

public final class FlowableFlatMapStream<T, R>
extends j<R> {
    final j<T> LW;
    final h<? super T, ? extends Stream<? extends R>> LX;
    final int LY;

    public FlowableFlatMapStream(j<T> source, h<? super T, ? extends Stream<? extends R>> mapper, int prefetch) {
        this.LW = source;
        this.LX = mapper;
        this.LY = prefetch;
    }

    @Override
    protected void d(d<? super R> s2) {
        if (this.LW instanceof s) {
            Stream<? extends R> stream = null;
            try {
                Object t2 = ((s)((Object)this.LW)).get();
                if (t2 != null) {
                    stream = Objects.requireNonNull(this.LX.apply(t2), "The mapper returned a null Stream");
                }
            }
            catch (Throwable ex) {
                a.k(ex);
                EmptySubscription.error(ex, s2);
                return;
            }
            if (stream != null) {
                FlowableFromStream.a(s2, stream);
            } else {
                EmptySubscription.complete(s2);
            }
        } else {
            this.LW.subscribe(FlowableFlatMapStream.a(s2, this.LX, this.LY));
        }
    }

    public static <T, R> d<T> a(d<? super R> downstream, h<? super T, ? extends Stream<? extends R>> mapper, int prefetch) {
        return new FlatMapStreamSubscriber<T, R>(downstream, mapper, prefetch);
    }

    static final class FlatMapStreamSubscriber<T, R>
    extends AtomicInteger
    implements o<T>,
    org.a.e {
        private static final long serialVersionUID = -5127032662980523968L;
        final d<? super R> downstream;
        final h<? super T, ? extends Stream<? extends R>> mapper;
        final int prefetch;
        final AtomicLong requested;
        g<T> queue;
        org.a.e upstream;
        Iterator<? extends R> currentIterator;
        AutoCloseable currentCloseable;
        volatile boolean cancelled;
        volatile boolean upstreamDone;
        final AtomicThrowable error;
        long emitted;
        int consumed;
        int sourceMode;

        FlatMapStreamSubscriber(d<? super R> downstream, h<? super T, ? extends Stream<? extends R>> mapper, int prefetch) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.prefetch = prefetch;
            this.requested = new AtomicLong();
            this.error = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(@e org.a.e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                if (s2 instanceof io.reactivex.rxjava3.operators.d) {
                    io.reactivex.rxjava3.operators.d qs = (io.reactivex.rxjava3.operators.d)s2;
                    int m2 = qs.requestFusion(7);
                    if (m2 == 1) {
                        this.sourceMode = m2;
                        this.queue = qs;
                        this.upstreamDone = true;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                    if (m2 == 2) {
                        this.sourceMode = m2;
                        this.queue = qs;
                        this.downstream.onSubscribe(this);
                        s2.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                this.downstream.onSubscribe(this);
                s2.request(this.prefetch);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.sourceMode != 2 && !this.queue.offer(t2)) {
                this.upstream.cancel();
                this.onError(new QueueOverflowException());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            if (this.error.compareAndSet(null, t2)) {
                this.upstreamDone = true;
                this.drain();
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            this.upstreamDone = true;
            this.drain();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.drain();
        }

        void drain() {
            boolean canRequest;
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            d<R> downstream = this.downstream;
            g<T> queue = this.queue;
            AtomicThrowable error = this.error;
            Iterator<Object> iterator = this.currentIterator;
            long requested = this.requested.get();
            long emitted = this.emitted;
            int limit = this.prefetch - (this.prefetch >> 2);
            boolean bl2 = canRequest = this.sourceMode != 1;
            while (true) {
                if (this.cancelled) {
                    queue.clear();
                    this.clearCurrentSuppressCloseError();
                } else {
                    boolean isDone = this.upstreamDone;
                    if (error.get() != null) {
                        downstream.onError((Throwable)error.get());
                        this.cancelled = true;
                        continue;
                    }
                    if (iterator == null) {
                        boolean isEmpty;
                        T t2;
                        try {
                            t2 = queue.poll();
                        }
                        catch (Throwable ex) {
                            a.k(ex);
                            this.trySignalError(downstream, ex);
                            continue;
                        }
                        boolean bl3 = isEmpty = t2 == null;
                        if (isDone && isEmpty) {
                            downstream.onComplete();
                            this.cancelled = true;
                        } else if (!isEmpty) {
                            if (canRequest && ++this.consumed == limit) {
                                this.consumed = 0;
                                this.upstream.request(limit);
                            }
                            try {
                                Stream<R> stream = Objects.requireNonNull(this.mapper.apply(t2), "The mapper returned a null Stream");
                                iterator = stream.iterator();
                                if (iterator.hasNext()) {
                                    this.currentIterator = iterator;
                                    this.currentCloseable = stream;
                                    continue;
                                }
                                iterator = null;
                            }
                            catch (Throwable ex) {
                                a.k(ex);
                                this.trySignalError(downstream, ex);
                            }
                            continue;
                        }
                    }
                    if (iterator != null && emitted != requested) {
                        R item;
                        try {
                            item = Objects.requireNonNull(iterator.next(), "The Stream.Iterator returned a null value");
                        }
                        catch (Throwable ex) {
                            a.k(ex);
                            this.trySignalError(downstream, ex);
                            continue;
                        }
                        if (this.cancelled) continue;
                        downstream.onNext(item);
                        ++emitted;
                        if (this.cancelled) continue;
                        try {
                            if (iterator.hasNext()) continue;
                            iterator = null;
                            this.clearCurrentRethrowCloseError();
                        }
                        catch (Throwable ex) {
                            a.k(ex);
                            this.trySignalError(downstream, ex);
                        }
                        continue;
                    }
                }
                this.emitted = emitted;
                missed = this.addAndGet(-missed);
                if (missed == 0) break;
                requested = this.requested.get();
            }
        }

        void clearCurrentRethrowCloseError() throws Throwable {
            this.currentIterator = null;
            AutoCloseable ac2 = this.currentCloseable;
            this.currentCloseable = null;
            if (ac2 != null) {
                ac2.close();
            }
        }

        void clearCurrentSuppressCloseError() {
            try {
                this.clearCurrentRethrowCloseError();
            }
            catch (Throwable ex) {
                a.k(ex);
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }

        void trySignalError(d<?> downstream, Throwable ex) {
            if (this.error.compareAndSet(null, ex)) {
                this.upstream.cancel();
                this.cancelled = true;
                downstream.onError(ex);
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }
    }
}

