/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.a.d;

public final class FlowableFromStream<T>
extends j<T> {
    final Stream<T> Ma;

    public FlowableFromStream(Stream<T> stream) {
        this.Ma = stream;
    }

    @Override
    protected void d(d<? super T> s2) {
        FlowableFromStream.a(s2, this.Ma);
    }

    public static <T> void a(d<? super T> s2, Stream<T> stream) {
        Iterator iterator;
        try {
            iterator = stream.iterator();
            if (!iterator.hasNext()) {
                EmptySubscription.complete(s2);
                FlowableFromStream.b(stream);
                return;
            }
        }
        catch (Throwable ex) {
            a.k(ex);
            EmptySubscription.error(ex, s2);
            FlowableFromStream.b(stream);
            return;
        }
        if (s2 instanceof io.reactivex.rxjava3.operators.a) {
            s2.onSubscribe(new StreamConditionalSubscription((io.reactivex.rxjava3.operators.a)s2, iterator, stream));
        } else {
            s2.onSubscribe(new StreamSubscription<T>(s2, iterator, stream));
        }
    }

    static void b(AutoCloseable c2) {
        try {
            c2.close();
        }
        catch (Throwable ex) {
            a.k(ex);
            io.reactivex.rxjava3.d.a.onError(ex);
        }
    }

    static final class StreamConditionalSubscription<T>
    extends AbstractStreamSubscription<T> {
        private static final long serialVersionUID = -9082954702547571853L;
        final io.reactivex.rxjava3.operators.a<? super T> downstream;

        StreamConditionalSubscription(io.reactivex.rxjava3.operators.a<? super T> downstream, Iterator<T> iterator, AutoCloseable closeable) {
            super(iterator, closeable);
            this.downstream = downstream;
        }

        @Override
        public void run(long n2) {
            long emitted = 0L;
            Iterator iterator = this.iterator;
            io.reactivex.rxjava3.operators.a downstream = this.downstream;
            while (true) {
                block8: {
                    Object next;
                    if (this.cancelled) {
                        this.clear();
                        break;
                    }
                    try {
                        next = Objects.requireNonNull(iterator.next(), "The Stream's Iterator returned a null value");
                    }
                    catch (Throwable ex) {
                        a.k(ex);
                        downstream.onError(ex);
                        this.cancelled = true;
                        continue;
                    }
                    if (downstream.tryOnNext(next)) {
                        ++emitted;
                    }
                    if (this.cancelled) continue;
                    try {
                        if (!iterator.hasNext()) {
                            downstream.onComplete();
                            this.cancelled = true;
                        }
                        break block8;
                    }
                    catch (Throwable ex) {
                        a.k(ex);
                        downstream.onError(ex);
                        this.cancelled = true;
                    }
                    continue;
                }
                if (emitted != n2 || emitted != (n2 = this.get())) continue;
                if (this.compareAndSet(n2, 0L)) break;
                n2 = this.get();
            }
        }
    }

    static final class StreamSubscription<T>
    extends AbstractStreamSubscription<T> {
        private static final long serialVersionUID = -9082954702547571853L;
        final d<? super T> downstream;

        StreamSubscription(d<? super T> downstream, Iterator<T> iterator, AutoCloseable closeable) {
            super(iterator, closeable);
            this.downstream = downstream;
        }

        @Override
        public void run(long n2) {
            long emitted = 0L;
            Iterator iterator = this.iterator;
            d downstream = this.downstream;
            while (true) {
                block7: {
                    Object next;
                    if (this.cancelled) {
                        this.clear();
                        break;
                    }
                    try {
                        next = Objects.requireNonNull(iterator.next(), "The Stream's Iterator returned a null value");
                    }
                    catch (Throwable ex) {
                        a.k(ex);
                        downstream.onError(ex);
                        this.cancelled = true;
                        continue;
                    }
                    downstream.onNext(next);
                    if (this.cancelled) continue;
                    try {
                        if (!iterator.hasNext()) {
                            downstream.onComplete();
                            this.cancelled = true;
                        }
                        break block7;
                    }
                    catch (Throwable ex) {
                        a.k(ex);
                        downstream.onError(ex);
                        this.cancelled = true;
                    }
                    continue;
                }
                if (++emitted != n2 || emitted != (n2 = this.get())) continue;
                if (this.compareAndSet(n2, 0L)) break;
                n2 = this.get();
            }
        }
    }

    static abstract class AbstractStreamSubscription<T>
    extends AtomicLong
    implements io.reactivex.rxjava3.operators.d<T> {
        private static final long serialVersionUID = -9082954702547571853L;
        Iterator<T> iterator;
        AutoCloseable closeable;
        volatile boolean cancelled;
        boolean once;

        AbstractStreamSubscription(Iterator<T> iterator, AutoCloseable closeable) {
            this.iterator = iterator;
            this.closeable = closeable;
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2) && b.a(this, n2) == 0L) {
                this.run(n2);
            }
        }

        abstract void run(long var1);

        @Override
        public void cancel() {
            this.cancelled = true;
            this.request(1L);
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 1) != 0) {
                this.lazySet(Long.MAX_VALUE);
                return 1;
            }
            return 0;
        }

        @Override
        public boolean offer(@e T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offer(@e T v1, @e T v2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @f
        public T poll() {
            if (this.iterator == null) {
                return null;
            }
            if (!this.once) {
                this.once = true;
            } else if (!this.iterator.hasNext()) {
                this.clear();
                return null;
            }
            return Objects.requireNonNull(this.iterator.next(), "The Stream's Iterator.next() returned a null value");
        }

        @Override
        public boolean isEmpty() {
            Iterator<T> it = this.iterator;
            if (it != null) {
                if (!this.once || it.hasNext()) {
                    return false;
                }
                this.clear();
            }
            return true;
        }

        @Override
        public void clear() {
            this.iterator = null;
            AutoCloseable c2 = this.closeable;
            this.closeable = null;
            if (c2 != null) {
                FlowableFromStream.b(c2);
            }
        }
    }
}

