/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.q;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.a.d;

public final class MaybeFlattenStreamAsFlowable<T, R>
extends j<R> {
    final q<T> Mk;
    final h<? super T, ? extends Stream<? extends R>> Ml;

    public MaybeFlattenStreamAsFlowable(q<T> source, h<? super T, ? extends Stream<? extends R>> mapper) {
        this.Mk = source;
        this.Ml = mapper;
    }

    @Override
    protected void d(@e d<? super R> s2) {
        this.Mk.c(new FlattenStreamMultiObserver<T, R>(s2, this.Ml));
    }

    static final class FlattenStreamMultiObserver<T, R>
    extends BasicIntQueueSubscription<R>
    implements al<T>,
    t<T> {
        private static final long serialVersionUID = 7363336003027148283L;
        final d<? super R> downstream;
        final h<? super T, ? extends Stream<? extends R>> mapper;
        final AtomicLong requested;
        b upstream;
        volatile Iterator<? extends R> iterator;
        AutoCloseable close;
        boolean once;
        volatile boolean cancelled;
        boolean outputFused;
        long emitted;

        FlattenStreamMultiObserver(d<? super R> downstream, h<? super T, ? extends Stream<? extends R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(@e b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(@e T t2) {
            try {
                Stream<R> stream = Objects.requireNonNull(this.mapper.apply(t2), "The mapper returned a null Stream");
                Iterator iterator = stream.iterator();
                Stream<R> c2 = stream;
                if (!iterator.hasNext()) {
                    this.downstream.onComplete();
                    this.close(c2);
                    return;
                }
                this.iterator = iterator;
                this.close = stream;
            }
            catch (Throwable ex) {
                a.k(ex);
                this.downstream.onError(ex);
                return;
            }
            this.drain();
        }

        @Override
        public void onError(@e Throwable e2) {
            this.downstream.onError(e2);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.dispose();
            if (!this.outputFused) {
                this.drain();
            }
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        @f
        public R poll() throws Throwable {
            Iterator<R> it = this.iterator;
            if (it != null) {
                if (this.once) {
                    if (!it.hasNext()) {
                        this.clear();
                        return null;
                    }
                } else {
                    this.once = true;
                }
                return it.next();
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            Iterator<R> it = this.iterator;
            if (it != null) {
                if (!this.once) {
                    return false;
                }
                if (it.hasNext()) {
                    return false;
                }
                this.clear();
            }
            return true;
        }

        @Override
        public void clear() {
            this.iterator = null;
            AutoCloseable close = this.close;
            this.close = null;
            this.close(close);
        }

        void close(AutoCloseable c2) {
            try {
                if (c2 != null) {
                    c2.close();
                }
            }
            catch (Throwable ex) {
                a.k(ex);
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            d<R> downstream = this.downstream;
            long emitted = this.emitted;
            long requested = this.requested.get();
            Iterator<R> it = this.iterator;
            while (true) {
                if (this.cancelled) {
                    this.clear();
                } else if (this.outputFused) {
                    if (it != null) {
                        downstream.onNext(null);
                        downstream.onComplete();
                    }
                } else if (it != null && emitted != requested) {
                    boolean has;
                    R item;
                    try {
                        item = it.next();
                    }
                    catch (Throwable ex) {
                        a.k(ex);
                        downstream.onError(ex);
                        this.cancelled = true;
                        continue;
                    }
                    if (this.cancelled) continue;
                    downstream.onNext(item);
                    ++emitted;
                    if (this.cancelled) continue;
                    try {
                        has = it.hasNext();
                    }
                    catch (Throwable ex) {
                        a.k(ex);
                        downstream.onError(ex);
                        this.cancelled = true;
                        continue;
                    }
                    if (this.cancelled || has) continue;
                    downstream.onComplete();
                    this.cancelled = true;
                    continue;
                }
                this.emitted = emitted;
                missed = this.addAndGet(-missed);
                if (missed == 0) {
                    return;
                }
                requested = this.requested.get();
                if (it != null) continue;
                it = this.iterator;
            }
        }
    }
}

