/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.q;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.observers.BasicIntQueueDisposable;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

public final class MaybeFlattenStreamAsObservable<T, R>
extends z<R> {
    final q<T> Mm;
    final h<? super T, ? extends Stream<? extends R>> Mn;

    public MaybeFlattenStreamAsObservable(q<T> source, h<? super T, ? extends Stream<? extends R>> mapper) {
        this.Mm = source;
        this.Mn = mapper;
    }

    @Override
    protected void d(@e ag<? super R> s2) {
        this.Mm.c(new FlattenStreamMultiObserver<T, R>(s2, this.Mn));
    }

    static final class FlattenStreamMultiObserver<T, R>
    extends BasicIntQueueDisposable<R>
    implements al<T>,
    t<T> {
        private static final long serialVersionUID = 7363336003027148283L;
        final ag<? super R> downstream;
        final h<? super T, ? extends Stream<? extends R>> mapper;
        b upstream;
        volatile Iterator<? extends R> iterator;
        AutoCloseable close;
        boolean once;
        volatile boolean disposed;
        boolean outputFused;

        FlattenStreamMultiObserver(ag<? super R> downstream, h<? super T, ? extends Stream<? extends R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
        }

        @Override
        public void onSubscribe(@e b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(@e T t2) {
            try {
                Stream<R> stream = Objects.requireNonNull(this.mapper.apply(t2), "The mapper returned a null Stream");
                Iterator iterator = stream.iterator();
                Stream<R> c2 = stream;
                if (!iterator.hasNext()) {
                    this.downstream.onComplete();
                    this.close(c2);
                    return;
                }
                this.iterator = iterator;
                this.close = stream;
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.downstream.onError(ex);
                return;
            }
            this.drain();
        }

        @Override
        public void onError(@e Throwable e2) {
            this.downstream.onError(e2);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.upstream.dispose();
            if (!this.outputFused) {
                this.drain();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        @f
        public R poll() throws Throwable {
            Iterator<R> it = this.iterator;
            if (it != null) {
                if (this.once) {
                    if (!it.hasNext()) {
                        this.clear();
                        return null;
                    }
                } else {
                    this.once = true;
                }
                return it.next();
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            Iterator<R> it = this.iterator;
            if (it != null) {
                if (!this.once) {
                    return false;
                }
                if (it.hasNext()) {
                    return false;
                }
                this.clear();
            }
            return true;
        }

        @Override
        public void clear() {
            this.iterator = null;
            AutoCloseable close = this.close;
            this.close = null;
            this.close(close);
        }

        void close(AutoCloseable c2) {
            try {
                if (c2 != null) {
                    c2.close();
                }
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                a.onError(ex);
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            ag<R> downstream = this.downstream;
            Iterator<R> it = this.iterator;
            while (true) {
                if (this.disposed) {
                    this.clear();
                } else if (this.outputFused) {
                    downstream.onNext(null);
                    downstream.onComplete();
                } else {
                    boolean has;
                    R item;
                    try {
                        item = it.next();
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        downstream.onError(ex);
                        this.disposed = true;
                        continue;
                    }
                    if (this.disposed) continue;
                    downstream.onNext(item);
                    if (this.disposed) continue;
                    try {
                        has = it.hasNext();
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        downstream.onError(ex);
                        this.disposed = true;
                        continue;
                    }
                    if (this.disposed || has) continue;
                    downstream.onComplete();
                    this.disposed = true;
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

