/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.observers.DeferredScalarDisposable;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;

public final class ObservableCollectWithCollector<T, A, R>
extends z<R> {
    final z<T> Mv;
    final Collector<? super T, A, R> Mw;

    public ObservableCollectWithCollector(z<T> source, Collector<? super T, A, R> collector) {
        this.Mv = source;
        this.Mw = collector;
    }

    @Override
    protected void d(@e ag<? super R> observer) {
        Function<A, R> finisher;
        BiConsumer<A, ? super T> accumulator;
        A container;
        try {
            container = this.Mw.supplier().get();
            accumulator = this.Mw.accumulator();
            finisher = this.Mw.finisher();
        }
        catch (Throwable ex) {
            io.reactivex.rxjava3.exceptions.a.k(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        this.Mv.subscribe(new CollectorObserver<T, A, R>(observer, container, accumulator, finisher));
    }

    static final class CollectorObserver<T, A, R>
    extends DeferredScalarDisposable<R>
    implements ag<T> {
        private static final long serialVersionUID = -229544830565448758L;
        final BiConsumer<A, T> accumulator;
        final Function<A, R> finisher;
        b upstream;
        boolean done;
        A container;

        CollectorObserver(ag<? super R> downstream, A container, BiConsumer<A, T> accumulator, Function<A, R> finisher) {
            super(downstream);
            this.container = container;
            this.accumulator = accumulator;
            this.finisher = finisher;
        }

        @Override
        public void onSubscribe(@e b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            try {
                this.accumulator.accept(this.container, t2);
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.dispose();
                this.onError(ex);
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                a.onError(t2);
            } else {
                this.done = true;
                this.upstream = DisposableHelper.DISPOSED;
                this.container = null;
                this.downstream.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            R result;
            if (this.done) {
                return;
            }
            this.done = true;
            this.upstream = DisposableHelper.DISPOSED;
            A container = this.container;
            this.container = null;
            try {
                result = Objects.requireNonNull(this.finisher.apply(container), "The finisher returned a null value");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.downstream.onError(ex);
                return;
            }
            this.complete(result);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.upstream.dispose();
        }
    }
}

