/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.jdk8.m;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

public final class ObservableFlatMapStream<T, R>
extends z<R> {
    final z<T> ME;
    final h<? super T, ? extends Stream<? extends R>> MF;

    public ObservableFlatMapStream(z<T> source, h<? super T, ? extends Stream<? extends R>> mapper) {
        this.ME = source;
        this.MF = mapper;
    }

    @Override
    protected void d(ag<? super R> observer) {
        if (this.ME instanceof s) {
            Stream<? extends R> stream = null;
            try {
                Object t2 = ((s)((Object)this.ME)).get();
                if (t2 != null) {
                    stream = Objects.requireNonNull(this.MF.apply(t2), "The mapper returned a null Stream");
                }
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                EmptyDisposable.error(ex, observer);
                return;
            }
            if (stream != null) {
                m.a(observer, stream);
            } else {
                EmptyDisposable.complete(observer);
            }
        } else {
            this.ME.subscribe(new FlatMapStreamObserver<T, R>(observer, this.MF));
        }
    }

    static final class FlatMapStreamObserver<T, R>
    extends AtomicInteger
    implements ag<T>,
    b {
        private static final long serialVersionUID = -5127032662980523968L;
        final ag<? super R> downstream;
        final h<? super T, ? extends Stream<? extends R>> mapper;
        b upstream;
        volatile boolean disposed;
        boolean done;

        FlatMapStreamObserver(ag<? super R> downstream, h<? super T, ? extends Stream<? extends R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
        }

        @Override
        public void onSubscribe(@e b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(@e T t2) {
            if (this.done) {
                return;
            }
            try (Stream<R> stream = Objects.requireNonNull(this.mapper.apply(t2), "The mapper returned a null Stream");){
                Iterator it = stream.iterator();
                while (it.hasNext()) {
                    if (this.disposed) {
                        this.done = true;
                    } else {
                        Object value = Objects.requireNonNull(it.next(), "The Stream's Iterator.next returned a null value");
                        if (this.disposed) {
                            this.done = true;
                        } else {
                            this.downstream.onNext(value);
                            if (!this.disposed) continue;
                            this.done = true;
                        }
                    }
                    break;
                }
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.dispose();
                this.onError(ex);
            }
        }

        @Override
        public void onError(@e Throwable e2) {
            if (this.done) {
                a.onError(e2);
            } else {
                this.done = true;
                this.downstream.onError(e2);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.downstream.onComplete();
            }
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

