/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.ai;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.a.e;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.jdk8.ObservableCollectWithCollector;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;

public final class k<T, A, R>
extends ai<R>
implements e<R> {
    final z<T> Mx;
    final Collector<? super T, A, R> My;

    public k(z<T> source, Collector<? super T, A, R> collector) {
        this.Mx = source;
        this.My = collector;
    }

    @Override
    public z<R> pD() {
        return new ObservableCollectWithCollector<T, A, R>(this.Mx, this.My);
    }

    @Override
    protected void d(@io.reactivex.rxjava3.annotations.e al<? super R> observer) {
        Function<A, R> finisher;
        BiConsumer<A, ? super T> accumulator;
        A container;
        try {
            container = this.My.supplier().get();
            accumulator = this.My.accumulator();
            finisher = this.My.finisher();
        }
        catch (Throwable ex) {
            io.reactivex.rxjava3.exceptions.a.k(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        this.Mx.subscribe(new a<T, A, R>(observer, container, accumulator, finisher));
    }

    static final class a<T, A, R>
    implements ag<T>,
    b {
        final al<? super R> Mz;
        final BiConsumer<A, T> MA;
        final Function<A, R> MB;
        b upstream;
        boolean done;
        A container;

        a(al<? super R> downstream, A container, BiConsumer<A, T> accumulator, Function<A, R> finisher) {
            this.Mz = downstream;
            this.container = container;
            this.MA = accumulator;
            this.MB = finisher;
        }

        @Override
        public void onSubscribe(@io.reactivex.rxjava3.annotations.e b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.Mz.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            try {
                this.MA.accept(this.container, t2);
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.dispose();
                this.onError(ex);
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
            } else {
                this.done = true;
                this.upstream = DisposableHelper.DISPOSED;
                this.container = null;
                this.Mz.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            R result;
            if (this.done) {
                return;
            }
            this.done = true;
            this.upstream = DisposableHelper.DISPOSED;
            A container = this.container;
            this.container = null;
            try {
                result = Objects.requireNonNull(this.MB.apply(container), "The finisher returned a null value");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.Mz.onError(ex);
                return;
            }
            this.Mz.onSuccess(result);
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            this.upstream = DisposableHelper.DISPOSED;
        }

        @Override
        public boolean isDisposed() {
            return this.upstream == DisposableHelper.DISPOSED;
        }
    }
}

