/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;

public final class BlockingObserver<T>
extends AtomicReference<b>
implements ag<T>,
b {
    private static final long serialVersionUID = -4875965440900746268L;
    public static final Object TERMINATED = new Object();
    final Queue<Object> queue;

    public BlockingObserver(Queue<Object> queue) {
        this.queue = queue;
    }

    @Override
    public void onSubscribe(b d2) {
        DisposableHelper.setOnce(this, d2);
    }

    @Override
    public void onNext(T t2) {
        this.queue.offer(NotificationLite.next(t2));
    }

    @Override
    public void onError(Throwable t2) {
        this.queue.offer(NotificationLite.error(t2));
    }

    @Override
    public void onComplete() {
        this.queue.offer(NotificationLite.complete());
    }

    @Override
    public void dispose() {
        if (DisposableHelper.dispose(this)) {
            this.queue.offer(TERMINATED);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.get() == DisposableHelper.DISPOSED;
    }
}

