/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.b.a;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.observers.g;
import java.util.concurrent.atomic.AtomicReference;

public final class LambdaObserver<T>
extends AtomicReference<b>
implements ag<T>,
b,
g {
    private static final long serialVersionUID = -7251123623727029452L;
    final io.reactivex.rxjava3.b.g<? super T> onNext;
    final io.reactivex.rxjava3.b.g<? super Throwable> onError;
    final a onComplete;
    final io.reactivex.rxjava3.b.g<? super b> onSubscribe;

    public LambdaObserver(io.reactivex.rxjava3.b.g<? super T> onNext, io.reactivex.rxjava3.b.g<? super Throwable> onError, a onComplete, io.reactivex.rxjava3.b.g<? super b> onSubscribe) {
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
        this.onSubscribe = onSubscribe;
    }

    @Override
    public void onSubscribe(b d2) {
        if (DisposableHelper.setOnce(this, d2)) {
            try {
                this.onSubscribe.accept(this);
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                d2.dispose();
                this.onError(ex);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        if (!this.isDisposed()) {
            try {
                this.onNext.accept(t2);
            }
            catch (Throwable e2) {
                io.reactivex.rxjava3.exceptions.a.k(e2);
                ((b)this.get()).dispose();
                this.onError(e2);
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (!this.isDisposed()) {
            this.lazySet(DisposableHelper.DISPOSED);
            try {
                this.onError.accept(t2);
            }
            catch (Throwable e2) {
                io.reactivex.rxjava3.exceptions.a.k(e2);
                io.reactivex.rxjava3.d.a.onError(new CompositeException(t2, e2));
            }
        } else {
            io.reactivex.rxjava3.d.a.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (!this.isDisposed()) {
            this.lazySet(DisposableHelper.DISPOSED);
            try {
                this.onComplete.run();
            }
            catch (Throwable e2) {
                io.reactivex.rxjava3.exceptions.a.k(e2);
                io.reactivex.rxjava3.d.a.onError(e2);
            }
        }
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return this.get() == DisposableHelper.DISPOSED;
    }

    @Override
    public boolean hasCustomOnError() {
        return this.onError != Functions.KT;
    }
}

