/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.c;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public final class j<T>
extends CountDownLatch
implements ag<T>,
b,
Future<T> {
    T value;
    Throwable error;
    final AtomicReference<b> NG = new AtomicReference();

    public j() {
        super(1);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        b a2;
        do {
            if ((a2 = this.NG.get()) != this && a2 != DisposableHelper.DISPOSED) continue;
            return false;
        } while (!this.NG.compareAndSet(a2, DisposableHelper.DISPOSED));
        if (a2 != null) {
            a2.dispose();
        }
        this.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return DisposableHelper.isDisposed(this.NG.get());
    }

    @Override
    public boolean isDone() {
        return this.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (this.getCount() != 0L) {
            c.qC();
            this.await();
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex = this.error;
        if (ex != null) {
            throw new ExecutionException(ex);
        }
        return this.value;
    }

    @Override
    public T get(long timeout, @e TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.getCount() != 0L) {
            c.qC();
            if (!this.await(timeout, unit)) {
                throw new TimeoutException(ExceptionHelper.Y(timeout, unit));
            }
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex = this.error;
        if (ex != null) {
            throw new ExecutionException(ex);
        }
        return this.value;
    }

    @Override
    public void onSubscribe(b d2) {
        DisposableHelper.setOnce(this.NG, d2);
    }

    @Override
    public void onNext(T t2) {
        if (this.value != null) {
            this.NG.get().dispose();
            this.onError(new IndexOutOfBoundsException("More than one element received"));
            return;
        }
        this.value = t2;
    }

    @Override
    public void onError(Throwable t2) {
        b a2;
        if (this.error == null && (a2 = this.NG.get()) != this && a2 != DisposableHelper.DISPOSED && this.NG.compareAndSet(a2, this)) {
            this.error = t2;
            this.countDown();
            return;
        }
        a.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.value == null) {
            this.onError(new NoSuchElementException("The source is empty"));
            return;
        }
        b a2 = this.NG.get();
        if (a2 == this || a2 == DisposableHelper.DISPOSED) {
            return;
        }
        if (this.NG.compareAndSet(a2, this)) {
            this.countDown();
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isDisposed() {
        return this.isDone();
    }
}

