/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.a;
import io.reactivex.rxjava3.core.d;
import io.reactivex.rxjava3.core.g;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.h;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.e;

public final class CompletableConcat
extends a {
    final c<? extends g> OL;
    final int OM;

    public CompletableConcat(c<? extends g> sources, int prefetch) {
        this.OL = sources;
        this.OM = prefetch;
    }

    @Override
    public void d(d observer) {
        this.OL.subscribe(new CompletableConcatSubscriber(observer, this.OM));
    }

    static final class CompletableConcatSubscriber
    extends AtomicInteger
    implements o<g>,
    b {
        private static final long serialVersionUID = 9032184911934499404L;
        final d downstream;
        final int prefetch;
        final int limit;
        final ConcatInnerObserver inner;
        final AtomicBoolean once;
        int sourceFused;
        int consumed;
        io.reactivex.rxjava3.operators.g<g> queue;
        e upstream;
        volatile boolean done;
        volatile boolean active;

        CompletableConcatSubscriber(d actual, int prefetch) {
            this.downstream = actual;
            this.prefetch = prefetch;
            this.inner = new ConcatInnerObserver(this);
            this.once = new AtomicBoolean();
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                long r2;
                this.upstream = s2;
                long l2 = r2 = this.prefetch == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.prefetch;
                if (s2 instanceof io.reactivex.rxjava3.operators.d) {
                    io.reactivex.rxjava3.operators.d qs = (io.reactivex.rxjava3.operators.d)s2;
                    int m2 = qs.requestFusion(3);
                    if (m2 == 1) {
                        this.sourceFused = m2;
                        this.queue = qs;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        this.drain();
                        return;
                    }
                    if (m2 == 2) {
                        this.sourceFused = m2;
                        this.queue = qs;
                        this.downstream.onSubscribe(this);
                        s2.request(r2);
                        return;
                    }
                }
                this.queue = this.prefetch == Integer.MAX_VALUE ? new h<g>(j.mB()) : new SpscArrayQueue<g>(this.prefetch);
                this.downstream.onSubscribe(this);
                s2.request(r2);
            }
        }

        @Override
        public void onNext(g t2) {
            if (this.sourceFused == 0 && !this.queue.offer(t2)) {
                this.onError(new QueueOverflowException());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            if (this.once.compareAndSet(false, true)) {
                DisposableHelper.dispose(this.inner);
                this.downstream.onError(t2);
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            this.upstream.cancel();
            DisposableHelper.dispose(this.inner);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.inner.get());
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            do {
                boolean empty;
                g cs;
                if (this.isDisposed()) {
                    return;
                }
                if (this.active) continue;
                boolean d2 = this.done;
                try {
                    cs = this.queue.poll();
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    this.innerError(ex);
                    return;
                }
                boolean bl2 = empty = cs == null;
                if (d2 && empty) {
                    this.downstream.onComplete();
                    return;
                }
                if (empty) continue;
                this.active = true;
                cs.c(this.inner);
                this.request();
            } while (this.decrementAndGet() != 0);
        }

        void request() {
            if (this.sourceFused != 1) {
                int p2 = this.consumed + 1;
                if (p2 == this.limit) {
                    this.consumed = 0;
                    this.upstream.request(p2);
                } else {
                    this.consumed = p2;
                }
            }
        }

        void innerError(Throwable e2) {
            if (this.once.compareAndSet(false, true)) {
                this.upstream.cancel();
                this.downstream.onError(e2);
            } else {
                io.reactivex.rxjava3.d.a.onError(e2);
            }
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        static final class ConcatInnerObserver
        extends AtomicReference<b>
        implements d {
            private static final long serialVersionUID = -5454794857847146511L;
            final CompletableConcatSubscriber parent;

            ConcatInnerObserver(CompletableConcatSubscriber parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.replace(this, d2);
            }

            @Override
            public void onError(Throwable e2) {
                this.parent.innerError(e2);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }
        }
    }
}

