/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.a;
import io.reactivex.rxjava3.core.d;
import io.reactivex.rxjava3.core.g;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.e;

public final class CompletableMerge
extends a {
    final c<? extends g> source;
    final int PD;
    final boolean PE;

    public CompletableMerge(c<? extends g> source, int maxConcurrency, boolean delayErrors) {
        this.source = source;
        this.PD = maxConcurrency;
        this.PE = delayErrors;
    }

    @Override
    public void d(d observer) {
        CompletableMergeSubscriber parent = new CompletableMergeSubscriber(observer, this.PD, this.PE);
        this.source.subscribe(parent);
    }

    static final class CompletableMergeSubscriber
    extends AtomicInteger
    implements o<g>,
    b {
        private static final long serialVersionUID = -2108443387387077490L;
        final d downstream;
        final int maxConcurrency;
        final boolean delayErrors;
        final AtomicThrowable errors;
        final io.reactivex.rxjava3.disposables.a set;
        e upstream;

        CompletableMergeSubscriber(d actual, int maxConcurrency, boolean delayErrors) {
            this.downstream = actual;
            this.maxConcurrency = maxConcurrency;
            this.delayErrors = delayErrors;
            this.set = new io.reactivex.rxjava3.disposables.a();
            this.errors = new AtomicThrowable();
            this.lazySet(1);
        }

        @Override
        public void dispose() {
            this.upstream.cancel();
            this.set.dispose();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public boolean isDisposed() {
            return this.set.isDisposed();
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                if (this.maxConcurrency == Integer.MAX_VALUE) {
                    s2.request(Long.MAX_VALUE);
                } else {
                    s2.request(this.maxConcurrency);
                }
            }
        }

        @Override
        public void onNext(g t2) {
            this.getAndIncrement();
            MergeInnerObserver inner = new MergeInnerObserver();
            this.set.a((b)inner);
            t2.c(inner);
        }

        @Override
        public void onError(Throwable t2) {
            if (!this.delayErrors) {
                this.set.dispose();
                if (this.errors.tryAddThrowableOrReport(t2) && this.getAndSet(0) > 0) {
                    this.errors.tryTerminateConsumer(this.downstream);
                }
            } else if (this.errors.tryAddThrowableOrReport(t2) && this.decrementAndGet() == 0) {
                this.errors.tryTerminateConsumer(this.downstream);
            }
        }

        @Override
        public void onComplete() {
            if (this.decrementAndGet() == 0) {
                this.errors.tryTerminateConsumer(this.downstream);
            }
        }

        void innerError(MergeInnerObserver inner, Throwable t2) {
            this.set.c(inner);
            if (!this.delayErrors) {
                this.upstream.cancel();
                this.set.dispose();
                if (this.errors.tryAddThrowableOrReport(t2) && this.getAndSet(0) > 0) {
                    this.errors.tryTerminateConsumer(this.downstream);
                }
            } else if (this.errors.tryAddThrowableOrReport(t2)) {
                if (this.decrementAndGet() == 0) {
                    this.errors.tryTerminateConsumer(this.downstream);
                } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                    this.upstream.request(1L);
                }
            }
        }

        void innerComplete(MergeInnerObserver inner) {
            this.set.c(inner);
            if (this.decrementAndGet() == 0) {
                this.errors.tryTerminateConsumer(this.downstream);
            } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                this.upstream.request(1L);
            }
        }

        final class MergeInnerObserver
        extends AtomicReference<b>
        implements d,
        b {
            private static final long serialVersionUID = 251330541679988317L;

            MergeInnerObserver() {
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(this, d2);
            }

            @Override
            public void onError(Throwable e2) {
                CompletableMergeSubscriber.this.innerError(this, e2);
            }

            @Override
            public void onComplete() {
                CompletableMergeSubscriber.this.innerComplete(this);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((b)this.get());
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

