/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.b.g;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.a;
import io.reactivex.rxjava3.core.d;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableUsing<R>
extends a {
    final s<R> QN;
    final h<? super R, ? extends io.reactivex.rxjava3.core.g> QO;
    final g<? super R> QP;
    final boolean QQ;

    public CompletableUsing(s<R> resourceSupplier, h<? super R, ? extends io.reactivex.rxjava3.core.g> completableFunction, g<? super R> disposer, boolean eager) {
        this.QN = resourceSupplier;
        this.QO = completableFunction;
        this.QP = disposer;
        this.QQ = eager;
    }

    @Override
    protected void d(d observer) {
        io.reactivex.rxjava3.core.g source;
        R resource;
        try {
            resource = this.QN.get();
        }
        catch (Throwable ex) {
            io.reactivex.rxjava3.exceptions.a.k(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        try {
            source = Objects.requireNonNull(this.QO.apply(resource), "The completableFunction returned a null CompletableSource");
        }
        catch (Throwable ex) {
            io.reactivex.rxjava3.exceptions.a.k(ex);
            if (this.QQ) {
                try {
                    this.QP.accept(resource);
                }
                catch (Throwable exc) {
                    io.reactivex.rxjava3.exceptions.a.k(exc);
                    EmptyDisposable.error((Throwable)new CompositeException(ex, exc), observer);
                    return;
                }
            }
            EmptyDisposable.error(ex, observer);
            if (!this.QQ) {
                try {
                    this.QP.accept(resource);
                }
                catch (Throwable exc) {
                    io.reactivex.rxjava3.exceptions.a.k(exc);
                    io.reactivex.rxjava3.d.a.onError(exc);
                }
            }
            return;
        }
        source.c(new UsingObserver<R>(observer, resource, this.QP, this.QQ));
    }

    static final class UsingObserver<R>
    extends AtomicReference<Object>
    implements d,
    b {
        private static final long serialVersionUID = -674404550052917487L;
        final d downstream;
        final g<? super R> disposer;
        final boolean eager;
        b upstream;

        UsingObserver(d actual, R resource, g<? super R> disposer, boolean eager) {
            super(resource);
            this.downstream = actual;
            this.disposer = disposer;
            this.eager = eager;
        }

        @Override
        public void dispose() {
            if (this.eager) {
                this.disposeResource();
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
            } else {
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
                this.disposeResource();
            }
        }

        void disposeResource() {
            UsingObserver resource = this.getAndSet(this);
            if (resource != this) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    io.reactivex.rxjava3.d.a.onError(ex);
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onError(Throwable e2) {
            this.upstream = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingObserver resource = this.getAndSet(this);
                if (resource != this) {
                    try {
                        this.disposer.accept(resource);
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        e2 = new CompositeException(e2, ex);
                    }
                } else {
                    return;
                }
            }
            this.downstream.onError(e2);
            if (!this.eager) {
                this.disposeResource();
            }
        }

        @Override
        public void onComplete() {
            this.upstream = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingObserver resource = this.getAndSet(this);
                if (resource != this) {
                    try {
                        this.disposer.accept(resource);
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        this.downstream.onError(ex);
                        return;
                    }
                } else {
                    return;
                }
            }
            this.downstream.onComplete();
            if (!this.eager) {
                this.disposeResource();
            }
        }
    }
}

