/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

abstract class AbstractBackpressureThrottlingSubscriber<T, R>
extends AtomicInteger
implements o<T>,
e {
    private static final long serialVersionUID = -5050301752721603566L;
    final d<? super R> downstream;
    e upstream;
    volatile boolean done;
    Throwable error;
    volatile boolean cancelled;
    final AtomicLong requested = new AtomicLong();
    final AtomicReference<R> current = new AtomicReference();

    AbstractBackpressureThrottlingSubscriber(d<? super R> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(e s2) {
        if (SubscriptionHelper.validate(this.upstream, s2)) {
            this.upstream = s2;
            this.downstream.onSubscribe(this);
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public abstract void onNext(T var1);

    @Override
    public void onError(Throwable t2) {
        this.error = t2;
        this.done = true;
        this.drain();
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.drain();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            b.a(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.upstream.cancel();
            if (this.getAndIncrement() == 0) {
                this.current.lazySet(null);
            }
        }
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        d<R> a2 = this.downstream;
        int missed = 1;
        AtomicLong r2 = this.requested;
        AtomicReference<R> q2 = this.current;
        do {
            long e2;
            for (e2 = 0L; e2 != r2.get(); ++e2) {
                boolean empty;
                boolean d2 = this.done;
                Object v2 = q2.getAndSet(null);
                boolean bl2 = empty = v2 == null;
                if (this.checkTerminated(d2, empty, a2, q2)) {
                    return;
                }
                if (empty) break;
                a2.onNext(v2);
            }
            if (e2 == r2.get() && this.checkTerminated(this.done, q2.get() == null, a2, q2)) {
                return;
            }
            if (e2 == 0L) continue;
            b.c(r2, e2);
        } while ((missed = this.addAndGet(-missed)) != 0);
    }

    boolean checkTerminated(boolean d2, boolean empty, d<?> a2, AtomicReference<R> q2) {
        if (this.cancelled) {
            q2.lazySet(null);
            return true;
        }
        if (d2) {
            Throwable e2 = this.error;
            if (e2 != null) {
                q2.lazySet(null);
                a2.onError(e2);
                return true;
            }
            if (empty) {
                a2.onComplete();
                return true;
            }
        }
        return false;
    }
}

