/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.c;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.a.e;

public final class BlockingFlowableIterable<T>
implements Iterable<T> {
    final j<T> QS;
    final int QT;

    public BlockingFlowableIterable(j<T> source, int bufferSize) {
        this.QS = source;
        this.QT = bufferSize;
    }

    @Override
    public Iterator<T> iterator() {
        BlockingFlowableIterator it = new BlockingFlowableIterator(this.QT);
        this.QS.a(it);
        return it;
    }

    static final class BlockingFlowableIterator<T>
    extends AtomicReference<e>
    implements o<T>,
    b,
    Runnable,
    Iterator<T> {
        private static final long serialVersionUID = 6695226475494099826L;
        final SpscArrayQueue<T> queue;
        final long batchSize;
        final long limit;
        final Lock lock;
        final Condition condition;
        long produced;
        volatile boolean done;
        volatile Throwable error;

        BlockingFlowableIterator(int batchSize) {
            this.queue = new SpscArrayQueue(batchSize);
            this.batchSize = batchSize;
            this.limit = batchSize - (batchSize >> 2);
            this.lock = new ReentrantLock();
            this.condition = this.lock.newCondition();
        }

        @Override
        public boolean hasNext() {
            block5: while (true) {
                if (this.isDisposed()) {
                    Throwable e2 = this.error;
                    if (e2 != null) {
                        throw ExceptionHelper.r(e2);
                    }
                    return false;
                }
                boolean d2 = this.done;
                boolean empty = this.queue.isEmpty();
                if (d2) {
                    Throwable e3 = this.error;
                    if (e3 != null) {
                        throw ExceptionHelper.r(e3);
                    }
                    if (empty) {
                        return false;
                    }
                }
                if (!empty) break;
                c.qC();
                this.lock.lock();
                try {
                    while (true) {
                        if (this.done || !this.queue.isEmpty() || this.isDisposed()) continue block5;
                        this.condition.await();
                    }
                }
                catch (InterruptedException ex) {
                    this.run();
                    throw ExceptionHelper.r(ex);
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
            return true;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T v2 = this.queue.poll();
                long p2 = this.produced + 1L;
                if (p2 == this.limit) {
                    this.produced = 0L;
                    ((e)this.get()).request(p2);
                } else {
                    this.produced = p2;
                }
                return v2;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void onSubscribe(e s2) {
            SubscriptionHelper.setOnce(this, s2, this.batchSize);
        }

        @Override
        public void onNext(T t2) {
            if (!this.queue.offer(t2)) {
                SubscriptionHelper.cancel(this);
                this.onError(new QueueOverflowException());
            } else {
                this.signalConsumer();
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.error = t2;
            this.done = true;
            this.signalConsumer();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.signalConsumer();
        }

        void signalConsumer() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void run() {
            SubscriptionHelper.cancel(this);
            this.signalConsumer();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public void dispose() {
            SubscriptionHelper.cancel(this);
            this.signalConsumer();
        }

        @Override
        public boolean isDisposed() {
            return this.get() == SubscriptionHelper.CANCELLED;
        }
    }
}

