/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.e;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.internal.util.n;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.a.d;

public final class FlowableBuffer<T, C extends Collection<? super T>>
extends io.reactivex.rxjava3.internal.operators.flowable.a<T, C> {
    final int RB;
    final int RD;
    final s<C> RE;

    public FlowableBuffer(j<T> source, int size, int skip, s<C> bufferSupplier) {
        super(source);
        this.RB = size;
        this.RD = skip;
        this.RE = bufferSupplier;
    }

    @Override
    public void d(d<? super C> s2) {
        if (this.RB == this.RD) {
            this.QR.a(new a(s2, this.RB, this.RE));
        } else if (this.RD > this.RB) {
            this.QR.a(new PublisherBufferSkipSubscriber(s2, this.RB, this.RD, this.RE));
        } else {
            this.QR.a(new PublisherBufferOverlappingSubscriber(s2, this.RB, this.RD, this.RE));
        }
    }

    static final class PublisherBufferOverlappingSubscriber<T, C extends Collection<? super T>>
    extends AtomicLong
    implements e,
    o<T>,
    org.a.e {
        private static final long serialVersionUID = -7370244972039324525L;
        final d<? super C> downstream;
        final s<C> bufferSupplier;
        final int size;
        final int skip;
        final ArrayDeque<C> buffers;
        final AtomicBoolean once;
        org.a.e upstream;
        boolean done;
        int index;
        volatile boolean cancelled;
        long produced;

        PublisherBufferOverlappingSubscriber(d<? super C> actual, int size, int skip, s<C> bufferSupplier) {
            this.downstream = actual;
            this.size = size;
            this.skip = skip;
            this.bufferSupplier = bufferSupplier;
            this.once = new AtomicBoolean();
            this.buffers = new ArrayDeque();
        }

        @Override
        public boolean getAsBoolean() {
            return this.cancelled;
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                if (n.a(n2, this.downstream, this.buffers, this, this)) {
                    return;
                }
                if (!this.once.get() && this.once.compareAndSet(false, true)) {
                    long u2 = b.h(this.skip, n2 - 1L);
                    long r2 = b.g(this.size, u2);
                    this.upstream.request(r2);
                } else {
                    long r3 = b.h(this.skip, n2);
                    this.upstream.request(r3);
                }
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(org.a.e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            Collection b2;
            if (this.done) {
                return;
            }
            ArrayDeque<C> bs2 = this.buffers;
            int i2 = this.index;
            if (i2++ == 0) {
                try {
                    b2 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null buffer");
                }
                catch (Throwable e2) {
                    io.reactivex.rxjava3.exceptions.a.k(e2);
                    this.cancel();
                    this.onError(e2);
                    return;
                }
                bs2.offer(b2);
            }
            if ((b2 = (Collection)bs2.peek()).size() + 1 == this.size) {
                bs2.poll();
                b2.add(t2);
                ++this.produced;
                this.downstream.onNext(b2);
            }
            for (Collection b0 : bs2) {
                b0.add(t2);
            }
            if (i2 == this.skip) {
                i2 = 0;
            }
            this.index = i2;
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
                return;
            }
            this.done = true;
            this.buffers.clear();
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            long p2 = this.produced;
            if (p2 != 0L) {
                b.c(this, p2);
            }
            n.a(this.downstream, this.buffers, this, this);
        }
    }

    static final class PublisherBufferSkipSubscriber<T, C extends Collection<? super T>>
    extends AtomicInteger
    implements o<T>,
    org.a.e {
        private static final long serialVersionUID = -5616169793639412593L;
        final d<? super C> downstream;
        final s<C> bufferSupplier;
        final int size;
        final int skip;
        C buffer;
        org.a.e upstream;
        boolean done;
        int index;

        PublisherBufferSkipSubscriber(d<? super C> actual, int size, int skip, s<C> bufferSupplier) {
            this.downstream = actual;
            this.size = size;
            this.skip = skip;
            this.bufferSupplier = bufferSupplier;
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                if (this.get() == 0 && this.compareAndSet(0, 1)) {
                    long u2 = b.h(n2, this.size);
                    long v2 = b.h(this.skip - this.size, n2 - 1L);
                    this.upstream.request(b.g(u2, v2));
                } else {
                    this.upstream.request(b.h(this.skip, n2));
                }
            }
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(org.a.e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            Object b2 = this.buffer;
            int i2 = this.index;
            if (i2++ == 0) {
                try {
                    b2 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null buffer");
                }
                catch (Throwable e2) {
                    io.reactivex.rxjava3.exceptions.a.k(e2);
                    this.cancel();
                    this.onError(e2);
                    return;
                }
                this.buffer = b2;
            }
            if (b2 != null) {
                b2.add(t2);
                if (b2.size() == this.size) {
                    this.buffer = null;
                    this.downstream.onNext(b2);
                }
            }
            if (i2 == this.skip) {
                i2 = 0;
            }
            this.index = i2;
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
                return;
            }
            this.done = true;
            this.buffer = null;
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            C b2 = this.buffer;
            this.buffer = null;
            if (b2 != null) {
                this.downstream.onNext(b2);
            }
            this.downstream.onComplete();
        }
    }

    static final class a<T, C extends Collection<? super T>>
    implements o<T>,
    org.a.e {
        final d<? super C> RF;
        final s<C> RG;
        final int RH;
        C buffer;
        org.a.e upstream;
        boolean done;
        int index;

        a(d<? super C> actual, int size, s<C> bufferSupplier) {
            this.RF = actual;
            this.RH = size;
            this.RG = bufferSupplier;
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                this.upstream.request(b.h(n2, this.RH));
            }
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(org.a.e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.RF.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            Object b2 = this.buffer;
            if (b2 == null) {
                try {
                    b2 = (Collection)Objects.requireNonNull(this.RG.get(), "The bufferSupplier returned a null buffer");
                }
                catch (Throwable e2) {
                    io.reactivex.rxjava3.exceptions.a.k(e2);
                    this.cancel();
                    this.onError(e2);
                    return;
                }
                this.buffer = b2;
            }
            b2.add(t2);
            int i2 = this.index + 1;
            if (i2 == this.RH) {
                this.index = 0;
                this.buffer = null;
                this.RF.onNext(b2);
            } else {
                this.index = i2;
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
                return;
            }
            this.buffer = null;
            this.done = true;
            this.RF.onError(t2);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            C b2 = this.buffer;
            this.buffer = null;
            if (b2 != null) {
                this.RF.onNext(b2);
            }
            this.RF.onComplete();
        }
    }
}

