/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowableBufferBoundary<T, U extends Collection<? super T>, Open, Close>
extends a<T, U> {
    final s<U> RI;
    final c<? extends Open> RJ;
    final h<? super Open, ? extends c<? extends Close>> RK;

    public FlowableBufferBoundary(j<T> source, c<? extends Open> bufferOpen, h<? super Open, ? extends c<? extends Close>> bufferClose, s<U> bufferSupplier) {
        super(source);
        this.RJ = bufferOpen;
        this.RK = bufferClose;
        this.RI = bufferSupplier;
    }

    @Override
    protected void d(d<? super U> s2) {
        BufferBoundarySubscriber parent = new BufferBoundarySubscriber(s2, this.RJ, this.RK, this.RI);
        s2.onSubscribe(parent);
        this.QR.a(parent);
    }

    static final class BufferCloseSubscriber<T, C extends Collection<? super T>>
    extends AtomicReference<e>
    implements o<Object>,
    b {
        private static final long serialVersionUID = -8498650778633225126L;
        final BufferBoundarySubscriber<T, C, ?, ?> parent;
        final long index;

        BufferCloseSubscriber(BufferBoundarySubscriber<T, C, ?, ?> parent, long index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onSubscribe(e s2) {
            SubscriptionHelper.setOnce(this, s2, Long.MAX_VALUE);
        }

        @Override
        public void onNext(Object t2) {
            e s2 = (e)this.get();
            if (s2 != SubscriptionHelper.CANCELLED) {
                this.lazySet(SubscriptionHelper.CANCELLED);
                s2.cancel();
                this.parent.close(this, this.index);
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.get() != SubscriptionHelper.CANCELLED) {
                this.lazySet(SubscriptionHelper.CANCELLED);
                this.parent.boundaryError(this, t2);
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.get() != SubscriptionHelper.CANCELLED) {
                this.lazySet(SubscriptionHelper.CANCELLED);
                this.parent.close(this, this.index);
            }
        }

        @Override
        public void dispose() {
            SubscriptionHelper.cancel(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == SubscriptionHelper.CANCELLED;
        }
    }

    static final class BufferBoundarySubscriber<T, C extends Collection<? super T>, Open, Close>
    extends AtomicInteger
    implements o<T>,
    e {
        private static final long serialVersionUID = -8466418554264089604L;
        final d<? super C> downstream;
        final s<C> bufferSupplier;
        final c<? extends Open> bufferOpen;
        final h<? super Open, ? extends c<? extends Close>> bufferClose;
        final io.reactivex.rxjava3.disposables.a subscribers;
        final AtomicLong requested;
        final AtomicReference<e> upstream;
        final AtomicThrowable errors;
        volatile boolean done;
        final io.reactivex.rxjava3.operators.h<C> queue;
        volatile boolean cancelled;
        long index;
        Map<Long, C> buffers;
        long emitted;

        BufferBoundarySubscriber(d<? super C> actual, c<? extends Open> bufferOpen, h<? super Open, ? extends c<? extends Close>> bufferClose, s<C> bufferSupplier) {
            this.downstream = actual;
            this.bufferSupplier = bufferSupplier;
            this.bufferOpen = bufferOpen;
            this.bufferClose = bufferClose;
            this.queue = new io.reactivex.rxjava3.operators.h(j.mB());
            this.subscribers = new io.reactivex.rxjava3.disposables.a();
            this.requested = new AtomicLong();
            this.upstream = new AtomicReference();
            this.buffers = new LinkedHashMap<Long, C>();
            this.errors = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.setOnce(this.upstream, s2)) {
                BufferOpenSubscriber open = new BufferOpenSubscriber(this);
                this.subscribers.a((b)open);
                this.bufferOpen.subscribe(open);
                s2.request(Long.MAX_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t2) {
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                for (Collection b2 : bufs.values()) {
                    b2.add(t2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t2) {
            if (this.errors.tryAddThrowableOrReport(t2)) {
                this.subscribers.dispose();
                BufferBoundarySubscriber bufferBoundarySubscriber = this;
                synchronized (bufferBoundarySubscriber) {
                    this.buffers = null;
                }
                this.done = true;
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            this.subscribers.dispose();
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                for (Collection b2 : bufs.values()) {
                    this.queue.offer(b2);
                }
                this.buffers = null;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n2) {
            io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            if (SubscriptionHelper.cancel(this.upstream)) {
                this.cancelled = true;
                this.subscribers.dispose();
                BufferBoundarySubscriber bufferBoundarySubscriber = this;
                synchronized (bufferBoundarySubscriber) {
                    this.buffers = null;
                }
                if (this.getAndIncrement() != 0) {
                    this.queue.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open(Open token) {
            c<Close> p2;
            Collection buf;
            try {
                buf = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null Collection");
                p2 = Objects.requireNonNull(this.bufferClose.apply(token), "The bufferClose returned a null Publisher");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                SubscriptionHelper.cancel(this.upstream);
                this.onError(ex);
                return;
            }
            long idx = this.index;
            this.index = idx + 1L;
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                bufs.put(idx, buf);
            }
            BufferCloseSubscriber bc2 = new BufferCloseSubscriber(this, idx);
            this.subscribers.a((b)bc2);
            p2.subscribe(bc2);
        }

        void openComplete(BufferOpenSubscriber<Open> os) {
            this.subscribers.c(os);
            if (this.subscribers.size() == 0) {
                SubscriptionHelper.cancel(this.upstream);
                this.done = true;
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(BufferCloseSubscriber<T, C> closer, long idx) {
            this.subscribers.c(closer);
            boolean makeDone = false;
            if (this.subscribers.size() == 0) {
                makeDone = true;
                SubscriptionHelper.cancel(this.upstream);
            }
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                this.queue.offer(this.buffers.remove(idx));
            }
            if (makeDone) {
                this.done = true;
            }
            this.drain();
        }

        void boundaryError(b subscriber, Throwable ex) {
            SubscriptionHelper.cancel(this.upstream);
            this.subscribers.c(subscriber);
            this.onError(ex);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            long e2 = this.emitted;
            d<C> a2 = this.downstream;
            io.reactivex.rxjava3.operators.h<C> q2 = this.queue;
            do {
                long r2 = this.requested.get();
                while (e2 != r2) {
                    boolean empty;
                    if (this.cancelled) {
                        q2.clear();
                        return;
                    }
                    boolean d2 = this.done;
                    if (d2 && this.errors.get() != null) {
                        q2.clear();
                        this.errors.tryTerminateConsumer(a2);
                        return;
                    }
                    Collection v2 = (Collection)q2.poll();
                    boolean bl2 = empty = v2 == null;
                    if (d2 && empty) {
                        a2.onComplete();
                        return;
                    }
                    if (empty) break;
                    a2.onNext(v2);
                    ++e2;
                }
                if (e2 == r2) {
                    if (this.cancelled) {
                        q2.clear();
                        return;
                    }
                    if (this.done) {
                        if (this.errors.get() != null) {
                            q2.clear();
                            this.errors.tryTerminateConsumer(a2);
                            return;
                        }
                        if (q2.isEmpty()) {
                            a2.onComplete();
                            return;
                        }
                    }
                }
                this.emitted = e2;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        static final class BufferOpenSubscriber<Open>
        extends AtomicReference<e>
        implements o<Open>,
        b {
            private static final long serialVersionUID = -8498650778633225126L;
            final BufferBoundarySubscriber<?, ?, Open, ?> parent;

            BufferOpenSubscriber(BufferBoundarySubscriber<?, ?, Open, ?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(e s2) {
                SubscriptionHelper.setOnce(this, s2, Long.MAX_VALUE);
            }

            @Override
            public void onNext(Open t2) {
                this.parent.open(t2);
            }

            @Override
            public void onError(Throwable t2) {
                this.lazySet(SubscriptionHelper.CANCELLED);
                this.parent.boundaryError(this, t2);
            }

            @Override
            public void onComplete() {
                this.lazySet(SubscriptionHelper.CANCELLED);
                this.parent.openComplete(this);
            }

            @Override
            public void dispose() {
                SubscriptionHelper.cancel(this);
            }

            @Override
            public boolean isDisposed() {
                return this.get() == SubscriptionHelper.CANCELLED;
            }
        }
    }
}

