/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class FlowableCache<T>
extends io.reactivex.rxjava3.internal.operators.flowable.a<T, T>
implements o<T> {
    final AtomicBoolean Su;
    final int Sv;
    final AtomicReference<CacheSubscription<T>[]> Sw;
    static final CacheSubscription[] Sx = new CacheSubscription[0];
    static final CacheSubscription[] Sy = new CacheSubscription[0];
    volatile long size;
    final a<T> Sz;
    a<T> SA;
    int SB;
    Throwable error;
    volatile boolean done;

    public FlowableCache(j<T> source, int capacityHint) {
        super(source);
        this.Sv = capacityHint;
        this.Su = new AtomicBoolean();
        a n2 = new a(capacityHint);
        this.Sz = n2;
        this.SA = n2;
        this.Sw = new AtomicReference<CacheSubscription[]>(Sx);
    }

    @Override
    protected void d(d<? super T> t2) {
        CacheSubscription<? super T> consumer = new CacheSubscription<T>(t2, this);
        t2.onSubscribe(consumer);
        this.a(consumer);
        if (!this.Su.get() && this.Su.compareAndSet(false, true)) {
            this.QR.a(this);
        } else {
            this.c(consumer);
        }
    }

    boolean isConnected() {
        return this.Su.get();
    }

    boolean qc() {
        return this.Sw.get().length != 0;
    }

    long qd() {
        return this.size;
    }

    @Override
    void a(CacheSubscription<T> consumer) {
        CacheSubscription[] next;
        CacheSubscription<T>[] current;
        do {
            if ((current = this.Sw.get()) == Sy) {
                return;
            }
            int n2 = current.length;
            next = new CacheSubscription[n2 + 1];
            System.arraycopy(current, 0, next, 0, n2);
            next[n2] = consumer;
        } while (!this.Sw.compareAndSet(current, next));
    }

    void b(CacheSubscription<T> consumer) {
        CacheSubscription[] next;
        CacheSubscription<T>[] current;
        do {
            int n2;
            if ((n2 = (current = this.Sw.get()).length) == 0) {
                return;
            }
            int j2 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (current[i2] != consumer) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (n2 == 1) {
                next = Sx;
                continue;
            }
            next = new CacheSubscription[n2 - 1];
            System.arraycopy(current, 0, next, 0, j2);
            System.arraycopy(current, j2 + 1, next, j2, n2 - j2 - 1);
        } while (!this.Sw.compareAndSet(current, next));
    }

    @Override
    void c(CacheSubscription<T> consumer) {
        if (consumer.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        long index = consumer.index;
        int offset = consumer.offset;
        a node = consumer.node;
        AtomicLong requested = consumer.requested;
        d downstream = consumer.downstream;
        int capacity = this.Sv;
        while (true) {
            boolean empty;
            boolean sourceDone = this.done;
            boolean bl2 = empty = this.size == index;
            if (sourceDone && empty) {
                consumer.node = null;
                Throwable ex = this.error;
                if (ex != null) {
                    downstream.onError(ex);
                } else {
                    downstream.onComplete();
                }
                return;
            }
            if (!empty) {
                long consumerRequested = requested.get();
                if (consumerRequested == Long.MIN_VALUE) {
                    consumer.node = null;
                    return;
                }
                if (consumerRequested != index) {
                    if (offset == capacity) {
                        node = node.SC;
                        offset = 0;
                    }
                    downstream.onNext(node.values[offset]);
                    ++offset;
                    ++index;
                    continue;
                }
            }
            consumer.index = index;
            consumer.offset = offset;
            consumer.node = node;
            if ((missed = consumer.addAndGet(-missed)) == 0) break;
        }
    }

    @Override
    public void onSubscribe(e s2) {
        s2.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(T t2) {
        int tailOffset = this.SB;
        if (tailOffset == this.Sv) {
            a n2 = new a(tailOffset);
            n2.values[0] = t2;
            this.SB = 1;
            this.SA.SC = n2;
            this.SA = n2;
        } else {
            this.SA.values[tailOffset] = t2;
            this.SB = tailOffset + 1;
        }
        ++this.size;
        for (CacheSubscription<T> consumer : this.Sw.get()) {
            this.c(consumer);
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            io.reactivex.rxjava3.d.a.onError(t2);
            return;
        }
        this.error = t2;
        this.done = true;
        for (CacheSubscription consumer : this.Sw.getAndSet(Sy)) {
            this.c(consumer);
        }
    }

    @Override
    public void onComplete() {
        this.done = true;
        for (CacheSubscription consumer : this.Sw.getAndSet(Sy)) {
            this.c(consumer);
        }
    }

    static final class a<T> {
        final T[] values;
        volatile a<T> SC;

        a(int capacityHint) {
            this.values = new Object[capacityHint];
        }
    }

    static final class CacheSubscription<T>
    extends AtomicInteger
    implements e {
        private static final long serialVersionUID = 6770240836423125754L;
        final d<? super T> downstream;
        final FlowableCache<T> parent;
        final AtomicLong requested;
        a<T> node;
        int offset;
        long index;

        CacheSubscription(d<? super T> downstream, FlowableCache<T> parent) {
            this.downstream = downstream;
            this.parent = parent;
            this.node = parent.Sz;
            this.requested = new AtomicLong();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.b(this.requested, n2);
                this.parent.c(this);
            }
        }

        @Override
        public void cancel() {
            if (this.requested.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.b(this);
            }
        }
    }
}

