/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.internal.operators.flowable.at;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.d;

public final class FlowableCombineLatest<T, R>
extends j<R> {
    @f
    final c<? extends T>[] SL;
    @f
    final Iterable<? extends c<? extends T>> SM;
    final h<? super Object[], ? extends R> SO;
    final int SP;
    final boolean SQ;

    public FlowableCombineLatest(@e c<? extends T>[] array, @e h<? super Object[], ? extends R> combiner, int bufferSize, boolean delayErrors) {
        this.SL = array;
        this.SM = null;
        this.SO = combiner;
        this.SP = bufferSize;
        this.SQ = delayErrors;
    }

    public FlowableCombineLatest(@e Iterable<? extends c<? extends T>> iterable, @e h<? super Object[], ? extends R> combiner, int bufferSize, boolean delayErrors) {
        this.SL = null;
        this.SM = iterable;
        this.SO = combiner;
        this.SP = bufferSize;
        this.SQ = delayErrors;
    }

    @Override
    public void d(d<? super R> s2) {
        int count;
        c<? extends T>[] sources = this.SL;
        if (sources == null) {
            count = 0;
            sources = new c[8];
            try {
                for (c<? extends T> c2 : this.SM) {
                    if (count == sources.length) {
                        c[] b2 = new c[count + (count >> 2)];
                        System.arraycopy(sources, 0, b2, 0, count);
                        sources = b2;
                    }
                    sources[count++] = Objects.requireNonNull(c2, "The Iterator returned a null Publisher");
                }
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                EmptySubscription.error(ex, s2);
                return;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptySubscription.complete(s2);
            return;
        }
        if (count == 1) {
            sources[0].subscribe(new at.b(s2, new a()));
            return;
        }
        CombineLatestCoordinator<? extends T, R> coordinator = new CombineLatestCoordinator<T, R>(s2, this.SO, count, this.SP, this.SQ);
        s2.onSubscribe(coordinator);
        coordinator.subscribe(sources, count);
    }

    final class a
    implements h<T, R> {
        a() {
        }

        @Override
        public R apply(T t2) throws Throwable {
            return FlowableCombineLatest.this.SO.apply((Object[])new Object[]{t2});
        }
    }

    static final class CombineLatestInnerSubscriber<T>
    extends AtomicReference<org.a.e>
    implements o<T> {
        private static final long serialVersionUID = -8730235182291002949L;
        final CombineLatestCoordinator<T, ?> parent;
        final int index;
        final int prefetch;
        final int limit;
        int produced;

        CombineLatestInnerSubscriber(CombineLatestCoordinator<T, ?> parent, int index, int prefetch) {
            this.parent = parent;
            this.index = index;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public void onSubscribe(org.a.e s2) {
            SubscriptionHelper.setOnce(this, s2, this.prefetch);
        }

        @Override
        public void onNext(T t2) {
            this.parent.innerValue(this.index, t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.innerError(this.index, t2);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this.index);
        }

        public void cancel() {
            SubscriptionHelper.cancel(this);
        }

        public void requestOne() {
            int p2 = this.produced + 1;
            if (p2 == this.limit) {
                this.produced = 0;
                ((org.a.e)this.get()).request(p2);
            } else {
                this.produced = p2;
            }
        }
    }

    static final class CombineLatestCoordinator<T, R>
    extends BasicIntQueueSubscription<R> {
        private static final long serialVersionUID = -5082275438355852221L;
        final d<? super R> downstream;
        final h<? super Object[], ? extends R> combiner;
        final CombineLatestInnerSubscriber<T>[] subscribers;
        final io.reactivex.rxjava3.operators.h<Object> queue;
        final Object[] latest;
        final boolean delayErrors;
        boolean outputFused;
        int nonEmptySources;
        int completedSources;
        volatile boolean cancelled;
        final AtomicLong requested;
        volatile boolean done;
        final AtomicThrowable error;

        CombineLatestCoordinator(d<? super R> actual, h<? super Object[], ? extends R> combiner, int n2, int bufferSize, boolean delayErrors) {
            this.downstream = actual;
            this.combiner = combiner;
            CombineLatestInnerSubscriber[] a2 = new CombineLatestInnerSubscriber[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                a2[i2] = new CombineLatestInnerSubscriber(this, i2, bufferSize);
            }
            this.subscribers = a2;
            this.latest = new Object[n2];
            this.queue = new io.reactivex.rxjava3.operators.h(bufferSize);
            this.requested = new AtomicLong();
            this.error = new AtomicThrowable();
            this.delayErrors = delayErrors;
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.cancelAll();
            this.drain();
        }

        void subscribe(c<? extends T>[] sources, int n2) {
            CombineLatestInnerSubscriber<T>[] a2 = this.subscribers;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.done || this.cancelled) {
                    return;
                }
                sources[i2].subscribe(a2[i2]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerValue(int index, T value) {
            boolean replenishInsteadOfDrain;
            CombineLatestCoordinator combineLatestCoordinator = this;
            synchronized (combineLatestCoordinator) {
                Object[] os = this.latest;
                int localNonEmptySources = this.nonEmptySources;
                if (os[index] == null) {
                    this.nonEmptySources = ++localNonEmptySources;
                }
                os[index] = value;
                if (os.length == localNonEmptySources) {
                    this.queue.offer(this.subscribers[index], os.clone());
                    replenishInsteadOfDrain = false;
                } else {
                    replenishInsteadOfDrain = true;
                }
            }
            if (replenishInsteadOfDrain) {
                this.subscribers[index].requestOne();
            } else {
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void innerComplete(int index) {
            CombineLatestCoordinator combineLatestCoordinator = this;
            synchronized (combineLatestCoordinator) {
                Object[] os = this.latest;
                if (os[index] != null) {
                    int localCompletedSources = this.completedSources + 1;
                    if (localCompletedSources != os.length) {
                        this.completedSources = localCompletedSources;
                        return;
                    }
                    this.done = true;
                } else {
                    this.done = true;
                }
            }
            this.drain();
        }

        void innerError(int index, Throwable e2) {
            if (ExceptionHelper.a(this.error, e2)) {
                if (!this.delayErrors) {
                    this.cancelAll();
                    this.done = true;
                    this.drain();
                } else {
                    this.innerComplete(index);
                }
            } else {
                io.reactivex.rxjava3.d.a.onError(e2);
            }
        }

        void drainOutput() {
            d<R> a2 = this.downstream;
            io.reactivex.rxjava3.operators.h<Object> q2 = this.queue;
            int missed = 1;
            do {
                if (this.cancelled) {
                    q2.clear();
                    return;
                }
                Throwable ex = (Throwable)this.error.get();
                if (ex != null) {
                    q2.clear();
                    a2.onError(ex);
                    return;
                }
                boolean d2 = this.done;
                boolean empty = q2.isEmpty();
                if (!empty) {
                    a2.onNext(null);
                }
                if (!d2 || !empty) continue;
                a2.onComplete();
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        void drainAsync() {
            d<R> a2 = this.downstream;
            io.reactivex.rxjava3.operators.h<Object> q2 = this.queue;
            int missed = 1;
            do {
                long e2;
                long r2 = this.requested.get();
                for (e2 = 0L; e2 != r2; ++e2) {
                    R w2;
                    boolean empty;
                    boolean d2 = this.done;
                    Object v2 = q2.poll();
                    boolean bl2 = empty = v2 == null;
                    if (this.checkTerminated(d2, empty, a2, q2)) {
                        return;
                    }
                    if (empty) break;
                    Object[] va = (Object[])q2.poll();
                    try {
                        w2 = Objects.requireNonNull(this.combiner.apply((Object[])va), "The combiner returned a null value");
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        this.cancelAll();
                        ExceptionHelper.a(this.error, ex);
                        ex = ExceptionHelper.a(this.error);
                        a2.onError(ex);
                        return;
                    }
                    a2.onNext(w2);
                    ((CombineLatestInnerSubscriber)v2).requestOne();
                }
                if (e2 == r2 && this.checkTerminated(this.done, q2.isEmpty(), a2, q2)) {
                    return;
                }
                if (e2 == 0L || r2 == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-e2);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            if (this.outputFused) {
                this.drainOutput();
            } else {
                this.drainAsync();
            }
        }

        boolean checkTerminated(boolean d2, boolean empty, d<?> a2, io.reactivex.rxjava3.operators.h<?> q2) {
            if (this.cancelled) {
                this.cancelAll();
                q2.clear();
                this.error.tryTerminateAndReport();
                return true;
            }
            if (d2) {
                if (this.delayErrors) {
                    if (empty) {
                        this.cancelAll();
                        this.error.tryTerminateConsumer(a2);
                        return true;
                    }
                } else {
                    Throwable e2 = ExceptionHelper.a(this.error);
                    if (e2 != null && e2 != ExceptionHelper.azB) {
                        this.cancelAll();
                        q2.clear();
                        a2.onError(e2);
                        return true;
                    }
                    if (empty) {
                        this.cancelAll();
                        a2.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }

        void cancelAll() {
            for (CombineLatestInnerSubscriber<T> inner : this.subscribers) {
                inner.cancel();
            }
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 4) != 0) {
                return 0;
            }
            int m2 = requestedMode & 2;
            this.outputFused = m2 != 0;
            return m2;
        }

        @Override
        @f
        public R poll() throws Throwable {
            Object e2 = this.queue.poll();
            if (e2 == null) {
                return null;
            }
            Object[] a2 = (Object[])this.queue.poll();
            R r2 = Objects.requireNonNull(this.combiner.apply((Object[])a2), "The combiner returned a null value");
            ((CombineLatestInnerSubscriber)e2).requestOne();
            return r2;
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }
}

