/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionArbiter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowableConcatArray<T>
extends j<T> {
    final c<? extends T>[] SS;
    final boolean SU;

    public FlowableConcatArray(c<? extends T>[] sources, boolean delayError) {
        this.SS = sources;
        this.SU = delayError;
    }

    @Override
    protected void d(d<? super T> s2) {
        ConcatArraySubscriber<T> parent = new ConcatArraySubscriber<T>(this.SS, this.SU, s2);
        s2.onSubscribe(parent);
        parent.onComplete();
    }

    static final class ConcatArraySubscriber<T>
    extends SubscriptionArbiter
    implements o<T> {
        private static final long serialVersionUID = -8158322871608889516L;
        final d<? super T> downstream;
        final c<? extends T>[] sources;
        final boolean delayError;
        final AtomicInteger wip;
        int index;
        List<Throwable> errors;
        long produced;

        ConcatArraySubscriber(c<? extends T>[] sources, boolean delayError, d<? super T> downstream) {
            super(false);
            this.downstream = downstream;
            this.sources = sources;
            this.delayError = delayError;
            this.wip = new AtomicInteger();
        }

        @Override
        public void onSubscribe(e s2) {
            this.setSubscription(s2);
        }

        @Override
        public void onNext(T t2) {
            ++this.produced;
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            if (this.delayError) {
                List<Throwable> list = this.errors;
                if (list == null) {
                    this.errors = list = new ArrayList<Throwable>(this.sources.length - this.index + 1);
                }
                list.add(t2);
                this.onComplete();
            } else {
                this.downstream.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            block10: {
                if (this.wip.getAndIncrement() != 0) break block10;
                c<? extends T>[] sources = this.sources;
                int n2 = sources.length;
                int i2 = this.index;
                while (true) {
                    if (i2 == n2) {
                        List<Throwable> list = this.errors;
                        if (list != null) {
                            if (list.size() == 1) {
                                this.downstream.onError(list.get(0));
                            } else {
                                this.downstream.onError(new CompositeException(list));
                            }
                        } else {
                            this.downstream.onComplete();
                        }
                        return;
                    }
                    c<T> p2 = sources[i2];
                    if (p2 == null) {
                        NullPointerException ex = new NullPointerException("A Publisher entry is null");
                        if (this.delayError) {
                            List<Throwable> list = this.errors;
                            if (list == null) {
                                this.errors = list = new ArrayList<Throwable>(n2 - i2 + 1);
                            }
                            list.add(ex);
                            ++i2;
                            continue;
                        }
                        this.downstream.onError(ex);
                        return;
                    }
                    long r2 = this.produced;
                    if (r2 != 0L) {
                        this.produced = 0L;
                        this.produced(r2);
                    }
                    p2.subscribe(this);
                    this.index = ++i2;
                    if (this.wip.decrementAndGet() == 0) break;
                }
            }
        }
    }
}

