/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.operators.flowable.ba;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionArbiter;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.internal.util.g;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowableConcatMap<T, R>
extends io.reactivex.rxjava3.internal.operators.flowable.a<T, R> {
    final h<? super T, ? extends c<? extends R>> SV;
    final int SW;
    final ErrorMode SY;

    public FlowableConcatMap(j<T> source, h<? super T, ? extends c<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
        super(source);
        this.SV = mapper;
        this.SW = prefetch;
        this.SY = errorMode;
    }

    public static <T, R> d<T> a(d<? super R> s2, h<? super T, ? extends c<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
        switch (errorMode) {
            case BOUNDARY: {
                return new ConcatMapDelayed<T, R>(s2, mapper, prefetch, false);
            }
            case END: {
                return new ConcatMapDelayed<T, R>(s2, mapper, prefetch, true);
            }
        }
        return new ConcatMapImmediate<T, R>(s2, mapper, prefetch);
    }

    @Override
    protected void d(d<? super R> s2) {
        if (ba.a(this.QR, s2, this.SV)) {
            return;
        }
        this.QR.subscribe(FlowableConcatMap.a(s2, this.SV, this.SW, this.SY));
    }

    static final class ConcatMapInner<R>
    extends SubscriptionArbiter
    implements o<R> {
        private static final long serialVersionUID = 897683679971470653L;
        final a<R> parent;
        long produced;

        ConcatMapInner(a<R> parent) {
            super(false);
            this.parent = parent;
        }

        @Override
        public void onSubscribe(e s2) {
            this.setSubscription(s2);
        }

        @Override
        public void onNext(R t2) {
            ++this.produced;
            this.parent.innerNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            long p2 = this.produced;
            if (p2 != 0L) {
                this.produced = 0L;
                this.produced(p2);
            }
            this.parent.innerError(t2);
        }

        @Override
        public void onComplete() {
            long p2 = this.produced;
            if (p2 != 0L) {
                this.produced = 0L;
                this.produced(p2);
            }
            this.parent.innerComplete();
        }
    }

    static interface a<T> {
        public void innerNext(T var1);

        public void innerComplete();

        public void innerError(Throwable var1);
    }

    static final class ConcatMapDelayed<T, R>
    extends BaseConcatMapSubscriber<T, R> {
        private static final long serialVersionUID = -2945777694260521066L;
        final d<? super R> downstream;
        final boolean veryEnd;

        ConcatMapDelayed(d<? super R> actual, h<? super T, ? extends c<? extends R>> mapper, int prefetch, boolean veryEnd) {
            super(mapper, prefetch);
            this.downstream = actual;
            this.veryEnd = veryEnd;
        }

        @Override
        void subscribeActual() {
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onError(Throwable t2) {
            if (this.errors.tryAddThrowableOrReport(t2)) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void innerNext(R value) {
            this.downstream.onNext(value);
        }

        @Override
        public void innerError(Throwable e2) {
            if (this.errors.tryAddThrowableOrReport(e2)) {
                if (!this.veryEnd) {
                    this.upstream.cancel();
                    this.done = true;
                }
                this.active = false;
                this.drain();
            }
        }

        @Override
        public void request(long n2) {
            this.inner.request(n2);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.inner.cancel();
                this.upstream.cancel();
                this.errors.tryTerminateAndReport();
            }
        }

        @Override
        void drain() {
            block19: {
                if (this.getAndIncrement() != 0) break block19;
                while (true) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.active) {
                        boolean empty;
                        Object v2;
                        Throwable ex;
                        boolean d2 = this.done;
                        if (d2 && !this.veryEnd && (ex = (Throwable)this.errors.get()) != null) {
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        try {
                            v2 = this.queue.poll();
                        }
                        catch (Throwable e2) {
                            io.reactivex.rxjava3.exceptions.a.k(e2);
                            this.upstream.cancel();
                            this.errors.tryAddThrowableOrReport(e2);
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        boolean bl2 = empty = v2 == null;
                        if (d2 && empty) {
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        if (!empty) {
                            c p2;
                            try {
                                p2 = (c)Objects.requireNonNull(this.mapper.apply(v2), "The mapper returned a null Publisher");
                            }
                            catch (Throwable e3) {
                                io.reactivex.rxjava3.exceptions.a.k(e3);
                                this.upstream.cancel();
                                this.errors.tryAddThrowableOrReport(e3);
                                this.errors.tryTerminateConsumer(this.downstream);
                                return;
                            }
                            if (this.sourceMode != 1) {
                                int c2 = this.consumed + 1;
                                if (c2 == this.limit) {
                                    this.consumed = 0;
                                    this.upstream.request(c2);
                                } else {
                                    this.consumed = c2;
                                }
                            }
                            if (p2 instanceof s) {
                                Object vr;
                                s supplier = (s)((Object)p2);
                                try {
                                    vr = supplier.get();
                                }
                                catch (Throwable e4) {
                                    io.reactivex.rxjava3.exceptions.a.k(e4);
                                    this.errors.tryAddThrowableOrReport(e4);
                                    if (!this.veryEnd) {
                                        this.upstream.cancel();
                                        this.errors.tryTerminateConsumer(this.downstream);
                                        return;
                                    }
                                    vr = null;
                                }
                                if (vr == null) continue;
                                if (this.inner.isUnbounded()) {
                                    this.downstream.onNext(vr);
                                    continue;
                                }
                                this.active = true;
                                this.inner.setSubscription(new SimpleScalarSubscription(vr, this.inner));
                            } else {
                                this.active = true;
                                p2.subscribe(this.inner);
                            }
                        }
                    }
                    if (this.decrementAndGet() == 0) break;
                }
            }
        }
    }

    static final class SimpleScalarSubscription<T>
    extends AtomicBoolean
    implements e {
        private static final long serialVersionUID = -7606889335172043256L;
        final d<? super T> downstream;
        final T value;

        SimpleScalarSubscription(T value, d<? super T> downstream) {
            this.value = value;
            this.downstream = downstream;
        }

        @Override
        public void request(long n2) {
            if (n2 > 0L && this.compareAndSet(false, true)) {
                d<T> a2 = this.downstream;
                a2.onNext(this.value);
                a2.onComplete();
            }
        }

        @Override
        public void cancel() {
        }
    }

    static final class ConcatMapImmediate<T, R>
    extends BaseConcatMapSubscriber<T, R> {
        private static final long serialVersionUID = 7898995095634264146L;
        final d<? super R> downstream;
        final AtomicInteger wip;

        ConcatMapImmediate(d<? super R> actual, h<? super T, ? extends c<? extends R>> mapper, int prefetch) {
            super(mapper, prefetch);
            this.downstream = actual;
            this.wip = new AtomicInteger();
        }

        @Override
        void subscribeActual() {
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onError(Throwable t2) {
            this.inner.cancel();
            g.a(this.downstream, t2, (AtomicInteger)this, this.errors);
        }

        @Override
        public void innerNext(R value) {
            g.a(this.downstream, value, (AtomicInteger)this, this.errors);
        }

        @Override
        public void innerError(Throwable e2) {
            this.upstream.cancel();
            g.a(this.downstream, e2, (AtomicInteger)this, this.errors);
        }

        @Override
        public void request(long n2) {
            this.inner.request(n2);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.inner.cancel();
                this.upstream.cancel();
                this.errors.tryTerminateAndReport();
            }
        }

        @Override
        void drain() {
            block17: {
                if (this.wip.getAndIncrement() != 0) break block17;
                while (true) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.active) {
                        boolean empty;
                        Object v2;
                        boolean d2 = this.done;
                        try {
                            v2 = this.queue.poll();
                        }
                        catch (Throwable e2) {
                            io.reactivex.rxjava3.exceptions.a.k(e2);
                            this.upstream.cancel();
                            this.errors.tryAddThrowableOrReport(e2);
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        boolean bl2 = empty = v2 == null;
                        if (d2 && empty) {
                            this.downstream.onComplete();
                            return;
                        }
                        if (!empty) {
                            c p2;
                            try {
                                p2 = (c)Objects.requireNonNull(this.mapper.apply(v2), "The mapper returned a null Publisher");
                            }
                            catch (Throwable e3) {
                                io.reactivex.rxjava3.exceptions.a.k(e3);
                                this.upstream.cancel();
                                this.errors.tryAddThrowableOrReport(e3);
                                this.errors.tryTerminateConsumer(this.downstream);
                                return;
                            }
                            if (this.sourceMode != 1) {
                                int c2 = this.consumed + 1;
                                if (c2 == this.limit) {
                                    this.consumed = 0;
                                    this.upstream.request(c2);
                                } else {
                                    this.consumed = c2;
                                }
                            }
                            if (p2 instanceof s) {
                                Object vr;
                                s supplier = (s)((Object)p2);
                                try {
                                    vr = supplier.get();
                                }
                                catch (Throwable e4) {
                                    io.reactivex.rxjava3.exceptions.a.k(e4);
                                    this.upstream.cancel();
                                    this.errors.tryAddThrowableOrReport(e4);
                                    this.errors.tryTerminateConsumer(this.downstream);
                                    return;
                                }
                                if (vr == null) continue;
                                if (this.inner.isUnbounded()) {
                                    if (g.a(this.downstream, vr, (AtomicInteger)this, this.errors)) continue;
                                    return;
                                }
                                this.active = true;
                                this.inner.setSubscription(new SimpleScalarSubscription(vr, this.inner));
                            } else {
                                this.active = true;
                                p2.subscribe(this.inner);
                            }
                        }
                    }
                    if (this.wip.decrementAndGet() == 0) break;
                }
            }
        }
    }

    static abstract class BaseConcatMapSubscriber<T, R>
    extends AtomicInteger
    implements o<T>,
    a<R>,
    e {
        private static final long serialVersionUID = -3511336836796789179L;
        final ConcatMapInner<R> inner;
        final h<? super T, ? extends c<? extends R>> mapper;
        final int prefetch;
        final int limit;
        e upstream;
        int consumed;
        io.reactivex.rxjava3.operators.g<T> queue;
        volatile boolean done;
        volatile boolean cancelled;
        final AtomicThrowable errors;
        volatile boolean active;
        int sourceMode;

        BaseConcatMapSubscriber(h<? super T, ? extends c<? extends R>> mapper, int prefetch) {
            this.mapper = mapper;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.inner = new ConcatMapInner(this);
            this.errors = new AtomicThrowable();
        }

        @Override
        public final void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                if (s2 instanceof io.reactivex.rxjava3.operators.d) {
                    io.reactivex.rxjava3.operators.d f2 = (io.reactivex.rxjava3.operators.d)s2;
                    int m2 = f2.requestFusion(7);
                    if (m2 == 1) {
                        this.sourceMode = m2;
                        this.queue = f2;
                        this.done = true;
                        this.subscribeActual();
                        this.drain();
                        return;
                    }
                    if (m2 == 2) {
                        this.sourceMode = m2;
                        this.queue = f2;
                        this.subscribeActual();
                        s2.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                this.subscribeActual();
                s2.request(this.prefetch);
            }
        }

        abstract void drain();

        abstract void subscribeActual();

        @Override
        public final void onNext(T t2) {
            if (this.sourceMode != 2 && !this.queue.offer(t2)) {
                this.upstream.cancel();
                this.onError(new QueueOverflowException());
                return;
            }
            this.drain();
        }

        @Override
        public final void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public final void innerComplete() {
            this.active = false;
            this.drain();
        }
    }
}

