/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscribers.InnerQueuedSubscriber;
import io.reactivex.rxjava3.internal.subscribers.g;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.internal.util.b;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowableConcatMapEager<T, R>
extends a<T, R> {
    final h<? super T, ? extends c<? extends R>> Ta;
    final int Tb;
    final int Tc;
    final ErrorMode Td;

    public FlowableConcatMapEager(j<T> source, h<? super T, ? extends c<? extends R>> mapper, int maxConcurrency, int prefetch, ErrorMode errorMode) {
        super(source);
        this.Ta = mapper;
        this.Tb = maxConcurrency;
        this.Tc = prefetch;
        this.Td = errorMode;
    }

    @Override
    protected void d(d<? super R> s2) {
        this.QR.a(new ConcatMapEagerDelayErrorSubscriber<T, R>(s2, this.Ta, this.Tb, this.Tc, this.Td));
    }

    static final class ConcatMapEagerDelayErrorSubscriber<T, R>
    extends AtomicInteger
    implements o<T>,
    g<R>,
    e {
        private static final long serialVersionUID = -4255299542215038287L;
        final d<? super R> downstream;
        final h<? super T, ? extends c<? extends R>> mapper;
        final int maxConcurrency;
        final int prefetch;
        final ErrorMode errorMode;
        final AtomicThrowable errors;
        final AtomicLong requested;
        final io.reactivex.rxjava3.operators.h<InnerQueuedSubscriber<R>> subscribers;
        e upstream;
        volatile boolean cancelled;
        volatile boolean done;
        volatile InnerQueuedSubscriber<R> current;

        ConcatMapEagerDelayErrorSubscriber(d<? super R> actual, h<? super T, ? extends c<? extends R>> mapper, int maxConcurrency, int prefetch, ErrorMode errorMode) {
            this.downstream = actual;
            this.mapper = mapper;
            this.maxConcurrency = maxConcurrency;
            this.prefetch = prefetch;
            this.errorMode = errorMode;
            this.subscribers = new io.reactivex.rxjava3.operators.h(Math.min(prefetch, maxConcurrency));
            this.errors = new AtomicThrowable();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(this.maxConcurrency == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.maxConcurrency);
            }
        }

        @Override
        public void onNext(T t2) {
            c<R> p2;
            try {
                p2 = Objects.requireNonNull(this.mapper.apply(t2), "The mapper returned a null Publisher");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.cancel();
                this.onError(ex);
                return;
            }
            InnerQueuedSubscriber inner = new InnerQueuedSubscriber(this, this.prefetch);
            if (this.cancelled) {
                return;
            }
            this.subscribers.offer(inner);
            p2.subscribe(inner);
            if (this.cancelled) {
                inner.cancel();
                this.drainAndCancel();
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.errors.tryAddThrowableOrReport(t2)) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.upstream.cancel();
            this.errors.tryTerminateAndReport();
            this.drainAndCancel();
        }

        void drainAndCancel() {
            if (this.getAndIncrement() == 0) {
                do {
                    this.cancelAll();
                } while (this.decrementAndGet() != 0);
            }
        }

        void cancelAll() {
            InnerQueuedSubscriber<R> inner = this.current;
            this.current = null;
            if (inner != null) {
                inner.cancel();
            }
            while ((inner = this.subscribers.poll()) != null) {
                inner.cancel();
            }
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
                this.drain();
            }
        }

        @Override
        public void innerNext(InnerQueuedSubscriber<R> inner, R value) {
            if (inner.queue().offer(value)) {
                this.drain();
            } else {
                inner.cancel();
                this.innerError(inner, (Throwable)MissingBackpressureException.createDefault());
            }
        }

        @Override
        public void innerError(InnerQueuedSubscriber<R> inner, Throwable e2) {
            if (this.errors.tryAddThrowableOrReport(e2)) {
                inner.setDone();
                if (this.errorMode != ErrorMode.END) {
                    this.upstream.cancel();
                }
                this.drain();
            }
        }

        @Override
        public void innerComplete(InnerQueuedSubscriber<R> inner) {
            inner.setDone();
            this.drain();
        }

        @Override
        public void drain() {
            boolean continueNextSource;
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            InnerQueuedSubscriber<R> inner = this.current;
            d<R> a2 = this.downstream;
            ErrorMode em = this.errorMode;
            do {
                io.reactivex.rxjava3.operators.g<R> q2;
                long r2 = this.requested.get();
                long e2 = 0L;
                if (inner == null) {
                    Throwable ex;
                    if (em != ErrorMode.END && (ex = (Throwable)this.errors.get()) != null) {
                        this.cancelAll();
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    boolean outerDone = this.done;
                    inner = this.subscribers.poll();
                    if (outerDone && inner == null) {
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    if (inner != null) {
                        this.current = inner;
                    }
                }
                continueNextSource = false;
                if (inner != null && (q2 = inner.queue()) != null) {
                    boolean d2;
                    while (e2 != r2) {
                        boolean empty;
                        R v2;
                        Throwable ex;
                        if (this.cancelled) {
                            this.cancelAll();
                            return;
                        }
                        if (em == ErrorMode.IMMEDIATE && (ex = (Throwable)this.errors.get()) != null) {
                            this.current = null;
                            inner.cancel();
                            this.cancelAll();
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        d2 = inner.isDone();
                        try {
                            v2 = q2.poll();
                        }
                        catch (Throwable ex2) {
                            io.reactivex.rxjava3.exceptions.a.k(ex2);
                            this.current = null;
                            inner.cancel();
                            this.cancelAll();
                            a2.onError(ex2);
                            return;
                        }
                        boolean bl2 = empty = v2 == null;
                        if (d2 && empty) {
                            inner = null;
                            this.current = null;
                            this.upstream.request(1L);
                            continueNextSource = true;
                            break;
                        }
                        if (empty) break;
                        a2.onNext(v2);
                        ++e2;
                        inner.request(1L);
                    }
                    if (e2 == r2) {
                        Throwable ex;
                        if (this.cancelled) {
                            this.cancelAll();
                            return;
                        }
                        if (em == ErrorMode.IMMEDIATE && (ex = (Throwable)this.errors.get()) != null) {
                            this.current = null;
                            inner.cancel();
                            this.cancelAll();
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        d2 = inner.isDone();
                        boolean empty = q2.isEmpty();
                        if (d2 && empty) {
                            inner = null;
                            this.current = null;
                            this.upstream.request(1L);
                            continueNextSource = true;
                        }
                    }
                }
                if (e2 == 0L || r2 == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-e2);
            } while (continueNextSource || (missed = this.addAndGet(-missed)) != 0);
        }
    }
}

