/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableConcatMap;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.g;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowableConcatMapScheduler<T, R>
extends a<T, R> {
    final h<? super T, ? extends c<? extends R>> Tj;
    final int Tk;
    final ErrorMode Tl;
    final ah Tm;

    public FlowableConcatMapScheduler(j<T> source, h<? super T, ? extends c<? extends R>> mapper, int prefetch, ErrorMode errorMode, ah scheduler) {
        super(source);
        this.Tj = mapper;
        this.Tk = prefetch;
        this.Tl = errorMode;
        this.Tm = scheduler;
    }

    @Override
    protected void d(d<? super R> s2) {
        switch (this.Tl) {
            case BOUNDARY: {
                this.QR.a(new ConcatMapDelayed<T, R>(s2, this.Tj, this.Tk, false, this.Tm.oS()));
                break;
            }
            case END: {
                this.QR.a(new ConcatMapDelayed<T, R>(s2, this.Tj, this.Tk, true, this.Tm.oS()));
                break;
            }
            default: {
                this.QR.a(new ConcatMapImmediate<T, R>(s2, this.Tj, this.Tk, this.Tm.oS()));
            }
        }
    }

    static final class ConcatMapDelayed<T, R>
    extends BaseConcatMapSubscriber<T, R> {
        private static final long serialVersionUID = -2945777694260521066L;
        final d<? super R> downstream;
        final boolean veryEnd;

        ConcatMapDelayed(d<? super R> actual, h<? super T, ? extends c<? extends R>> mapper, int prefetch, boolean veryEnd, ah.c worker) {
            super(mapper, prefetch, worker);
            this.downstream = actual;
            this.veryEnd = veryEnd;
        }

        @Override
        void subscribeActual() {
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onError(Throwable t2) {
            if (this.errors.tryAddThrowableOrReport(t2)) {
                this.done = true;
                this.schedule();
            }
        }

        @Override
        public void innerNext(R value) {
            this.downstream.onNext(value);
        }

        @Override
        public void innerError(Throwable e2) {
            if (this.errors.tryAddThrowableOrReport(e2)) {
                if (!this.veryEnd) {
                    this.upstream.cancel();
                    this.done = true;
                }
                this.active = false;
                this.schedule();
            }
        }

        @Override
        public void request(long n2) {
            this.inner.request(n2);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.inner.cancel();
                this.upstream.cancel();
                this.worker.dispose();
                this.errors.tryTerminateAndReport();
            }
        }

        @Override
        void schedule() {
            if (this.getAndIncrement() == 0) {
                this.worker.f(this);
            }
        }

        @Override
        public void run() {
            while (true) {
                if (this.cancelled) {
                    return;
                }
                if (!this.active) {
                    boolean empty;
                    Object v2;
                    Throwable ex;
                    boolean d2 = this.done;
                    if (d2 && !this.veryEnd && (ex = (Throwable)this.errors.get()) != null) {
                        this.errors.tryTerminateConsumer(this.downstream);
                        this.worker.dispose();
                        return;
                    }
                    try {
                        v2 = this.queue.poll();
                    }
                    catch (Throwable e2) {
                        io.reactivex.rxjava3.exceptions.a.k(e2);
                        this.upstream.cancel();
                        this.errors.tryAddThrowableOrReport(e2);
                        this.errors.tryTerminateConsumer(this.downstream);
                        this.worker.dispose();
                        return;
                    }
                    boolean bl2 = empty = v2 == null;
                    if (d2 && empty) {
                        this.errors.tryTerminateConsumer(this.downstream);
                        this.worker.dispose();
                        return;
                    }
                    if (!empty) {
                        c p2;
                        try {
                            p2 = (c)Objects.requireNonNull(this.mapper.apply(v2), "The mapper returned a null Publisher");
                        }
                        catch (Throwable e3) {
                            io.reactivex.rxjava3.exceptions.a.k(e3);
                            this.upstream.cancel();
                            this.errors.tryAddThrowableOrReport(e3);
                            this.errors.tryTerminateConsumer(this.downstream);
                            this.worker.dispose();
                            return;
                        }
                        if (this.sourceMode != 1) {
                            int c2 = this.consumed + 1;
                            if (c2 == this.limit) {
                                this.consumed = 0;
                                this.upstream.request(c2);
                            } else {
                                this.consumed = c2;
                            }
                        }
                        if (p2 instanceof s) {
                            Object vr;
                            s supplier = (s)((Object)p2);
                            try {
                                vr = supplier.get();
                            }
                            catch (Throwable e4) {
                                io.reactivex.rxjava3.exceptions.a.k(e4);
                                this.errors.tryAddThrowableOrReport(e4);
                                if (!this.veryEnd) {
                                    this.upstream.cancel();
                                    this.errors.tryTerminateConsumer(this.downstream);
                                    this.worker.dispose();
                                    return;
                                }
                                vr = null;
                            }
                            if (vr == null || this.cancelled) continue;
                            if (this.inner.isUnbounded()) {
                                this.downstream.onNext(vr);
                                continue;
                            }
                            this.active = true;
                            this.inner.setSubscription(new FlowableConcatMap.SimpleScalarSubscription(vr, this.inner));
                        } else {
                            this.active = true;
                            p2.subscribe(this.inner);
                        }
                    }
                }
                if (this.decrementAndGet() == 0) break;
            }
        }
    }

    static final class ConcatMapImmediate<T, R>
    extends BaseConcatMapSubscriber<T, R> {
        private static final long serialVersionUID = 7898995095634264146L;
        final d<? super R> downstream;
        final AtomicInteger wip;

        ConcatMapImmediate(d<? super R> actual, h<? super T, ? extends c<? extends R>> mapper, int prefetch, ah.c worker) {
            super(mapper, prefetch, worker);
            this.downstream = actual;
            this.wip = new AtomicInteger();
        }

        @Override
        void subscribeActual() {
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onError(Throwable t2) {
            if (this.errors.tryAddThrowableOrReport(t2)) {
                this.inner.cancel();
                if (this.getAndIncrement() == 0) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    this.worker.dispose();
                }
            }
        }

        boolean tryEnter() {
            return this.get() == 0 && this.compareAndSet(0, 1);
        }

        @Override
        public void innerNext(R value) {
            if (this.tryEnter()) {
                this.downstream.onNext(value);
                if (this.compareAndSet(1, 0)) {
                    return;
                }
                this.errors.tryTerminateConsumer(this.downstream);
                this.worker.dispose();
            }
        }

        @Override
        public void innerError(Throwable e2) {
            if (this.errors.tryAddThrowableOrReport(e2)) {
                this.upstream.cancel();
                if (this.getAndIncrement() == 0) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    this.worker.dispose();
                }
            }
        }

        @Override
        public void request(long n2) {
            this.inner.request(n2);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.inner.cancel();
                this.upstream.cancel();
                this.worker.dispose();
                this.errors.tryTerminateAndReport();
            }
        }

        @Override
        void schedule() {
            if (this.wip.getAndIncrement() == 0) {
                this.worker.f(this);
            }
        }

        @Override
        public void run() {
            while (true) {
                if (this.cancelled) {
                    return;
                }
                if (!this.active) {
                    boolean empty;
                    Object v2;
                    boolean d2 = this.done;
                    try {
                        v2 = this.queue.poll();
                    }
                    catch (Throwable e2) {
                        io.reactivex.rxjava3.exceptions.a.k(e2);
                        this.upstream.cancel();
                        this.errors.tryAddThrowableOrReport(e2);
                        this.errors.tryTerminateConsumer(this.downstream);
                        this.worker.dispose();
                        return;
                    }
                    boolean bl2 = empty = v2 == null;
                    if (d2 && empty) {
                        this.downstream.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    if (!empty) {
                        c p2;
                        try {
                            p2 = (c)Objects.requireNonNull(this.mapper.apply(v2), "The mapper returned a null Publisher");
                        }
                        catch (Throwable e3) {
                            io.reactivex.rxjava3.exceptions.a.k(e3);
                            this.upstream.cancel();
                            this.errors.tryAddThrowableOrReport(e3);
                            this.errors.tryTerminateConsumer(this.downstream);
                            this.worker.dispose();
                            return;
                        }
                        if (this.sourceMode != 1) {
                            int c2 = this.consumed + 1;
                            if (c2 == this.limit) {
                                this.consumed = 0;
                                this.upstream.request(c2);
                            } else {
                                this.consumed = c2;
                            }
                        }
                        if (p2 instanceof s) {
                            Object vr;
                            s supplier = (s)((Object)p2);
                            try {
                                vr = supplier.get();
                            }
                            catch (Throwable e4) {
                                io.reactivex.rxjava3.exceptions.a.k(e4);
                                this.upstream.cancel();
                                this.errors.tryAddThrowableOrReport(e4);
                                this.errors.tryTerminateConsumer(this.downstream);
                                this.worker.dispose();
                                return;
                            }
                            if (vr == null || this.cancelled) continue;
                            if (this.inner.isUnbounded()) {
                                if (!this.tryEnter()) continue;
                                this.downstream.onNext(vr);
                                if (this.compareAndSet(1, 0)) continue;
                                this.errors.tryTerminateConsumer(this.downstream);
                                this.worker.dispose();
                                return;
                            }
                            this.active = true;
                            this.inner.setSubscription(new FlowableConcatMap.SimpleScalarSubscription(vr, this.inner));
                        } else {
                            this.active = true;
                            p2.subscribe(this.inner);
                        }
                    }
                }
                if (this.wip.decrementAndGet() == 0) break;
            }
        }
    }

    static abstract class BaseConcatMapSubscriber<T, R>
    extends AtomicInteger
    implements o<T>,
    FlowableConcatMap.a<R>,
    Runnable,
    e {
        private static final long serialVersionUID = -3511336836796789179L;
        final FlowableConcatMap.ConcatMapInner<R> inner;
        final h<? super T, ? extends c<? extends R>> mapper;
        final int prefetch;
        final int limit;
        final ah.c worker;
        e upstream;
        int consumed;
        g<T> queue;
        volatile boolean done;
        volatile boolean cancelled;
        final AtomicThrowable errors;
        volatile boolean active;
        int sourceMode;

        BaseConcatMapSubscriber(h<? super T, ? extends c<? extends R>> mapper, int prefetch, ah.c worker) {
            this.mapper = mapper;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.inner = new FlowableConcatMap.ConcatMapInner(this);
            this.errors = new AtomicThrowable();
            this.worker = worker;
        }

        @Override
        public final void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                if (s2 instanceof io.reactivex.rxjava3.operators.d) {
                    io.reactivex.rxjava3.operators.d f2 = (io.reactivex.rxjava3.operators.d)s2;
                    int m2 = f2.requestFusion(7);
                    if (m2 == 1) {
                        this.sourceMode = m2;
                        this.queue = f2;
                        this.done = true;
                        this.subscribeActual();
                        this.schedule();
                        return;
                    }
                    if (m2 == 2) {
                        this.sourceMode = m2;
                        this.queue = f2;
                        this.subscribeActual();
                        s2.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                this.subscribeActual();
                s2.request(this.prefetch);
            }
        }

        abstract void schedule();

        abstract void subscribeActual();

        @Override
        public final void onNext(T t2) {
            if (this.sourceMode != 2 && !this.queue.offer(t2)) {
                this.upstream.cancel();
                this.onError(new QueueOverflowException());
                return;
            }
            this.schedule();
        }

        @Override
        public final void onComplete() {
            this.done = true;
            this.schedule();
        }

        @Override
        public final void innerComplete() {
            this.active = false;
            this.schedule();
        }
    }
}

