/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.f;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.l;
import io.reactivex.rxjava3.core.m;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.disposables.CancellableDisposable;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.h;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class FlowableCreate<T>
extends j<T> {
    final m<T> Tr;
    final BackpressureStrategy Ts;

    public FlowableCreate(m<T> source, BackpressureStrategy backpressure) {
        this.Tr = source;
        this.Ts = backpressure;
    }

    @Override
    public void d(d<? super T> t2) {
        BaseEmitter emitter;
        switch (this.Ts) {
            case MISSING: {
                emitter = new MissingEmitter<T>(t2);
                break;
            }
            case ERROR: {
                emitter = new ErrorAsyncEmitter<T>(t2);
                break;
            }
            case DROP: {
                emitter = new DropAsyncEmitter<T>(t2);
                break;
            }
            case LATEST: {
                emitter = new LatestAsyncEmitter<T>(t2);
                break;
            }
            default: {
                emitter = new BufferAsyncEmitter<T>(t2, FlowableCreate.mB());
            }
        }
        t2.onSubscribe(emitter);
        try {
            this.Tr.a(emitter);
        }
        catch (Throwable ex) {
            a.k(ex);
            emitter.onError(ex);
        }
    }

    static final class LatestAsyncEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 4023437720691792495L;
        final AtomicReference<T> queue = new AtomicReference();
        Throwable error;
        volatile boolean done;
        final AtomicInteger wip = new AtomicInteger();

        LatestAsyncEmitter(d<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onNext(T t2) {
            if (this.done || this.isCancelled()) {
                return;
            }
            if (t2 == null) {
                this.onError(ExceptionHelper.de("onNext called with a null value."));
                return;
            }
            this.queue.set(t2);
            this.drain();
        }

        @Override
        public boolean signalError(Throwable e2) {
            if (this.done || this.isCancelled()) {
                return false;
            }
            this.error = e2;
            this.done = true;
            this.drain();
            return true;
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequested() {
            this.drain();
        }

        @Override
        void onUnsubscribed() {
            if (this.wip.getAndIncrement() == 0) {
                this.queue.lazySet(null);
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            d a2 = this.downstream;
            AtomicReference<T> q2 = this.queue;
            do {
                boolean d2;
                long e2;
                long r2 = this.get();
                for (e2 = 0L; e2 != r2; ++e2) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q2.lazySet(null);
                        return;
                    }
                    d2 = this.done;
                    Object o2 = q2.getAndSet(null);
                    boolean bl2 = empty = o2 == null;
                    if (d2 && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.errorDownstream(ex);
                        } else {
                            this.completeDownstream();
                        }
                        return;
                    }
                    if (empty) break;
                    a2.onNext(o2);
                }
                if (e2 == r2) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q2.lazySet(null);
                        return;
                    }
                    d2 = this.done;
                    boolean bl3 = empty = q2.get() == null;
                    if (d2 && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.errorDownstream(ex);
                        } else {
                            this.completeDownstream();
                        }
                        return;
                    }
                }
                if (e2 == 0L) continue;
                io.reactivex.rxjava3.internal.util.b.c(this, e2);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }
    }

    static final class BufferAsyncEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 2427151001689639875L;
        final h<T> queue;
        Throwable error;
        volatile boolean done;
        final AtomicInteger wip;

        BufferAsyncEmitter(d<? super T> actual, int capacityHint) {
            super(actual);
            this.queue = new h(capacityHint);
            this.wip = new AtomicInteger();
        }

        @Override
        public void onNext(T t2) {
            if (this.done || this.isCancelled()) {
                return;
            }
            if (t2 == null) {
                this.onError(ExceptionHelper.de("onNext called with a null value."));
                return;
            }
            this.queue.offer(t2);
            this.drain();
        }

        @Override
        public boolean signalError(Throwable e2) {
            if (this.done || this.isCancelled()) {
                return false;
            }
            this.error = e2;
            this.done = true;
            this.drain();
            return true;
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequested() {
            this.drain();
        }

        @Override
        void onUnsubscribed() {
            if (this.wip.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            d a2 = this.downstream;
            h<T> q2 = this.queue;
            do {
                boolean d2;
                long e2;
                long r2 = this.get();
                for (e2 = 0L; e2 != r2; ++e2) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q2.clear();
                        return;
                    }
                    d2 = this.done;
                    T o2 = q2.poll();
                    boolean bl2 = empty = o2 == null;
                    if (d2 && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.errorDownstream(ex);
                        } else {
                            this.completeDownstream();
                        }
                        return;
                    }
                    if (empty) break;
                    a2.onNext(o2);
                }
                if (e2 == r2) {
                    if (this.isCancelled()) {
                        q2.clear();
                        return;
                    }
                    d2 = this.done;
                    boolean empty = q2.isEmpty();
                    if (d2 && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.errorDownstream(ex);
                        } else {
                            this.completeDownstream();
                        }
                        return;
                    }
                }
                if (e2 == 0L) continue;
                io.reactivex.rxjava3.internal.util.b.c(this, e2);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }
    }

    static final class ErrorAsyncEmitter<T>
    extends NoOverflowBaseAsyncEmitter<T> {
        private static final long serialVersionUID = 338953216916120960L;

        ErrorAsyncEmitter(d<? super T> downstream) {
            super(downstream);
        }

        @Override
        void onOverflow() {
            this.onError(new MissingBackpressureException("create: Could not emit value due to lack of requests"));
        }
    }

    static final class DropAsyncEmitter<T>
    extends NoOverflowBaseAsyncEmitter<T> {
        private static final long serialVersionUID = 8360058422307496563L;

        DropAsyncEmitter(d<? super T> downstream) {
            super(downstream);
        }

        @Override
        void onOverflow() {
        }
    }

    static abstract class NoOverflowBaseAsyncEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 4127754106204442833L;

        NoOverflowBaseAsyncEmitter(d<? super T> downstream) {
            super(downstream);
        }

        @Override
        public final void onNext(T t2) {
            if (this.isCancelled()) {
                return;
            }
            if (t2 == null) {
                this.onError(ExceptionHelper.de("onNext called with a null value."));
                return;
            }
            if (this.get() != 0L) {
                this.downstream.onNext(t2);
                io.reactivex.rxjava3.internal.util.b.c(this, 1L);
            } else {
                this.onOverflow();
            }
        }

        abstract void onOverflow();
    }

    static final class MissingEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 3776720187248809713L;

        MissingEmitter(d<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onNext(T t2) {
            long r2;
            if (this.isCancelled()) {
                return;
            }
            if (t2 != null) {
                this.downstream.onNext(t2);
            } else {
                this.onError(ExceptionHelper.de("onNext called with a null value."));
                return;
            }
            while ((r2 = this.get()) != 0L && !this.compareAndSet(r2, r2 - 1L)) {
            }
        }
    }

    static abstract class BaseEmitter<T>
    extends AtomicLong
    implements l<T>,
    e {
        private static final long serialVersionUID = 7326289992464377023L;
        final d<? super T> downstream;
        final SequentialDisposable serial;

        BaseEmitter(d<? super T> downstream) {
            this.downstream = downstream;
            this.serial = new SequentialDisposable();
        }

        @Override
        public void onComplete() {
            this.completeDownstream();
        }

        protected void completeDownstream() {
            if (this.isCancelled()) {
                return;
            }
            try {
                this.downstream.onComplete();
            }
            finally {
                this.serial.dispose();
            }
        }

        @Override
        public final void onError(Throwable e2) {
            if (e2 == null) {
                e2 = ExceptionHelper.de("onError called with a null Throwable.");
            }
            if (!this.signalError(e2)) {
                io.reactivex.rxjava3.d.a.onError(e2);
            }
        }

        @Override
        public final boolean tryOnError(Throwable e2) {
            if (e2 == null) {
                e2 = ExceptionHelper.de("tryOnError called with a null Throwable.");
            }
            return this.signalError(e2);
        }

        public boolean signalError(Throwable e2) {
            return this.errorDownstream(e2);
        }

        protected boolean errorDownstream(Throwable e2) {
            if (this.isCancelled()) {
                return false;
            }
            try {
                this.downstream.onError(e2);
            }
            finally {
                this.serial.dispose();
            }
            return true;
        }

        @Override
        public final void cancel() {
            this.serial.dispose();
            this.onUnsubscribed();
        }

        void onUnsubscribed() {
        }

        @Override
        public final boolean isCancelled() {
            return this.serial.isDisposed();
        }

        @Override
        public final void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this, n2);
                this.onRequested();
            }
        }

        void onRequested() {
        }

        @Override
        public final void setDisposable(b d2) {
            this.serial.update(d2);
        }

        @Override
        public final void setCancellable(f c2) {
            this.setDisposable(new CancellableDisposable(c2));
        }

        @Override
        public final long requested() {
            return this.get();
        }

        @Override
        public final l<T> serialize() {
            return new SerializedEmitter(this);
        }

        @Override
        public String toString() {
            return String.format("%s{%s}", this.getClass().getSimpleName(), super.toString());
        }
    }

    static final class SerializedEmitter<T>
    extends AtomicInteger
    implements l<T> {
        private static final long serialVersionUID = 4883307006032401862L;
        final BaseEmitter<T> emitter;
        final AtomicThrowable errors;
        final io.reactivex.rxjava3.operators.f<T> queue;
        volatile boolean done;

        SerializedEmitter(BaseEmitter<T> emitter) {
            this.emitter = emitter;
            this.errors = new AtomicThrowable();
            this.queue = new h(16);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t2) {
            if (this.emitter.isCancelled() || this.done) {
                return;
            }
            if (t2 == null) {
                this.onError(ExceptionHelper.de("onNext called with a null value."));
                return;
            }
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.emitter.onNext(t2);
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                io.reactivex.rxjava3.operators.f<T> q2;
                io.reactivex.rxjava3.operators.f<T> f2 = q2 = this.queue;
                synchronized (f2) {
                    q2.offer(t2);
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t2) {
            if (!this.tryOnError(t2)) {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public boolean tryOnError(Throwable t2) {
            if (this.emitter.isCancelled() || this.done) {
                return false;
            }
            if (t2 == null) {
                t2 = ExceptionHelper.de("onError called with a null Throwable.");
            }
            if (this.errors.tryAddThrowable(t2)) {
                this.done = true;
                this.drain();
                return true;
            }
            return false;
        }

        @Override
        public void onComplete() {
            if (this.emitter.isCancelled() || this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            BaseEmitter<T> e2 = this.emitter;
            io.reactivex.rxjava3.operators.f<T> q2 = this.queue;
            AtomicThrowable errors = this.errors;
            int missed = 1;
            while (true) {
                boolean empty;
                if (e2.isCancelled()) {
                    q2.clear();
                    return;
                }
                if (errors.get() != null) {
                    q2.clear();
                    errors.tryTerminateConsumer(e2);
                    return;
                }
                boolean d2 = this.done;
                T v2 = q2.poll();
                boolean bl2 = empty = v2 == null;
                if (d2 && empty) {
                    e2.onComplete();
                    return;
                }
                if (!empty) {
                    e2.onNext(v2);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void setDisposable(b d2) {
            this.emitter.setDisposable(d2);
        }

        @Override
        public void setCancellable(f c2) {
            this.emitter.setCancellable(c2);
        }

        @Override
        public long requested() {
            return this.emitter.requested();
        }

        @Override
        public boolean isCancelled() {
            return this.emitter.isCancelled();
        }

        @Override
        public l<T> serialize() {
            return this;
        }

        @Override
        public String toString() {
            return this.emitter.toString();
        }
    }
}

