/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowableDebounce<T, U>
extends a<T, T> {
    final h<? super T, ? extends c<U>> Tu;

    public FlowableDebounce(j<T> source, h<? super T, ? extends c<U>> debounceSelector) {
        super(source);
        this.Tu = debounceSelector;
    }

    @Override
    protected void d(d<? super T> s2) {
        this.QR.a(new DebounceSubscriber(new io.reactivex.rxjava3.subscribers.e<T>(s2), this.Tu));
    }

    static final class DebounceSubscriber<T, U>
    extends AtomicLong
    implements o<T>,
    e {
        private static final long serialVersionUID = 6725975399620862591L;
        final d<? super T> downstream;
        final h<? super T, ? extends c<U>> debounceSelector;
        e upstream;
        final AtomicReference<b> debouncer = new AtomicReference();
        volatile long index;
        boolean done;

        DebounceSubscriber(d<? super T> actual, h<? super T, ? extends c<U>> debounceSelector) {
            this.downstream = actual;
            this.debounceSelector = debounceSelector;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t2) {
            c<U> p2;
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            b d2 = this.debouncer.get();
            if (d2 != null) {
                d2.dispose();
            }
            try {
                p2 = Objects.requireNonNull(this.debounceSelector.apply(t2), "The publisher supplied is null");
            }
            catch (Throwable e2) {
                io.reactivex.rxjava3.exceptions.a.k(e2);
                this.cancel();
                this.downstream.onError(e2);
                return;
            }
            a dis = new a(this, idx, t2);
            if (this.debouncer.compareAndSet(d2, dis)) {
                p2.subscribe(dis);
            }
        }

        @Override
        public void onError(Throwable t2) {
            DisposableHelper.dispose(this.debouncer);
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            b d2 = this.debouncer.get();
            if (!DisposableHelper.isDisposed(d2)) {
                a dis = (a)d2;
                if (dis != null) {
                    dis.emit();
                }
                DisposableHelper.dispose(this.debouncer);
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this, n2);
            }
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            DisposableHelper.dispose(this.debouncer);
        }

        void emit(long idx, T value) {
            if (idx == this.index) {
                long r2 = this.get();
                if (r2 != 0L) {
                    this.downstream.onNext(value);
                    io.reactivex.rxjava3.internal.util.b.c(this, 1L);
                } else {
                    this.cancel();
                    this.downstream.onError(MissingBackpressureException.createDefault());
                }
            }
        }

        static final class a<T, U>
        extends io.reactivex.rxjava3.subscribers.b<U> {
            final DebounceSubscriber<T, U> Tv;
            final long Tw;
            final T Tx;
            boolean done;
            final AtomicBoolean Ty = new AtomicBoolean();

            a(DebounceSubscriber<T, U> parent, long index, T value) {
                this.Tv = parent;
                this.Tw = index;
                this.Tx = value;
            }

            @Override
            public void onNext(U t2) {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.ss();
                this.emit();
            }

            void emit() {
                if (this.Ty.compareAndSet(false, true)) {
                    this.Tv.emit(this.Tw, this.Tx);
                }
            }

            @Override
            public void onError(Throwable t2) {
                if (this.done) {
                    io.reactivex.rxjava3.d.a.onError(t2);
                    return;
                }
                this.done = true;
                this.Tv.onError(t2);
            }

            @Override
            public void onComplete() {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.emit();
            }
        }
    }
}

