/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.g;
import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class FlowableDebounceTimed<T>
extends a<T, T> {
    final long Tz;
    final TimeUnit TA;
    final ah TB;
    final g<? super T> TC;

    public FlowableDebounceTimed(j<T> source, long timeout, TimeUnit unit, ah scheduler, g<? super T> onDropped) {
        super(source);
        this.Tz = timeout;
        this.TA = unit;
        this.TB = scheduler;
        this.TC = onDropped;
    }

    @Override
    protected void d(d<? super T> s2) {
        this.QR.a(new DebounceTimedSubscriber<T>(new io.reactivex.rxjava3.subscribers.e<T>(s2), this.Tz, this.TA, this.TB.oS(), this.TC));
    }

    static final class DebounceEmitter<T>
    extends AtomicReference<b>
    implements b,
    Runnable {
        private static final long serialVersionUID = 6812032969491025141L;
        final T value;
        final long idx;
        final DebounceTimedSubscriber<T> parent;
        final AtomicBoolean once = new AtomicBoolean();

        DebounceEmitter(T value, long idx, DebounceTimedSubscriber<T> parent) {
            this.value = value;
            this.idx = idx;
            this.parent = parent;
        }

        @Override
        public void run() {
            this.emit();
        }

        void emit() {
            if (this.once.compareAndSet(false, true)) {
                this.parent.emit(this.idx, this.value, this);
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == DisposableHelper.DISPOSED;
        }

        public void setResource(b d2) {
            DisposableHelper.replace(this, d2);
        }
    }

    static final class DebounceTimedSubscriber<T>
    extends AtomicLong
    implements o<T>,
    e {
        private static final long serialVersionUID = -9102637559663639004L;
        final d<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final ah.c worker;
        final g<? super T> onDropped;
        e upstream;
        DebounceEmitter<T> timer;
        volatile long index;
        boolean done;

        DebounceTimedSubscriber(d<? super T> actual, long timeout, TimeUnit unit, ah.c worker, g<? super T> onDropped) {
            this.downstream = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.onDropped = onDropped;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t2) {
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            DebounceEmitter<T> currentEmitter = this.timer;
            if (currentEmitter != null) {
                currentEmitter.dispose();
            }
            if (this.onDropped != null && currentEmitter != null) {
                try {
                    this.onDropped.accept(currentEmitter.value);
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    this.upstream.cancel();
                    this.done = true;
                    this.downstream.onError(ex);
                    this.worker.dispose();
                }
            }
            DebounceEmitter<T> newEmitter = new DebounceEmitter<T>(t2, idx, this);
            this.timer = newEmitter;
            newEmitter.setResource(this.worker.b(newEmitter, this.timeout, this.unit));
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
                return;
            }
            this.done = true;
            DebounceEmitter<T> d2 = this.timer;
            if (d2 != null) {
                d2.dispose();
            }
            this.downstream.onError(t2);
            this.worker.dispose();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            DebounceEmitter<T> d2 = this.timer;
            if (d2 != null) {
                d2.dispose();
            }
            if (d2 != null) {
                d2.emit();
            }
            this.downstream.onComplete();
            this.worker.dispose();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this, n2);
            }
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            this.worker.dispose();
        }

        void emit(long idx, T t2, DebounceEmitter<T> emitter) {
            if (idx == this.index) {
                long r2 = this.get();
                if (r2 != 0L) {
                    this.downstream.onNext(t2);
                    io.reactivex.rxjava3.internal.util.b.c(this, 1L);
                    emitter.dispose();
                } else {
                    this.cancel();
                    this.downstream.onError(MissingBackpressureException.createDefault());
                }
            }
        }
    }
}

