/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.operators.flowable.ba;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.f;
import io.reactivex.rxjava3.operators.g;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowableFlatMap<T, U>
extends a<T, U> {
    final h<? super T, ? extends c<? extends U>> UY;
    final boolean UZ;
    final int Va;
    final int Vb;

    public FlowableFlatMap(j<T> source, h<? super T, ? extends c<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        super(source);
        this.UY = mapper;
        this.UZ = delayErrors;
        this.Va = maxConcurrency;
        this.Vb = bufferSize;
    }

    @Override
    protected void d(d<? super U> s2) {
        if (ba.a(this.QR, s2, this.UY)) {
            return;
        }
        this.QR.a(FlowableFlatMap.a(s2, this.UY, this.UZ, this.Va, this.Vb));
    }

    public static <T, U> o<T> a(d<? super U> s2, h<? super T, ? extends c<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        return new MergeSubscriber<T, U>(s2, mapper, delayErrors, maxConcurrency, bufferSize);
    }

    static final class InnerSubscriber<T, U>
    extends AtomicReference<e>
    implements o<U>,
    b {
        private static final long serialVersionUID = -4606175640614850599L;
        final long id;
        final MergeSubscriber<T, U> parent;
        final int limit;
        final int bufferSize;
        volatile boolean done;
        volatile g<U> queue;
        long produced;
        int fusionMode;

        InnerSubscriber(MergeSubscriber<T, U> parent, int bufferSize, long id) {
            this.id = id;
            this.parent = parent;
            this.bufferSize = bufferSize;
            this.limit = bufferSize >> 2;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.setOnce(this, s2)) {
                if (s2 instanceof io.reactivex.rxjava3.operators.d) {
                    io.reactivex.rxjava3.operators.d qs = (io.reactivex.rxjava3.operators.d)s2;
                    int m2 = qs.requestFusion(7);
                    if (m2 == 1) {
                        this.fusionMode = m2;
                        this.queue = qs;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m2 == 2) {
                        this.fusionMode = m2;
                        this.queue = qs;
                    }
                }
                s2.request(this.bufferSize);
            }
        }

        @Override
        public void onNext(U t2) {
            if (this.fusionMode != 2) {
                this.parent.tryEmit(t2, this);
            } else {
                this.parent.drain();
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.lazySet(SubscriptionHelper.CANCELLED);
            this.parent.innerError(this, t2);
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        void requestMore(long n2) {
            if (this.fusionMode != 1) {
                long p2 = this.produced + n2;
                if (p2 >= (long)this.limit) {
                    this.produced = 0L;
                    ((e)this.get()).request(p2);
                } else {
                    this.produced = p2;
                }
            }
        }

        @Override
        public void dispose() {
            SubscriptionHelper.cancel(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == SubscriptionHelper.CANCELLED;
        }
    }

    static final class MergeSubscriber<T, U>
    extends AtomicInteger
    implements o<T>,
    e {
        private static final long serialVersionUID = -2117620485640801370L;
        final d<? super U> downstream;
        final h<? super T, ? extends c<? extends U>> mapper;
        final boolean delayErrors;
        final int maxConcurrency;
        final int bufferSize;
        volatile f<U> queue;
        volatile boolean done;
        final AtomicThrowable errors = new AtomicThrowable();
        volatile boolean cancelled;
        final AtomicReference<InnerSubscriber<?, ?>[]> subscribers = new AtomicReference();
        static final InnerSubscriber<?, ?>[] EMPTY = new InnerSubscriber[0];
        static final InnerSubscriber<?, ?>[] CANCELLED = new InnerSubscriber[0];
        final AtomicLong requested = new AtomicLong();
        e upstream;
        long uniqueId;
        long lastId;
        int lastIndex;
        int scalarEmitted;
        final int scalarLimit;

        MergeSubscriber(d<? super U> actual, h<? super T, ? extends c<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
            this.downstream = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.maxConcurrency = maxConcurrency;
            this.bufferSize = bufferSize;
            this.scalarLimit = Math.max(1, maxConcurrency >> 1);
            this.subscribers.lazySet(EMPTY);
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                if (!this.cancelled) {
                    if (this.maxConcurrency == Integer.MAX_VALUE) {
                        s2.request(Long.MAX_VALUE);
                    } else {
                        s2.request(this.maxConcurrency);
                    }
                }
            }
        }

        @Override
        public void onNext(T t2) {
            InnerSubscriber inner;
            c<U> p2;
            if (this.done) {
                return;
            }
            try {
                p2 = Objects.requireNonNull(this.mapper.apply(t2), "The mapper returned a null Publisher");
            }
            catch (Throwable e2) {
                io.reactivex.rxjava3.exceptions.a.k(e2);
                this.upstream.cancel();
                this.onError(e2);
                return;
            }
            if (p2 instanceof s) {
                Object u2;
                try {
                    u2 = ((s)((Object)p2)).get();
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    this.errors.tryAddThrowableOrReport(ex);
                    this.drain();
                    return;
                }
                if (u2 != null) {
                    this.tryEmitScalar(u2);
                } else if (this.maxConcurrency != Integer.MAX_VALUE && !this.cancelled && ++this.scalarEmitted == this.scalarLimit) {
                    this.scalarEmitted = 0;
                    this.upstream.request(this.scalarLimit);
                }
            } else if (this.addInner(inner = new InnerSubscriber(this, this.bufferSize, this.uniqueId++))) {
                p2.subscribe(inner);
            }
        }

        boolean addInner(InnerSubscriber<T, U> inner) {
            InnerSubscriber[] b2;
            InnerSubscriber<?, ?>[] a2;
            do {
                if ((a2 = this.subscribers.get()) == CANCELLED) {
                    inner.dispose();
                    return false;
                }
                int n2 = a2.length;
                b2 = new InnerSubscriber[n2 + 1];
                System.arraycopy(a2, 0, b2, 0, n2);
                b2[n2] = inner;
            } while (!this.subscribers.compareAndSet(a2, b2));
            return true;
        }

        void removeInner(InnerSubscriber<T, U> inner) {
            InnerSubscriber<?, ?>[] b2;
            InnerSubscriber<?, ?>[] a2;
            do {
                int n2;
                if ((n2 = (a2 = this.subscribers.get()).length) == 0) {
                    return;
                }
                int j2 = -1;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (a2[i2] != inner) continue;
                    j2 = i2;
                    break;
                }
                if (j2 < 0) {
                    return;
                }
                if (n2 == 1) {
                    b2 = EMPTY;
                    continue;
                }
                b2 = new InnerSubscriber[n2 - 1];
                System.arraycopy(a2, 0, b2, 0, j2);
                System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
            } while (!this.subscribers.compareAndSet(a2, b2));
        }

        g<U> getMainQueue() {
            f<U> q2 = this.queue;
            if (q2 == null) {
                q2 = this.maxConcurrency == Integer.MAX_VALUE ? new io.reactivex.rxjava3.operators.h<U>(this.bufferSize) : new SpscArrayQueue<U>(this.maxConcurrency);
                this.queue = q2;
            }
            return q2;
        }

        void tryEmitScalar(U value) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long r2 = this.requested.get();
                g<U> q2 = this.queue;
                if (r2 != 0L && (q2 == null || q2.isEmpty())) {
                    this.downstream.onNext(value);
                    if (r2 != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    if (this.maxConcurrency != Integer.MAX_VALUE && !this.cancelled && ++this.scalarEmitted == this.scalarLimit) {
                        this.scalarEmitted = 0;
                        this.upstream.request(this.scalarLimit);
                    }
                } else {
                    if (q2 == null) {
                        q2 = this.getMainQueue();
                    }
                    if (!q2.offer(value)) {
                        this.onError(new QueueOverflowException());
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                g<U> q3 = this.getMainQueue();
                if (!q3.offer(value)) {
                    this.onError(new QueueOverflowException());
                    return;
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        void tryEmit(U value, InnerSubscriber<T, U> inner) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long r2 = this.requested.get();
                g q2 = inner.queue;
                if (r2 != 0L && (q2 == null || q2.isEmpty())) {
                    this.downstream.onNext(value);
                    if (r2 != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    inner.requestMore(1L);
                } else {
                    if (q2 == null) {
                        q2 = new SpscArrayQueue(this.bufferSize);
                        inner.queue = q2;
                    }
                    if (!q2.offer(value)) {
                        this.onError(new QueueOverflowException());
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                g q3 = inner.queue;
                if (q3 == null) {
                    q3 = new SpscArrayQueue(this.bufferSize);
                    inner.queue = q3;
                }
                if (!q3.offer(value)) {
                    this.onError(new QueueOverflowException());
                    return;
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
                return;
            }
            if (this.errors.tryAddThrowableOrReport(t2)) {
                this.done = true;
                if (!this.delayErrors) {
                    for (InnerSubscriber<?, ?> a2 : this.subscribers.getAndSet(CANCELLED)) {
                        a2.dispose();
                    }
                }
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                f<U> q2;
                this.cancelled = true;
                this.upstream.cancel();
                this.disposeAll();
                if (this.getAndIncrement() == 0 && (q2 = this.queue) != null) {
                    q2.clear();
                }
            }
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            boolean innerCompleted;
            d<U> child = this.downstream;
            int missed = 1;
            do {
                if (this.checkTerminate()) {
                    return;
                }
                f<U> svq = this.queue;
                long r2 = this.requested.get();
                boolean unbounded = r2 == Long.MAX_VALUE;
                long replenishMain = 0L;
                if (svq != null) {
                    long scalarEmission = 0L;
                    Object o2 = null;
                    while (r2 != 0L) {
                        o2 = svq.poll();
                        if (this.checkTerminate()) {
                            return;
                        }
                        if (o2 == null) break;
                        child.onNext(o2);
                        ++replenishMain;
                        ++scalarEmission;
                        --r2;
                    }
                    if (scalarEmission != 0L) {
                        r2 = unbounded ? Long.MAX_VALUE : this.requested.addAndGet(-scalarEmission);
                    }
                }
                boolean d2 = this.done;
                svq = this.queue;
                InnerSubscriber<?, ?>[] inner = this.subscribers.get();
                int n2 = inner.length;
                if (d2 && (svq == null || svq.isEmpty()) && n2 == 0) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                innerCompleted = false;
                if (n2 != 0) {
                    int i2;
                    int j2;
                    long startId = this.lastId;
                    int index = this.lastIndex;
                    if (n2 <= index || inner[index].id != startId) {
                        if (n2 <= index) {
                            index = 0;
                        }
                        j2 = index;
                        for (i2 = 0; i2 < n2 && inner[j2].id != startId; ++i2) {
                            if (++j2 != n2) continue;
                            j2 = 0;
                        }
                        index = j2;
                        this.lastIndex = j2;
                        this.lastId = inner[j2].id;
                    }
                    j2 = index;
                    block5: for (i2 = 0; i2 < n2; ++i2) {
                        g q2;
                        if (this.checkTerminate()) {
                            return;
                        }
                        InnerSubscriber<?, ?> is = inner[j2];
                        Object o3 = null;
                        while ((q2 = is.queue) != null) {
                            long produced = 0L;
                            while (r2 != 0L) {
                                if (this.checkTerminate()) {
                                    return;
                                }
                                try {
                                    o3 = q2.poll();
                                }
                                catch (Throwable ex) {
                                    io.reactivex.rxjava3.exceptions.a.k(ex);
                                    is.dispose();
                                    this.errors.tryAddThrowableOrReport(ex);
                                    if (!this.delayErrors) {
                                        this.upstream.cancel();
                                    }
                                    if (this.checkTerminate()) {
                                        return;
                                    }
                                    this.removeInner(is);
                                    innerCompleted = true;
                                    ++i2;
                                    continue block5;
                                }
                                if (o3 == null) break;
                                child.onNext(o3);
                                --r2;
                                ++produced;
                            }
                            if (produced != 0L) {
                                r2 = !unbounded ? this.requested.addAndGet(-produced) : Long.MAX_VALUE;
                                is.requestMore(produced);
                            }
                            if (r2 != 0L && o3 != null) continue;
                            break;
                        }
                        boolean innerDone = is.done;
                        g innerQueue = is.queue;
                        if (innerDone && (innerQueue == null || innerQueue.isEmpty())) {
                            this.removeInner(is);
                            if (this.checkTerminate()) {
                                return;
                            }
                            ++replenishMain;
                            innerCompleted = true;
                        }
                        if (r2 == 0L) break;
                        if (++j2 != n2) continue;
                        j2 = 0;
                    }
                    this.lastIndex = j2;
                    this.lastId = inner[j2].id;
                }
                if (replenishMain == 0L || this.cancelled) continue;
                this.upstream.request(replenishMain);
            } while (innerCompleted || (missed = this.addAndGet(-missed)) != 0);
        }

        boolean checkTerminate() {
            if (this.cancelled) {
                this.clearScalarQueue();
                return true;
            }
            if (!this.delayErrors && this.errors.get() != null) {
                this.clearScalarQueue();
                this.errors.tryTerminateConsumer(this.downstream);
                return true;
            }
            return false;
        }

        void clearScalarQueue() {
            f<U> q2 = this.queue;
            if (q2 != null) {
                q2.clear();
            }
        }

        void disposeAll() {
            InnerSubscriber<?, ?>[] a2 = this.subscribers.getAndSet(CANCELLED);
            if (a2 != CANCELLED) {
                for (InnerSubscriber<?, ?> inner : a2) {
                    inner.dispose();
                }
                this.errors.tryTerminateAndReport();
            }
        }

        void innerError(InnerSubscriber<T, U> inner, Throwable t2) {
            if (this.errors.tryAddThrowableOrReport(t2)) {
                inner.done = true;
                if (!this.delayErrors) {
                    this.upstream.cancel();
                    for (InnerSubscriber<?, ?> a2 : this.subscribers.getAndSet(CANCELLED)) {
                        a2.dispose();
                    }
                }
                this.drain();
            }
        }
    }
}

