/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.d;
import io.reactivex.rxjava3.core.g;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.a.e;

public final class FlowableFlatMapCompletable<T>
extends a<T, T> {
    final h<? super T, ? extends g> Vc;
    final int Vd;
    final boolean Ve;

    public FlowableFlatMapCompletable(j<T> source, h<? super T, ? extends g> mapper, boolean delayErrors, int maxConcurrency) {
        super(source);
        this.Vc = mapper;
        this.Ve = delayErrors;
        this.Vd = maxConcurrency;
    }

    @Override
    protected void d(org.a.d<? super T> subscriber) {
        this.QR.a(new FlatMapCompletableMainSubscriber<T>(subscriber, this.Vc, this.Ve, this.Vd));
    }

    static final class FlatMapCompletableMainSubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements o<T> {
        private static final long serialVersionUID = 8443155186132538303L;
        final org.a.d<? super T> downstream;
        final AtomicThrowable errors;
        final h<? super T, ? extends g> mapper;
        final boolean delayErrors;
        final io.reactivex.rxjava3.disposables.a set;
        final int maxConcurrency;
        e upstream;
        volatile boolean cancelled;

        FlatMapCompletableMainSubscriber(org.a.d<? super T> subscriber, h<? super T, ? extends g> mapper, boolean delayErrors, int maxConcurrency) {
            this.downstream = subscriber;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
            this.set = new io.reactivex.rxjava3.disposables.a();
            this.maxConcurrency = maxConcurrency;
            this.lazySet(1);
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                int m2 = this.maxConcurrency;
                if (m2 == Integer.MAX_VALUE) {
                    s2.request(Long.MAX_VALUE);
                } else {
                    s2.request(m2);
                }
            }
        }

        @Override
        public void onNext(T value) {
            g cs;
            try {
                cs = Objects.requireNonNull(this.mapper.apply(value), "The mapper returned a null CompletableSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.cancel();
                this.onError(ex);
                return;
            }
            this.getAndIncrement();
            InnerConsumer inner = new InnerConsumer();
            if (!this.cancelled && this.set.a((b)inner)) {
                cs.c(inner);
            }
        }

        @Override
        public void onError(Throwable e2) {
            if (this.errors.tryAddThrowableOrReport(e2)) {
                if (this.delayErrors) {
                    if (this.decrementAndGet() == 0) {
                        this.errors.tryTerminateConsumer(this.downstream);
                    } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                        this.upstream.request(1L);
                    }
                } else {
                    this.cancelled = true;
                    this.upstream.cancel();
                    this.set.dispose();
                    this.errors.tryTerminateConsumer(this.downstream);
                }
            }
        }

        @Override
        public void onComplete() {
            if (this.decrementAndGet() == 0) {
                this.errors.tryTerminateConsumer(this.downstream);
            } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                this.upstream.request(1L);
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.set.dispose();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public void request(long n2) {
        }

        @Override
        @f
        public T poll() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
        }

        @Override
        public int requestFusion(int mode) {
            return mode & 2;
        }

        void innerComplete(InnerConsumer inner) {
            this.set.c(inner);
            this.onComplete();
        }

        void innerError(InnerConsumer inner, Throwable e2) {
            this.set.c(inner);
            this.onError(e2);
        }

        final class InnerConsumer
        extends AtomicReference<b>
        implements d,
        b {
            private static final long serialVersionUID = 8606673141535671828L;

            InnerConsumer() {
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(this, d2);
            }

            @Override
            public void onComplete() {
                FlatMapCompletableMainSubscriber.this.innerComplete(this);
            }

            @Override
            public void onError(Throwable e2) {
                FlatMapCompletableMainSubscriber.this.innerError(this, e2);
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((b)this.get());
            }
        }
    }
}

