/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.a;
import io.reactivex.rxjava3.core.d;
import io.reactivex.rxjava3.core.g;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.a.c;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFlatMapCompletable;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.a.e;

public final class FlowableFlatMapCompletableCompletable<T>
extends a
implements c<T> {
    final j<T> Vf;
    final h<? super T, ? extends g> Vg;
    final int Vh;
    final boolean Vi;

    public FlowableFlatMapCompletableCompletable(j<T> source, h<? super T, ? extends g> mapper, boolean delayErrors, int maxConcurrency) {
        this.Vf = source;
        this.Vg = mapper;
        this.Vi = delayErrors;
        this.Vh = maxConcurrency;
    }

    @Override
    protected void d(d observer) {
        this.Vf.a((o<? super T>)new FlatMapCompletableMainSubscriber<T>(observer, this.Vg, this.Vi, this.Vh));
    }

    @Override
    public j<T> pB() {
        return io.reactivex.rxjava3.d.a.f(new FlowableFlatMapCompletable<T>(this.Vf, this.Vg, this.Vi, this.Vh));
    }

    static final class FlatMapCompletableMainSubscriber<T>
    extends AtomicInteger
    implements o<T>,
    b {
        private static final long serialVersionUID = 8443155186132538303L;
        final d downstream;
        final AtomicThrowable errors;
        final h<? super T, ? extends g> mapper;
        final boolean delayErrors;
        final io.reactivex.rxjava3.disposables.a set;
        final int maxConcurrency;
        e upstream;
        volatile boolean disposed;

        FlatMapCompletableMainSubscriber(d observer, h<? super T, ? extends g> mapper, boolean delayErrors, int maxConcurrency) {
            this.downstream = observer;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
            this.set = new io.reactivex.rxjava3.disposables.a();
            this.maxConcurrency = maxConcurrency;
            this.lazySet(1);
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                int m2 = this.maxConcurrency;
                if (m2 == Integer.MAX_VALUE) {
                    s2.request(Long.MAX_VALUE);
                } else {
                    s2.request(m2);
                }
            }
        }

        @Override
        public void onNext(T value) {
            g cs;
            try {
                cs = Objects.requireNonNull(this.mapper.apply(value), "The mapper returned a null CompletableSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.cancel();
                this.onError(ex);
                return;
            }
            this.getAndIncrement();
            InnerObserver inner = new InnerObserver();
            if (!this.disposed && this.set.a((b)inner)) {
                cs.c(inner);
            }
        }

        @Override
        public void onError(Throwable e2) {
            if (this.errors.tryAddThrowableOrReport(e2)) {
                if (this.delayErrors) {
                    if (this.decrementAndGet() == 0) {
                        this.errors.tryTerminateConsumer(this.downstream);
                    } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                        this.upstream.request(1L);
                    }
                } else {
                    this.disposed = true;
                    this.upstream.cancel();
                    this.set.dispose();
                    this.errors.tryTerminateConsumer(this.downstream);
                }
            }
        }

        @Override
        public void onComplete() {
            if (this.decrementAndGet() == 0) {
                this.errors.tryTerminateConsumer(this.downstream);
            } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                this.upstream.request(1L);
            }
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.upstream.cancel();
            this.set.dispose();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public boolean isDisposed() {
            return this.set.isDisposed();
        }

        void innerComplete(InnerObserver inner) {
            this.set.c(inner);
            this.onComplete();
        }

        void innerError(InnerObserver inner, Throwable e2) {
            this.set.c(inner);
            this.onError(e2);
        }

        final class InnerObserver
        extends AtomicReference<b>
        implements d,
        b {
            private static final long serialVersionUID = 8606673141535671828L;

            InnerObserver() {
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(this, d2);
            }

            @Override
            public void onComplete() {
                FlatMapCompletableMainSubscriber.this.innerComplete(this);
            }

            @Override
            public void onError(Throwable e2) {
                FlatMapCompletableMainSubscriber.this.innerError(this, e2);
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((b)this.get());
            }
        }
    }
}

