/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class FlowableFlatMapSingle<T, R>
extends a<T, R> {
    final h<? super T, ? extends ao<? extends R>> Vq;
    final boolean Vr;
    final int Vs;

    public FlowableFlatMapSingle(j<T> source, h<? super T, ? extends ao<? extends R>> mapper, boolean delayError, int maxConcurrency) {
        super(source);
        this.Vq = mapper;
        this.Vr = delayError;
        this.Vs = maxConcurrency;
    }

    @Override
    protected void d(d<? super R> s2) {
        this.QR.a(new FlatMapSingleSubscriber<T, R>(s2, this.Vq, this.Vr, this.Vs));
    }

    static final class FlatMapSingleSubscriber<T, R>
    extends AtomicInteger
    implements o<T>,
    e {
        private static final long serialVersionUID = 8600231336733376951L;
        final d<? super R> downstream;
        final boolean delayErrors;
        final int maxConcurrency;
        final AtomicLong requested;
        final io.reactivex.rxjava3.disposables.a set;
        final AtomicInteger active;
        final AtomicThrowable errors;
        final h<? super T, ? extends ao<? extends R>> mapper;
        final AtomicReference<io.reactivex.rxjava3.operators.h<R>> queue;
        e upstream;
        volatile boolean cancelled;

        FlatMapSingleSubscriber(d<? super R> actual, h<? super T, ? extends ao<? extends R>> mapper, boolean delayErrors, int maxConcurrency) {
            this.downstream = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.maxConcurrency = maxConcurrency;
            this.requested = new AtomicLong();
            this.set = new io.reactivex.rxjava3.disposables.a();
            this.errors = new AtomicThrowable();
            this.active = new AtomicInteger(1);
            this.queue = new AtomicReference();
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                int m2 = this.maxConcurrency;
                if (m2 == Integer.MAX_VALUE) {
                    s2.request(Long.MAX_VALUE);
                } else {
                    s2.request(this.maxConcurrency);
                }
            }
        }

        @Override
        public void onNext(T t2) {
            ao<R> ms;
            try {
                ms = Objects.requireNonNull(this.mapper.apply(t2), "The mapper returned a null SingleSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.cancel();
                this.onError(ex);
                return;
            }
            this.active.getAndIncrement();
            InnerObserver inner = new InnerObserver();
            if (!this.cancelled && this.set.a((b)inner)) {
                ms.c(inner);
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.active.decrementAndGet();
            if (this.errors.tryAddThrowableOrReport(t2)) {
                if (!this.delayErrors) {
                    this.set.dispose();
                }
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.active.decrementAndGet();
            this.drain();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.set.dispose();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerSuccess(InnerObserver inner, R value) {
            this.set.c(inner);
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                boolean d2;
                boolean bl2 = d2 = this.active.decrementAndGet() == 0;
                if (this.requested.get() != 0L) {
                    this.downstream.onNext(value);
                    io.reactivex.rxjava3.operators.h<R> q2 = this.queue.get();
                    if (d2 && (q2 == null || q2.isEmpty())) {
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    io.reactivex.rxjava3.internal.util.b.c(this.requested, 1L);
                    if (this.maxConcurrency != Integer.MAX_VALUE) {
                        this.upstream.request(1L);
                    }
                } else {
                    io.reactivex.rxjava3.operators.h<R> q3;
                    io.reactivex.rxjava3.operators.h<R> h2 = q3 = this.getOrCreateQueue();
                    synchronized (h2) {
                        q3.offer(value);
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                io.reactivex.rxjava3.operators.h<R> q4;
                io.reactivex.rxjava3.operators.h<R> h3 = q4 = this.getOrCreateQueue();
                synchronized (h3) {
                    q4.offer(value);
                }
                this.active.decrementAndGet();
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        io.reactivex.rxjava3.operators.h<R> getOrCreateQueue() {
            io.reactivex.rxjava3.operators.h<Object> current = this.queue.get();
            if (current != null) {
                return current;
            }
            current = new io.reactivex.rxjava3.operators.h(j.mB());
            if (this.queue.compareAndSet(null, current)) {
                return current;
            }
            return this.queue.get();
        }

        void innerError(InnerObserver inner, Throwable e2) {
            this.set.c(inner);
            if (this.errors.tryAddThrowableOrReport(e2)) {
                if (!this.delayErrors) {
                    this.upstream.cancel();
                    this.set.dispose();
                } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                    this.upstream.request(1L);
                }
                this.active.decrementAndGet();
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void clear() {
            io.reactivex.rxjava3.operators.h<R> q2 = this.queue.get();
            if (q2 != null) {
                q2.clear();
            }
        }

        void drainLoop() {
            int missed = 1;
            d<R> a2 = this.downstream;
            AtomicInteger n2 = this.active;
            AtomicReference<io.reactivex.rxjava3.operators.h<R>> qr = this.queue;
            do {
                io.reactivex.rxjava3.operators.h<R> q2;
                boolean d2;
                long e2;
                long r2 = this.requested.get();
                for (e2 = 0L; e2 != r2; ++e2) {
                    boolean empty;
                    Throwable ex;
                    if (this.cancelled) {
                        this.clear();
                        return;
                    }
                    if (!this.delayErrors && (ex = (Throwable)this.errors.get()) != null) {
                        this.clear();
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    d2 = n2.get() == 0;
                    q2 = qr.get();
                    Object v2 = q2 != null ? (Object)q2.poll() : null;
                    boolean bl2 = empty = v2 == null;
                    if (d2 && empty) {
                        this.errors.tryTerminateConsumer(a2);
                        return;
                    }
                    if (empty) break;
                    a2.onNext(v2);
                }
                if (e2 == r2) {
                    boolean empty;
                    Throwable ex;
                    if (this.cancelled) {
                        this.clear();
                        return;
                    }
                    if (!this.delayErrors && (ex = (Throwable)this.errors.get()) != null) {
                        this.clear();
                        this.errors.tryTerminateConsumer(a2);
                        return;
                    }
                    d2 = n2.get() == 0;
                    q2 = qr.get();
                    boolean bl3 = empty = q2 == null || q2.isEmpty();
                    if (d2 && empty) {
                        this.errors.tryTerminateConsumer(a2);
                        return;
                    }
                }
                if (e2 == 0L) continue;
                io.reactivex.rxjava3.internal.util.b.c(this.requested, e2);
                if (this.maxConcurrency == Integer.MAX_VALUE) continue;
                this.upstream.request(e2);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        final class InnerObserver
        extends AtomicReference<b>
        implements al<R>,
        b {
            private static final long serialVersionUID = -502562646270949838L;

            InnerObserver() {
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(this, d2);
            }

            @Override
            public void onSuccess(R value) {
                FlatMapSingleSubscriber.this.innerSuccess(this, value);
            }

            @Override
            public void onError(Throwable e2) {
                FlatMapSingleSubscriber.this.innerError(this, e2);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((b)this.get());
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

