/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFromIterable;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.g;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class FlowableFlattenIterable<T, R>
extends a<T, R> {
    final h<? super T, ? extends Iterable<? extends R>> Vx;
    final int Vy;

    public FlowableFlattenIterable(j<T> source, h<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
        super(source);
        this.Vx = mapper;
        this.Vy = prefetch;
    }

    @Override
    public void d(d<? super R> s2) {
        if (this.QR instanceof s) {
            Iterator<? extends R> it;
            Object v2;
            try {
                v2 = ((s)((Object)this.QR)).get();
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                EmptySubscription.error(ex, s2);
                return;
            }
            if (v2 == null) {
                EmptySubscription.complete(s2);
                return;
            }
            try {
                Iterable<R> iterable = this.Vx.apply(v2);
                it = iterable.iterator();
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                EmptySubscription.error(ex, s2);
                return;
            }
            FlowableFromIterable.a(s2, it);
            return;
        }
        this.QR.a(new FlattenIterableSubscriber<T, R>(s2, this.Vx, this.Vy));
    }

    public static <T, R> d<T> a(d<? super R> downstream, h<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
        return new FlattenIterableSubscriber<T, R>(downstream, mapper, prefetch);
    }

    static final class FlattenIterableSubscriber<T, R>
    extends BasicIntQueueSubscription<R>
    implements o<T> {
        private static final long serialVersionUID = -3096000382929934955L;
        final d<? super R> downstream;
        final h<? super T, ? extends Iterable<? extends R>> mapper;
        final int prefetch;
        final int limit;
        final AtomicLong requested;
        e upstream;
        g<T> queue;
        volatile boolean done;
        volatile boolean cancelled;
        final AtomicReference<Throwable> error;
        Iterator<? extends R> current;
        int consumed;
        int fusionMode;

        FlattenIterableSubscriber(d<? super R> actual, h<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
            this.downstream = actual;
            this.mapper = mapper;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.error = new AtomicReference();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                if (s2 instanceof io.reactivex.rxjava3.operators.d) {
                    io.reactivex.rxjava3.operators.d qs = (io.reactivex.rxjava3.operators.d)s2;
                    int m2 = qs.requestFusion(3);
                    if (m2 == 1) {
                        this.fusionMode = m2;
                        this.queue = qs;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                    if (m2 == 2) {
                        this.fusionMode = m2;
                        this.queue = qs;
                        this.downstream.onSubscribe(this);
                        s2.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                this.downstream.onSubscribe(this);
                s2.request(this.prefetch);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            if (this.fusionMode == 0 && !this.queue.offer(t2)) {
                this.onError(new QueueOverflowException());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            if (!this.done && ExceptionHelper.a(this.error, t2)) {
                this.done = true;
                this.drain();
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            d<R> a2 = this.downstream;
            g<T> q2 = this.queue;
            boolean replenish = this.fusionMode != 1;
            int missed = 1;
            Iterator<R> it = this.current;
            while (true) {
                if (it == null) {
                    boolean empty;
                    T t2;
                    boolean d2 = this.done;
                    try {
                        t2 = q2.poll();
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        this.upstream.cancel();
                        ExceptionHelper.a(this.error, ex);
                        ex = ExceptionHelper.a(this.error);
                        this.current = null;
                        q2.clear();
                        a2.onError(ex);
                        return;
                    }
                    boolean bl2 = empty = t2 == null;
                    if (this.checkTerminated(d2, empty, a2, q2)) {
                        return;
                    }
                    if (t2 != null) {
                        boolean b2;
                        try {
                            Iterable<R> iterable = this.mapper.apply(t2);
                            it = iterable.iterator();
                            b2 = it.hasNext();
                        }
                        catch (Throwable ex) {
                            io.reactivex.rxjava3.exceptions.a.k(ex);
                            this.upstream.cancel();
                            ExceptionHelper.a(this.error, ex);
                            ex = ExceptionHelper.a(this.error);
                            a2.onError(ex);
                            return;
                        }
                        if (!b2) {
                            it = null;
                            this.consumedOne(replenish);
                            continue;
                        }
                        this.current = it;
                    }
                }
                if (it != null) {
                    long e2;
                    long r2 = this.requested.get();
                    for (e2 = 0L; e2 != r2; ++e2) {
                        R v2;
                        if (this.checkTerminated(this.done, false, a2, q2)) {
                            return;
                        }
                        try {
                            v2 = Objects.requireNonNull(it.next(), "The iterator returned a null value");
                        }
                        catch (Throwable ex) {
                            io.reactivex.rxjava3.exceptions.a.k(ex);
                            this.current = null;
                            this.upstream.cancel();
                            ExceptionHelper.a(this.error, ex);
                            ex = ExceptionHelper.a(this.error);
                            a2.onError(ex);
                            return;
                        }
                        a2.onNext(v2);
                        if (this.checkTerminated(this.done, false, a2, q2)) {
                            return;
                        }
                        try {
                            boolean b3 = it.hasNext();
                            continue;
                        }
                        catch (Throwable ex) {
                            io.reactivex.rxjava3.exceptions.a.k(ex);
                            this.current = null;
                            this.upstream.cancel();
                            ExceptionHelper.a(this.error, ex);
                            ex = ExceptionHelper.a(this.error);
                            a2.onError(ex);
                            return;
                        }
                    }
                    if (e2 == r2) {
                        boolean empty;
                        boolean d3 = this.done;
                        boolean bl3 = empty = q2.isEmpty() && it == null;
                        if (this.checkTerminated(d3, empty, a2, q2)) {
                            return;
                        }
                    }
                    if (e2 != 0L && r2 != Long.MAX_VALUE) {
                        this.requested.addAndGet(-e2);
                    }
                    if (it == null) continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void consumedOne(boolean enabled) {
            if (enabled) {
                int c2 = this.consumed + 1;
                if (c2 == this.limit) {
                    this.consumed = 0;
                    this.upstream.request(c2);
                } else {
                    this.consumed = c2;
                }
            }
        }

        boolean checkTerminated(boolean d2, boolean empty, d<?> a2, g<?> q2) {
            if (this.cancelled) {
                this.current = null;
                q2.clear();
                return true;
            }
            if (d2) {
                Throwable ex = this.error.get();
                if (ex != null) {
                    ex = ExceptionHelper.a(this.error);
                    this.current = null;
                    q2.clear();
                    a2.onError(ex);
                    return true;
                }
                if (empty) {
                    a2.onComplete();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void clear() {
            this.current = null;
            this.queue.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.current == null && this.queue.isEmpty();
        }

        @Override
        @f
        public R poll() throws Throwable {
            Iterator<R> it = this.current;
            while (it == null) {
                T v2 = this.queue.poll();
                if (v2 == null) {
                    return null;
                }
                it = this.mapper.apply(v2).iterator();
                if (!it.hasNext()) {
                    it = null;
                    continue;
                }
                this.current = it;
                break;
            }
            R r2 = Objects.requireNonNull(it.next(), "The iterator returned a null value");
            if (!it.hasNext()) {
                this.current = null;
            }
            return r2;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 1) != 0 && this.fusionMode == 1) {
                return 1;
            }
            return 0;
        }
    }
}

