/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.subscriptions.BasicQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import java.util.Iterator;
import java.util.Objects;
import org.a.d;

public final class FlowableFromIterable<T>
extends j<T> {
    final Iterable<? extends T> VH;

    public FlowableFromIterable(Iterable<? extends T> source) {
        this.VH = source;
    }

    @Override
    public void d(d<? super T> s2) {
        Iterator<? extends T> it;
        try {
            it = this.VH.iterator();
        }
        catch (Throwable e2) {
            a.k(e2);
            EmptySubscription.error(e2, s2);
            return;
        }
        FlowableFromIterable.a(s2, it);
    }

    public static <T> void a(d<? super T> s2, Iterator<? extends T> it) {
        boolean hasNext;
        try {
            hasNext = it.hasNext();
        }
        catch (Throwable e2) {
            a.k(e2);
            EmptySubscription.error(e2, s2);
            return;
        }
        if (!hasNext) {
            EmptySubscription.complete(s2);
            return;
        }
        if (s2 instanceof io.reactivex.rxjava3.operators.a) {
            s2.onSubscribe(new IteratorConditionalSubscription<T>((io.reactivex.rxjava3.operators.a)s2, it));
        } else {
            s2.onSubscribe(new IteratorSubscription<T>(s2, it));
        }
    }

    static final class IteratorConditionalSubscription<T>
    extends BaseRangeSubscription<T> {
        private static final long serialVersionUID = -6022804456014692607L;
        final io.reactivex.rxjava3.operators.a<? super T> downstream;

        IteratorConditionalSubscription(io.reactivex.rxjava3.operators.a<? super T> actual, Iterator<? extends T> it) {
            super(it);
            this.downstream = actual;
        }

        @Override
        void fastPath() {
            boolean b2;
            Iterator it = this.iterator;
            io.reactivex.rxjava3.operators.a a2 = this.downstream;
            do {
                Object t2;
                if (this.cancelled) {
                    return;
                }
                try {
                    t2 = it.next();
                }
                catch (Throwable ex) {
                    a.k(ex);
                    a2.onError(ex);
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                if (t2 == null) {
                    a2.onError(new NullPointerException("Iterator.next() returned a null value"));
                    return;
                }
                a2.tryOnNext(t2);
                if (this.cancelled) {
                    return;
                }
                try {
                    b2 = it.hasNext();
                }
                catch (Throwable ex) {
                    a.k(ex);
                    a2.onError(ex);
                    return;
                }
            } while (b2);
            if (!this.cancelled) {
                a2.onComplete();
            }
        }

        @Override
        void slowPath(long r2) {
            long e2 = 0L;
            Iterator it = this.iterator;
            io.reactivex.rxjava3.operators.a a2 = this.downstream;
            while (true) {
                if (e2 != r2) {
                    boolean hasNext;
                    Object t2;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        t2 = it.next();
                    }
                    catch (Throwable ex) {
                        a.k(ex);
                        a2.onError(ex);
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (t2 == null) {
                        a2.onError(new NullPointerException("Iterator.next() returned a null value"));
                        return;
                    }
                    boolean b2 = a2.tryOnNext(t2);
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        hasNext = it.hasNext();
                    }
                    catch (Throwable ex) {
                        a.k(ex);
                        a2.onError(ex);
                        return;
                    }
                    if (!hasNext) {
                        if (!this.cancelled) {
                            a2.onComplete();
                        }
                        return;
                    }
                    if (!b2) continue;
                    ++e2;
                    continue;
                }
                r2 = this.get();
                if (e2 != r2) continue;
                r2 = this.addAndGet(-e2);
                if (r2 == 0L) {
                    return;
                }
                e2 = 0L;
            }
        }
    }

    static final class IteratorSubscription<T>
    extends BaseRangeSubscription<T> {
        private static final long serialVersionUID = -6022804456014692607L;
        final d<? super T> downstream;

        IteratorSubscription(d<? super T> actual, Iterator<? extends T> it) {
            super(it);
            this.downstream = actual;
        }

        @Override
        void fastPath() {
            boolean b2;
            Iterator it = this.iterator;
            d a2 = this.downstream;
            do {
                Object t2;
                if (this.cancelled) {
                    return;
                }
                try {
                    t2 = it.next();
                }
                catch (Throwable ex) {
                    a.k(ex);
                    a2.onError(ex);
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                if (t2 == null) {
                    a2.onError(new NullPointerException("Iterator.next() returned a null value"));
                    return;
                }
                a2.onNext(t2);
                if (this.cancelled) {
                    return;
                }
                try {
                    b2 = it.hasNext();
                }
                catch (Throwable ex) {
                    a.k(ex);
                    a2.onError(ex);
                    return;
                }
            } while (b2);
            if (!this.cancelled) {
                a2.onComplete();
            }
        }

        @Override
        void slowPath(long r2) {
            long e2 = 0L;
            Iterator it = this.iterator;
            d a2 = this.downstream;
            while (true) {
                if (e2 != r2) {
                    boolean b2;
                    Object t2;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        t2 = it.next();
                    }
                    catch (Throwable ex) {
                        a.k(ex);
                        a2.onError(ex);
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (t2 == null) {
                        a2.onError(new NullPointerException("Iterator.next() returned a null value"));
                        return;
                    }
                    a2.onNext(t2);
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        b2 = it.hasNext();
                    }
                    catch (Throwable ex) {
                        a.k(ex);
                        a2.onError(ex);
                        return;
                    }
                    if (!b2) {
                        if (!this.cancelled) {
                            a2.onComplete();
                        }
                        return;
                    }
                    ++e2;
                    continue;
                }
                r2 = this.get();
                if (e2 != r2) continue;
                r2 = this.addAndGet(-e2);
                if (r2 == 0L) {
                    return;
                }
                e2 = 0L;
            }
        }
    }

    static abstract class BaseRangeSubscription<T>
    extends BasicQueueSubscription<T> {
        private static final long serialVersionUID = -2252972430506210021L;
        Iterator<? extends T> iterator;
        volatile boolean cancelled;
        boolean once;

        BaseRangeSubscription(Iterator<? extends T> it) {
            this.iterator = it;
        }

        @Override
        public final int requestFusion(int mode) {
            return mode & 1;
        }

        @Override
        @f
        public final T poll() {
            if (this.iterator == null) {
                return null;
            }
            if (!this.once) {
                this.once = true;
            } else if (!this.iterator.hasNext()) {
                return null;
            }
            return Objects.requireNonNull(this.iterator.next(), "Iterator.next() returned a null value");
        }

        @Override
        public final boolean isEmpty() {
            Iterator<T> it = this.iterator;
            if (it != null) {
                if (!this.once || it.hasNext()) {
                    return false;
                }
                this.clear();
            }
            return true;
        }

        @Override
        public final void clear() {
            this.iterator = null;
        }

        @Override
        public final void request(long n2) {
            if (SubscriptionHelper.validate(n2) && b.a(this, n2) == 0L) {
                if (n2 == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n2);
                }
            }
        }

        @Override
        public final void cancel() {
            this.cancelled = true;
        }

        abstract void fastPath();

        abstract void slowPath(long var1);
    }
}

