/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.b.g;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.EmptyComponent;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowableGroupBy<T, K, V>
extends io.reactivex.rxjava3.internal.operators.flowable.a<T, io.reactivex.rxjava3.a.b<K, V>> {
    final h<? super T, ? extends K> VQ;
    final h<? super T, ? extends V> VR;
    final int VS;
    final boolean VT;
    final h<? super g<Object>, ? extends Map<K, Object>> VU;

    public FlowableGroupBy(j<T> source, h<? super T, ? extends K> keySelector, h<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError, h<? super g<Object>, ? extends Map<K, Object>> mapFactory) {
        super(source);
        this.VQ = keySelector;
        this.VR = valueSelector;
        this.VS = bufferSize;
        this.VT = delayError;
        this.VU = mapFactory;
    }

    @Override
    protected void d(d<? super io.reactivex.rxjava3.a.b<K, V>> s2) {
        ConcurrentHashMap groups;
        ConcurrentLinkedQueue evictedGroups;
        try {
            if (this.VU == null) {
                evictedGroups = null;
                groups = new ConcurrentHashMap();
            } else {
                evictedGroups = new ConcurrentLinkedQueue();
                a evictionAction = new a(evictedGroups);
                groups = this.VU.apply(evictionAction);
            }
        }
        catch (Throwable e2) {
            io.reactivex.rxjava3.exceptions.a.k(e2);
            s2.onSubscribe(EmptyComponent.INSTANCE);
            s2.onError(e2);
            return;
        }
        GroupBySubscriber<? super T, ? extends K, ? extends V> subscriber = new GroupBySubscriber<T, K, V>(s2, this.VQ, this.VR, this.VS, this.VT, groups, evictedGroups);
        this.QR.a(subscriber);
    }

    static final class State<T, K>
    extends BasicIntQueueSubscription<T>
    implements c<T> {
        private static final long serialVersionUID = -3852313036005250360L;
        final K key;
        final io.reactivex.rxjava3.operators.h<T> queue;
        final GroupBySubscriber<?, K, T> parent;
        final boolean delayError;
        final AtomicLong requested = new AtomicLong();
        volatile boolean done;
        Throwable error;
        final AtomicBoolean cancelled = new AtomicBoolean();
        final AtomicReference<d<? super T>> actual = new AtomicReference();
        boolean outputFused;
        int produced;
        final AtomicInteger once = new AtomicInteger();
        static final int FRESH = 0;
        static final int HAS_SUBSCRIBER = 1;
        static final int ABANDONED = 2;
        static final int ABANDONED_HAS_SUBSCRIBER = 3;
        final AtomicBoolean evictOnce = new AtomicBoolean();

        State(int bufferSize, GroupBySubscriber<?, K, T> parent, K key, boolean delayError) {
            this.queue = new io.reactivex.rxjava3.operators.h(bufferSize);
            this.parent = parent;
            this.key = key;
            this.delayError = delayError;
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.cancelParent();
                this.drain();
            }
        }

        @Override
        public void subscribe(d<? super T> subscriber) {
            int s2;
            while (((s2 = this.once.get()) & 1) == 0) {
                int u2 = s2 | 1;
                if (!this.once.compareAndSet(s2, u2)) continue;
                subscriber.onSubscribe(this);
                this.actual.lazySet(subscriber);
                if (this.cancelled.get()) {
                    this.actual.lazySet(null);
                } else {
                    this.drain();
                }
                return;
            }
            EmptySubscription.error(new IllegalStateException("Only one Subscriber allowed!"), subscriber);
        }

        public void onNext(T t2) {
            this.queue.offer(t2);
            this.drain();
        }

        public void onError(Throwable e2) {
            this.error = e2;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        boolean tryComplete() {
            boolean canEvict = this.evictOnce.compareAndSet(false, true);
            this.done = true;
            this.drain();
            return canEvict;
        }

        void cancelParent() {
            if ((this.once.get() & 2) == 0 && this.evictOnce.compareAndSet(false, true)) {
                this.parent.cancel(this.key);
            }
        }

        boolean tryAbandon() {
            return this.once.get() == 0 && this.once.compareAndSet(0, 2);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            if (this.outputFused) {
                this.drainFused();
            } else {
                this.drainNormal();
            }
        }

        void drainFused() {
            int missed = 1;
            io.reactivex.rxjava3.operators.h<T> q2 = this.queue;
            d<T> a2 = this.actual.get();
            while (true) {
                if (a2 != null) {
                    Throwable ex;
                    if (this.cancelled.get()) {
                        return;
                    }
                    boolean d2 = this.done;
                    if (d2 && !this.delayError && (ex = this.error) != null) {
                        q2.clear();
                        a2.onError(ex);
                        return;
                    }
                    a2.onNext(null);
                    if (d2) {
                        ex = this.error;
                        if (ex != null) {
                            a2.onError(ex);
                        } else {
                            a2.onComplete();
                        }
                        return;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) {
                    return;
                }
                if (a2 != null) continue;
                a2 = this.actual.get();
            }
        }

        void drainNormal() {
            int missed = 1;
            io.reactivex.rxjava3.operators.h<T> q2 = this.queue;
            boolean delayError = this.delayError;
            d<T> a2 = this.actual.get();
            AtomicBoolean cancelled = this.cancelled;
            block0: while (true) {
                if (cancelled.get()) {
                    this.cleanupQueue(0L, false);
                } else if (a2 != null) {
                    long e2;
                    long r2 = this.requested.get();
                    for (e2 = 0L; e2 != r2; ++e2) {
                        boolean d2 = this.done;
                        T v2 = q2.poll();
                        boolean empty = v2 == null;
                        if (this.checkTerminated(d2, empty, a2, delayError, e2, !empty)) continue block0;
                        if (empty) break;
                        a2.onNext(v2);
                    }
                    if (e2 == r2 && this.checkTerminated(this.done, q2.isEmpty(), a2, delayError, e2, false)) continue;
                    if (e2 != 0L) {
                        io.reactivex.rxjava3.internal.util.b.c(this.requested, e2);
                        this.requestParent(e2);
                    }
                }
                missed = this.addAndGet(-missed);
                if (missed == 0) break;
                if (a2 != null) continue;
                a2 = this.actual.get();
            }
        }

        void requestParent(long e2) {
            if ((this.once.get() & 2) == 0) {
                this.parent.requestGroup(e2);
            }
        }

        void cleanupQueue(long emitted, boolean polled) {
            while (this.queue.poll() != null) {
                ++emitted;
            }
            this.replenishParent(emitted, polled);
        }

        void replenishParent(long emitted, boolean polled) {
            if (polled) {
                ++emitted;
            }
            if (emitted != 0L) {
                this.requestParent(emitted);
            }
        }

        boolean checkTerminated(boolean d2, boolean empty, d<? super T> a2, boolean delayError, long emitted, boolean polled) {
            if (this.cancelled.get()) {
                this.cleanupQueue(emitted, polled);
                return true;
            }
            if (d2) {
                if (delayError) {
                    if (empty) {
                        this.cancelled.lazySet(true);
                        Throwable e2 = this.error;
                        if (e2 != null) {
                            a2.onError(e2);
                        } else {
                            a2.onComplete();
                            this.replenishParent(emitted, polled);
                        }
                        return true;
                    }
                } else {
                    Throwable e3 = this.error;
                    if (e3 != null) {
                        this.queue.clear();
                        this.cancelled.lazySet(true);
                        a2.onError(e3);
                        return true;
                    }
                    if (empty) {
                        this.cancelled.lazySet(true);
                        a2.onComplete();
                        this.replenishParent(emitted, polled);
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public int requestFusion(int mode) {
            return 0;
        }

        void tryReplenish() {
            int p2 = this.produced;
            if (p2 != 0) {
                this.produced = 0;
                this.requestParent(p2);
            }
        }

        @Override
        @f
        public T poll() {
            T v2 = this.queue.poll();
            if (v2 != null) {
                ++this.produced;
                return v2;
            }
            this.tryReplenish();
            return null;
        }

        @Override
        public boolean isEmpty() {
            if (this.queue.isEmpty()) {
                this.tryReplenish();
                return true;
            }
            this.tryReplenish();
            return false;
        }

        @Override
        public void clear() {
            io.reactivex.rxjava3.operators.h<T> q2 = this.queue;
            while (q2.poll() != null) {
                ++this.produced;
            }
            this.tryReplenish();
        }
    }

    static final class b<K, T>
    extends io.reactivex.rxjava3.a.b<K, T> {
        final State<T, K> VW;

        public static <T, K> b<K, T> a(K key, int bufferSize, GroupBySubscriber<?, K, T> parent, boolean delayError) {
            State<T, K> state = new State<T, K>(bufferSize, parent, key, delayError);
            return new b<K, T>(key, state);
        }

        protected b(K key, State<T, K> state) {
            super(key);
            this.VW = state;
        }

        @Override
        protected void d(d<? super T> s2) {
            this.VW.subscribe(s2);
        }

        public void onNext(T t2) {
            this.VW.onNext(t2);
        }

        public void onError(Throwable e2) {
            this.VW.onError(e2);
        }

        public void onComplete() {
            this.VW.onComplete();
        }
    }

    static final class a<K, V>
    implements g<b<K, V>> {
        final Queue<b<K, V>> VV;

        a(Queue<b<K, V>> evictedGroups) {
            this.VV = evictedGroups;
        }

        public void a(b<K, V> value) {
            this.VV.offer(value);
        }

        @Override
        public /* synthetic */ void accept(Object object) throws Throwable {
            this.a((b)object);
        }
    }

    public static final class GroupBySubscriber<T, K, V>
    extends AtomicLong
    implements o<T>,
    e {
        private static final long serialVersionUID = -3688291656102519502L;
        final d<? super io.reactivex.rxjava3.a.b<K, V>> downstream;
        final h<? super T, ? extends K> keySelector;
        final h<? super T, ? extends V> valueSelector;
        final int bufferSize;
        final int limit;
        final boolean delayError;
        final Map<Object, b<K, V>> groups;
        final Queue<b<K, V>> evictedGroups;
        static final Object NULL_KEY = new Object();
        e upstream;
        final AtomicBoolean cancelled = new AtomicBoolean();
        long emittedGroups;
        final AtomicInteger groupCount = new AtomicInteger(1);
        final AtomicLong groupConsumed = new AtomicLong();
        boolean done;

        public GroupBySubscriber(d<? super io.reactivex.rxjava3.a.b<K, V>> actual, h<? super T, ? extends K> keySelector, h<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError, Map<Object, b<K, V>> groups, Queue<b<K, V>> evictedGroups) {
            this.downstream = actual;
            this.keySelector = keySelector;
            this.valueSelector = valueSelector;
            this.bufferSize = bufferSize;
            this.limit = bufferSize - (bufferSize >> 2);
            this.delayError = delayError;
            this.groups = groups;
            this.evictedGroups = evictedGroups;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(this.bufferSize);
            }
        }

        @Override
        public void onNext(T t2) {
            V v2;
            K key;
            if (this.done) {
                return;
            }
            try {
                key = this.keySelector.apply(t2);
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.cancel();
                this.onError(ex);
                return;
            }
            boolean newGroup = false;
            Object mapKey = key != null ? key : NULL_KEY;
            b<K, Object> group = this.groups.get(mapKey);
            if (group == null) {
                if (this.cancelled.get()) {
                    return;
                }
                group = b.a(key, this.bufferSize, this, this.delayError);
                this.groups.put(mapKey, group);
                this.groupCount.getAndIncrement();
                newGroup = true;
            }
            try {
                v2 = ExceptionHelper.e(this.valueSelector.apply(t2), "The valueSelector returned a null value.");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.cancel();
                if (newGroup) {
                    if (this.emittedGroups != this.get()) {
                        this.downstream.onNext(group);
                    } else {
                        MissingBackpressureException mbe = GroupBySubscriber.groupHangWarning(this.emittedGroups);
                        mbe.initCause(ex);
                        this.onError(mbe);
                        return;
                    }
                }
                this.onError(ex);
                return;
            }
            group.onNext(v2);
            this.qe();
            if (newGroup) {
                if (this.emittedGroups != this.get()) {
                    ++this.emittedGroups;
                    this.downstream.onNext(group);
                    if (group.VW.tryAbandon()) {
                        this.cancel(key);
                        group.onComplete();
                        this.requestGroup(1L);
                    }
                } else {
                    this.upstream.cancel();
                    this.onError(GroupBySubscriber.groupHangWarning(this.emittedGroups));
                }
            }
        }

        static MissingBackpressureException groupHangWarning(long n2) {
            return new MissingBackpressureException("Unable to emit a new group (#" + n2 + ") due to lack of requests. Please make sure the downstream can always accept a new group as well as each group is consumed in order for the whole operator to be able to proceed.");
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
                return;
            }
            this.done = true;
            for (b<K, V> g2 : this.groups.values()) {
                g2.onError(t2);
            }
            this.groups.clear();
            this.qe();
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                for (b<K, V> g2 : this.groups.values()) {
                    g2.onComplete();
                }
                this.groups.clear();
                this.qe();
                this.done = true;
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this, n2);
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.qe();
                if (this.groupCount.decrementAndGet() == 0) {
                    this.upstream.cancel();
                }
            }
        }

        private void qe() {
            if (this.evictedGroups != null) {
                b<K, V> evictedGroup;
                int count = 0;
                while ((evictedGroup = this.evictedGroups.poll()) != null) {
                    if (!evictedGroup.VW.tryComplete()) continue;
                    ++count;
                }
                if (count != 0) {
                    this.groupCount.addAndGet(-count);
                }
            }
        }

        public void cancel(K key) {
            Object mapKey;
            Object object = mapKey = key != null ? key : NULL_KEY;
            if (this.groups.remove(mapKey) != null && this.groupCount.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }

        void requestGroup(long n2) {
            long newConsumed;
            long currentConsumed;
            AtomicLong groupConsumed = this.groupConsumed;
            int limit = this.limit;
            while (!groupConsumed.compareAndSet(currentConsumed = groupConsumed.get(), newConsumed = io.reactivex.rxjava3.internal.util.b.g(currentConsumed, n2))) {
            }
            while (newConsumed >= (long)limit) {
                long newConsumedAfterLimit = newConsumed - (long)limit;
                if (groupConsumed.compareAndSet(newConsumed, newConsumedAfterLimit)) {
                    this.upstream.request(limit);
                }
                newConsumed = groupConsumed.get();
            }
            return;
        }
    }
}

